/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui;

import java.awt.Dialog;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.ui.BrokenDatasourceAlertPanel;
import org.netbeans.modules.j2ee.common.ui.J2EEUISettings;
import org.netbeans.modules.j2ee.common.ui.MissingDatabaseConnectionWarning;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class BrokenDatasourceSupport {
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;

    private BrokenDatasourceSupport() {
    }

    public static void fixDatasources(Project project) {
        MissingDatabaseConnectionWarning.selectDatasources(NbBundle.getMessage(BrokenDatasourceSupport.class, (String)"LBL_Resolve_Missing_Datasources_Title"), NbBundle.getMessage(BrokenDatasourceSupport.class, (String)"ACSD_Resolve_Missing_Datasources"), project);
    }

    public static synchronized void showAlert() {
        if (brokenAlertShown || brokenAlertLastTime + (long)BROKEN_ALERT_TIMEOUT > System.currentTimeMillis() || !J2EEUISettings.getDefault().isShowAgainBrokenDatasourceAlert()) {
            return;
        }
        brokenAlertShown = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BrokenDatasourceAlertPanel alert = new BrokenDatasourceAlertPanel();
                    JButton close = new JButton(NbBundle.getMessage(BrokenDatasourceSupport.class, (String)"LBL_BrokenDatasourcesCustomizer_Close"));
                    close.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenDatasourceSupport.class, (String)"ACSD_BrokenDatasourcesCustomizer_Close"));
                    DialogDescriptor dd = new DialogDescriptor((Object)alert, NbBundle.getMessage(BrokenDatasourceAlertPanel.class, (String)"MSG_Broken_Datasources_Title"), true, new Object[]{close}, (Object)close, 0, null, null);
                    dd.setMessageType(2);
                    Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                    dlg.setVisible(true);
                }
                finally {
                    Class<BrokenDatasourceSupport> clazz = BrokenDatasourceSupport.class;
                    synchronized (BrokenDatasourceSupport.class) {
                        brokenAlertLastTime = System.currentTimeMillis();
                        brokenAlertShown = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        });
    }

    public static Set<Datasource> getBrokenDatasources(Project project) {
        J2eeModuleProvider jmp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        HashSet dss = null;
        try {
            dss = jmp.getConfigSupport().getDatasources();
        }
        catch (ConfigurationException e) {
            dss = new HashSet();
        }
        HashSet<Datasource> brokenDatasources = new HashSet<Datasource>();
        for (Datasource ds : dss) {
            if (BrokenDatasourceSupport.isFound(ds)) continue;
            brokenDatasources.add(ds);
        }
        return brokenDatasources;
    }

    private static boolean isFound(Datasource ds) {
        DatabaseConnection[] dbConns;
        boolean found = false;
        String url = ds.getUrl();
        String username = ds.getUsername();
        for (DatabaseConnection dbCon : dbConns = ConnectionManager.getDefault().getConnections()) {
            String url1 = dbCon.getDatabaseURL();
            String username1 = dbCon.getUser();
            if (!BrokenDatasourceSupport.matchURL(url, url1, true) || !Utilities.compareObjects((Object)username, (Object)username1)) continue;
            found = true;
        }
        return found;
    }

    private static boolean matchURL(String jdbcResourceUrl, String dsInfoUrl, boolean ignoreCase) {
        if (ignoreCase) {
            jdbcResourceUrl = jdbcResourceUrl.toLowerCase();
            dsInfoUrl = dsInfoUrl.toLowerCase();
        }
        if (jdbcResourceUrl.equals(dsInfoUrl)) {
            return true;
        }
        if (jdbcResourceUrl.contains("derby")) {
            String newJdbcResourceUrl;
            int lastIndexOfColon = jdbcResourceUrl.lastIndexOf(":");
            int lastIndexOfSlash = jdbcResourceUrl.lastIndexOf("/");
            if (lastIndexOfColon >= 0 && lastIndexOfSlash >= 0 && (newJdbcResourceUrl = jdbcResourceUrl.substring(0, lastIndexOfColon) + jdbcResourceUrl.substring(lastIndexOfSlash)).equals(dsInfoUrl)) {
                return true;
            }
        }
        int nextIndex = 0;
        if (dsInfoUrl != null) {
            char[] jdbcResourceUrlChars = jdbcResourceUrl.toCharArray();
            char[] dsInfoUrlChars = dsInfoUrl.toCharArray();
            if (dsInfoUrlChars.length == jdbcResourceUrlChars.length) {
                for (int i = 0; i < jdbcResourceUrlChars.length - 1; ++i) {
                    if (jdbcResourceUrlChars[i] != dsInfoUrlChars[i] && jdbcResourceUrlChars[i] == ':') {
                        nextIndex = 1;
                        continue;
                    }
                    if (jdbcResourceUrlChars[i + nextIndex] == dsInfoUrlChars[i]) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

