/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.TagNamespace;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListTagNamespacesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String page;
    private Integer limit;
    private Boolean includeSubcompartments;
    private TagNamespace.LifecycleState lifecycleState;

    @ConstructorProperties(value={"compartmentId", "page", "limit", "includeSubcompartments", "lifecycleState"})
    ListTagNamespacesRequest(String compartmentId, String page, Integer limit, Boolean includeSubcompartments, TagNamespace.LifecycleState lifecycleState) {
        this.compartmentId = compartmentId;
        this.page = page;
        this.limit = limit;
        this.includeSubcompartments = includeSubcompartments;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).page(this.page).limit(this.limit).includeSubcompartments(this.includeSubcompartments).lifecycleState(this.lifecycleState);
    }

    public String toString() {
        return "ListTagNamespacesRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ", includeSubcompartments=" + this.getIncludeSubcompartments() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListTagNamespacesRequest)) {
            return false;
        }
        ListTagNamespacesRequest other = (ListTagNamespacesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Boolean this$includeSubcompartments = this.getIncludeSubcompartments();
        Boolean other$includeSubcompartments = other.getIncludeSubcompartments();
        if (this$includeSubcompartments == null ? other$includeSubcompartments != null : !((Object)this$includeSubcompartments).equals(other$includeSubcompartments)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        TagNamespace.LifecycleState this$lifecycleState = this.getLifecycleState();
        TagNamespace.LifecycleState other$lifecycleState = other.getLifecycleState();
        return !(this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListTagNamespacesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Boolean $includeSubcompartments = this.getIncludeSubcompartments();
        result = result * 59 + ($includeSubcompartments == null ? 43 : ((Object)$includeSubcompartments).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        TagNamespace.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getIncludeSubcompartments() {
        return this.includeSubcompartments;
    }

    public TagNamespace.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTagNamespacesRequest, Void> {
        private String compartmentId;
        private String page;
        private Integer limit;
        private Boolean includeSubcompartments;
        private TagNamespace.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTagNamespacesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.includeSubcompartments(o.getIncludeSubcompartments());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTagNamespacesRequest build() {
            ListTagNamespacesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder includeSubcompartments(Boolean includeSubcompartments) {
            this.includeSubcompartments = includeSubcompartments;
            return this;
        }

        public Builder lifecycleState(TagNamespace.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListTagNamespacesRequest buildWithoutInvocationCallback() {
            return new ListTagNamespacesRequest(this.compartmentId, this.page, this.limit, this.includeSubcompartments, this.lifecycleState);
        }

        public String toString() {
            return "ListTagNamespacesRequest.Builder(compartmentId=" + this.compartmentId + ", page=" + this.page + ", limit=" + this.limit + ", includeSubcompartments=" + this.includeSubcompartments + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

