/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListTaggingWorkRequestLogsRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"workRequestId", "page", "limit"})
    ListTaggingWorkRequestLogsRequest(String workRequestId, String page, Integer limit) {
        this.workRequestId = workRequestId;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().workRequestId(this.workRequestId).page(this.page).limit(this.limit);
    }

    public String toString() {
        return "ListTaggingWorkRequestLogsRequest(super=" + super.toString() + ", workRequestId=" + this.getWorkRequestId() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListTaggingWorkRequestLogsRequest)) {
            return false;
        }
        ListTaggingWorkRequestLogsRequest other = (ListTaggingWorkRequestLogsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$workRequestId = this.getWorkRequestId();
        String other$workRequestId = other.getWorkRequestId();
        if (this$workRequestId == null ? other$workRequestId != null : !this$workRequestId.equals(other$workRequestId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListTaggingWorkRequestLogsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $workRequestId = this.getWorkRequestId();
        result = result * 59 + ($workRequestId == null ? 43 : $workRequestId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTaggingWorkRequestLogsRequest, Void> {
        private String workRequestId;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTaggingWorkRequestLogsRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTaggingWorkRequestLogsRequest build() {
            ListTaggingWorkRequestLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListTaggingWorkRequestLogsRequest buildWithoutInvocationCallback() {
            return new ListTaggingWorkRequestLogsRequest(this.workRequestId, this.page, this.limit);
        }

        public String toString() {
            return "ListTaggingWorkRequestLogsRequest.Builder(workRequestId=" + this.workRequestId + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }
}

