/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DatabaseConnectionCredentials;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="credentialType")
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseSslConnectionCredentials
extends DatabaseConnectionCredentials {
    @JsonProperty(value="credentialName")
    private final String credentialName;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="sslSecretId")
    private final String sslSecretId;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public DatabaseSslConnectionCredentials(String credentialName, String username, String password, Role role, String sslSecretId) {
        this.credentialName = credentialName;
        this.username = username;
        this.password = password;
        this.role = role;
        this.sslSecretId = sslSecretId;
    }

    public Builder toBuilder() {
        return new Builder().credentialName(this.credentialName).username(this.username).password(this.password).role(this.role).sslSecretId(this.sslSecretId);
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Role getRole() {
        return this.role;
    }

    public String getSslSecretId() {
        return this.sslSecretId;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "DatabaseSslConnectionCredentials(super=" + super.toString() + ", credentialName=" + this.getCredentialName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", role=" + (Object)((Object)this.getRole()) + ", sslSecretId=" + this.getSslSecretId() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseSslConnectionCredentials)) {
            return false;
        }
        DatabaseSslConnectionCredentials other = (DatabaseSslConnectionCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$credentialName = this.getCredentialName();
        String other$credentialName = other.getCredentialName();
        if (this$credentialName == null ? other$credentialName != null : !this$credentialName.equals(other$credentialName)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Role this$role = this.getRole();
        Role other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        String this$sslSecretId = this.getSslSecretId();
        String other$sslSecretId = other.getSslSecretId();
        if (this$sslSecretId == null ? other$sslSecretId != null : !this$sslSecretId.equals(other$sslSecretId)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DatabaseSslConnectionCredentials;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $credentialName = this.getCredentialName();
        result = result * 59 + ($credentialName == null ? 43 : $credentialName.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Role $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        String $sslSecretId = this.getSslSecretId();
        result = result * 59 + ($sslSecretId == null ? 43 : $sslSecretId.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum Role {
        Sysdba("SYSDBA"),
        Normal("NORMAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentialName")
        private String credentialName;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="sslSecretId")
        private String sslSecretId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentialName(String credentialName) {
            this.credentialName = credentialName;
            this.__explicitlySet__.add("credentialName");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder sslSecretId(String sslSecretId) {
            this.sslSecretId = sslSecretId;
            this.__explicitlySet__.add("sslSecretId");
            return this;
        }

        public DatabaseSslConnectionCredentials build() {
            DatabaseSslConnectionCredentials __instance__ = new DatabaseSslConnectionCredentials(this.credentialName, this.username, this.password, this.role, this.sslSecretId);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DatabaseSslConnectionCredentials o) {
            Builder copiedBuilder = this.credentialName(o.getCredentialName()).username(o.getUsername()).password(o.getPassword()).role(o.getRole()).sslSecretId(o.getSslSecretId());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DatabaseSslConnectionCredentials.Builder(credentialName=" + this.credentialName + ", username=" + this.username + ", password=" + this.password + ", role=" + (Object)((Object)this.role) + ", sslSecretId=" + this.sslSecretId + ")";
        }
    }
}

