/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteConsoleConnectionRequest
extends BmcRequest<Void> {
    private String dbNodeId;
    private String consoleConnectionId;
    private String ifMatch;

    @ConstructorProperties(value={"dbNodeId", "consoleConnectionId", "ifMatch"})
    DeleteConsoleConnectionRequest(String dbNodeId, String consoleConnectionId, String ifMatch) {
        this.dbNodeId = dbNodeId;
        this.consoleConnectionId = consoleConnectionId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().dbNodeId(this.dbNodeId).consoleConnectionId(this.consoleConnectionId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeleteConsoleConnectionRequest(super=" + super.toString() + ", dbNodeId=" + this.getDbNodeId() + ", consoleConnectionId=" + this.getConsoleConnectionId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteConsoleConnectionRequest)) {
            return false;
        }
        DeleteConsoleConnectionRequest other = (DeleteConsoleConnectionRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dbNodeId = this.getDbNodeId();
        String other$dbNodeId = other.getDbNodeId();
        if (this$dbNodeId == null ? other$dbNodeId != null : !this$dbNodeId.equals(other$dbNodeId)) {
            return false;
        }
        String this$consoleConnectionId = this.getConsoleConnectionId();
        String other$consoleConnectionId = other.getConsoleConnectionId();
        if (this$consoleConnectionId == null ? other$consoleConnectionId != null : !this$consoleConnectionId.equals(other$consoleConnectionId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteConsoleConnectionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dbNodeId = this.getDbNodeId();
        result = result * 59 + ($dbNodeId == null ? 43 : $dbNodeId.hashCode());
        String $consoleConnectionId = this.getConsoleConnectionId();
        result = result * 59 + ($consoleConnectionId == null ? 43 : $consoleConnectionId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public String getConsoleConnectionId() {
        return this.consoleConnectionId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteConsoleConnectionRequest, Void> {
        private String dbNodeId;
        private String consoleConnectionId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteConsoleConnectionRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.consoleConnectionId(o.getConsoleConnectionId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteConsoleConnectionRequest build() {
            DeleteConsoleConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public Builder consoleConnectionId(String consoleConnectionId) {
            this.consoleConnectionId = consoleConnectionId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteConsoleConnectionRequest buildWithoutInvocationCallback() {
            return new DeleteConsoleConnectionRequest(this.dbNodeId, this.consoleConnectionId, this.ifMatch);
        }

        public String toString() {
            return "DeleteConsoleConnectionRequest.Builder(dbNodeId=" + this.dbNodeId + ", consoleConnectionId=" + this.consoleConnectionId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

