/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetBackupDestinationRequest
extends BmcRequest<Void> {
    private String backupDestinationId;
    private String opcRequestId;

    @ConstructorProperties(value={"backupDestinationId", "opcRequestId"})
    GetBackupDestinationRequest(String backupDestinationId, String opcRequestId) {
        this.backupDestinationId = backupDestinationId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().backupDestinationId(this.backupDestinationId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetBackupDestinationRequest(super=" + super.toString() + ", backupDestinationId=" + this.getBackupDestinationId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetBackupDestinationRequest)) {
            return false;
        }
        GetBackupDestinationRequest other = (GetBackupDestinationRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$backupDestinationId = this.getBackupDestinationId();
        String other$backupDestinationId = other.getBackupDestinationId();
        if (this$backupDestinationId == null ? other$backupDestinationId != null : !this$backupDestinationId.equals(other$backupDestinationId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetBackupDestinationRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $backupDestinationId = this.getBackupDestinationId();
        result = result * 59 + ($backupDestinationId == null ? 43 : $backupDestinationId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getBackupDestinationId() {
        return this.backupDestinationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBackupDestinationRequest, Void> {
        private String backupDestinationId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBackupDestinationRequest o) {
            this.backupDestinationId(o.getBackupDestinationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBackupDestinationRequest build() {
            GetBackupDestinationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder backupDestinationId(String backupDestinationId) {
            this.backupDestinationId = backupDestinationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetBackupDestinationRequest buildWithoutInvocationCallback() {
            return new GetBackupDestinationRequest(this.backupDestinationId, this.opcRequestId);
        }

        public String toString() {
            return "GetBackupDestinationRequest.Builder(backupDestinationId=" + this.backupDestinationId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

