/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.Latest;
import eu.hansolo.jdktools.OperatingSystem;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.versioning.VersionNumber;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.util.Helper;
import java.awt.CardLayout;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ListSelectionModel;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.netbeans.modules.java.disco.AdvancedPanel;
import org.netbeans.modules.java.disco.Bundle;
import org.netbeans.modules.java.disco.Client;
import org.netbeans.modules.java.disco.DiscoPlatformInstall;
import org.netbeans.modules.java.disco.FirstPanel;
import org.netbeans.modules.java.disco.OS;
import org.netbeans.modules.java.disco.PkgSelection;
import org.netbeans.modules.java.disco.QuickPanel;
import org.netbeans.modules.java.disco.SwingWorker2;
import org.openide.util.Exceptions;

public class SelectPackagePanel
extends FirstPanel {
    private static final Logger log = Logger.getLogger(SelectPackagePanel.class.getName());
    public static final String PROP_VALIDITY_CHANGED = "panelValidityChanged";
    private final Client discoClient = Client.getInstance();
    private final QuickPanel quickPanel = new QuickPanel(this);
    private final FooAdvancedPanel advancedPanel = new FooAdvancedPanel();
    private boolean initialLoad = false;

    @UIEffect
    public static SelectPackagePanel create() {
        SelectPackagePanel f = new SelectPackagePanel();
        f.init();
        return f;
    }

    @UIEffect
    private SelectPackagePanel() {
        ((CardLayout)this.getLayout()).first(this);
        this.tabs.add(Bundle.SelectPackage_quick(), this.quickPanel);
        this.tabs.add(Bundle.SelectPackage_advanced(), this.advancedPanel);
        this.tabs.addChangeListener(e -> {
            this.fireValidityChange();
            if (this.tabs.getSelectedComponent() == this.quickPanel) {
                this.quickPanel.switchFocus(this.advancedPanel.getSelectedDistribution(), this.advancedPanel.getSelectedVersion());
            } else {
                this.advancedPanel.switchFocus(this.quickPanel.getSelectedDistribution(), this.quickPanel.getSelectedVersion());
            }
        });
    }

    @UIEffect
    private void init() {
        this.setName(Bundle.SelectPackage_componentName());
    }

    @Override
    @UIEffect
    public void addNotify() {
        class Result {
            final List<Integer> versionNumbers;
            final Map<Integer, TermOfSupport> versionNumberSupport;
            final List<Distribution> distributions;
            final int current;

            public Result(List<Integer> versionNumbers, Map<Integer, TermOfSupport> versionNumberSupport, List<Distribution> distributions, int current) {
                this.versionNumbers = versionNumbers;
                this.versionNumberSupport = versionNumberSupport;
                this.distributions = distributions;
                this.current = current;
            }
        }
        super.addNotify();
        if (this.initialLoad) {
            return;
        }
        this.initialLoad = true;
        SwingWorker2.submit(() -> {
            int minVersion = 6;
            int maxVersion = this.discoClient.getLatestSts(true).getAsInt();
            int current = this.discoClient.getLatestSts(false).getAsInt();
            Map<Integer, TermOfSupport> maintainedVersions = this.discoClient.getAllMaintainedMajorVersions().stream().filter(v -> v.getAsInt() >= minVersion && v.getAsInt() <= current).filter(v -> v.getAsInt() == current || v.getTermOfSupport() == TermOfSupport.LTS).collect(Collectors.toMap(MajorVersion::getAsInt, MajorVersion::getTermOfSupport));
            List<Integer> versionNumbers = IntStream.range(minVersion, maxVersion + 1).boxed().collect(Collectors.toList());
            List<Distribution> distros = this.discoClient.getDistributions();
            return new Result(versionNumbers, maintainedVersions, distros, current);
        }).then(c -> {
            ((CardLayout)this.getLayout()).next(this);
            Distribution defaultDist = this.discoClient.getDistribution(DiscoPlatformInstall.defaultDistribution()).orElse(null);
            this.advancedPanel.updateDistributions(c.distributions);
            this.advancedPanel.setVersions(c.versionNumbers, c.versionNumberSupport, c.current);
            this.quickPanel.updateDistributions(c.distributions, defaultDist);
            this.quickPanel.setVersions(c.versionNumbers, c.versionNumberSupport, c.current);
            this.quickPanel.initFocus();
            this.fireValidityChange();
        }).handle(ex -> {
            this.loadingLabel.setText(Bundle.SelectPackage_loadingError());
            this.initialLoad = false;
            long currentTimeMillisStart = System.currentTimeMillis();
            SwingWorker2.submit(() -> {
                String body = Helper.get("https://www.example.com").body();
                return body != null && !"".equals(body);
            }).then(isOnline -> {
                long now = System.currentTimeMillis();
                if (isOnline.booleanValue() && now - currentTimeMillisStart <= 300L) {
                    Exceptions.printStackTrace((Throwable)ex);
                } else {
                    log.log(Level.INFO, "Could not load initial list", (Throwable)ex);
                }
            }).handle(ex2 -> {
                log.log(Level.INFO, "Could not load initial list", (Throwable)ex);
                log.log(Level.INFO, "Could not check network connectivity", (Throwable)ex2);
            }).execute();
        }).execute();
    }

    void fireValidityChange() {
        this.firePropertyChange(PROP_VALIDITY_CHANGED, null, null);
    }

    @UIEffect
    public @Nullable PkgSelection getSelectedPackage() {
        if (!this.tabs.isVisible()) {
            return null;
        }
        Pkg pkg = null;
        switch (this.tabs.getSelectedIndex()) {
            case 0: {
                pkg = this.quickPanel.getSelectedPackage();
                break;
            }
            case 1: {
                pkg = this.advancedPanel.getSelectedPackage();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return pkg == null ? null : PkgSelection.of(pkg);
    }

    class FooAdvancedPanel
    extends AdvancedPanel {
        FooAdvancedPanel() {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.addListSelectionListener(e -> SelectPackagePanel.this.fireValidityChange());
        }

        @Override
        @UIEffect
        protected void updateData(Distribution distribution, Integer featureVersion, Architecture architecture, Latest latest, PackageType bundleType, boolean ea) {
            if (distribution == null || featureVersion == null) {
                return;
            }
            OperatingSystem operatingSystem = OS.getOperatingSystem();
            ArchiveType extension = ArchiveType.NONE;
            Boolean fx = false;
            this.setEnabled(false);
            SwingWorker2.submit(() -> {
                List<Pkg> bundles = SelectPackagePanel.this.discoClient.getPkgs(distribution, new VersionNumber(featureVersion), latest, operatingSystem, architecture, extension, bundleType, ea, fx);
                return bundles;
            }).then(this::setPackages).handle(Exceptions::printStackTrace).execute();
        }

        @Override
        protected void updateDistributions(List<Distribution> distros) {
            super.updateDistributions(distros);
        }

        @UIEffect
        private void setPackages(List<Pkg> bundles) {
            SelectPackagePanel.this.setEnabled(true);
            this.tableModel.setBundles(bundles);
        }
    }
}

