/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.component.page;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.mobile.component.page.Page;
import org.primefaces.renderkit.CoreRenderer;

public class PageRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Page page = (Page)component;
        writer.startElement("div", (UIComponent)page);
        writer.writeAttribute("id", (Object)page.getClientId(context), "id");
        if (page.isLazyloadRequest(context)) {
            this.encodeContent(context, page);
        } else if (page.isLazy()) {
            writer.writeAttribute("class", (Object)"ui-lazypage", null);
        } else {
            this.encodeContent(context, page);
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void encodeContent(FacesContext context, Page page) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String swatch = page.getSwatch();
        String title = page.getTitle();
        String style = page.getStyle();
        String styleClass = page.getStyleClass();
        writer.writeAttribute("data-role", (Object)"page", null);
        if (swatch != null) {
            writer.writeAttribute("data-theme", (Object)swatch, null);
        }
        if (title != null) {
            writer.writeAttribute("data-title", (Object)title, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        this.renderChildren(context, (UIComponent)page);
    }
}

