/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.devops.model.RepositoryFileLines;
import com.oracle.bmc.devops.requests.GetRepositoryFileLinesRequest;
import com.oracle.bmc.devops.responses.GetRepositoryFileLinesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRepositoryFileLinesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetRepositoryFileLinesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetRepositoryFileLinesRequest interceptRequest(GetRepositoryFileLinesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetRepositoryFileLinesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getFilePath(), (String)"filePath must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getRevision(), (String)"revision is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210630").path("repositories").path(HttpUtils.encodePathSegment((String)request.getRepositoryId())).path("files").path(HttpUtils.encodePathSegment((String)request.getFilePath())).path("lines");
        target = target.queryParam("revision", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getRevision())});
        if (request.getStartLineNumber() != null) {
            target = target.queryParam("startLineNumber", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStartLineNumber())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetRepositoryFileLinesResponse> fromResponse() {
        Function<Response, GetRepositoryFileLinesResponse> transformer = new Function<Response, GetRepositoryFileLinesResponse>(){

            public GetRepositoryFileLinesResponse apply(Response rawResponse) {
                Optional sunsetHeader;
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.devops.responses.GetRepositoryFileLinesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RepositoryFileLines.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetRepositoryFileLinesResponse.Builder builder = GetRepositoryFileLinesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.repositoryFileLines((RepositoryFileLines)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((sunsetHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"Sunset")).isPresent()) {
                    builder.sunset((String)HeaderUtils.toValue((String)"Sunset", (String)((String)((List)sunsetHeader.get()).get(0)), String.class));
                }
                GetRepositoryFileLinesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

