/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.bower.file.BowerJson;
import org.netbeans.modules.javascript.bower.ui.Bundle;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public final class BowerLibraries {
    private BowerLibraries() {
    }

    public static NodeFactory forHtml5Project() {
        return new BowerLibrariesNodeFactory();
    }

    public static NodeFactory forPhpProject() {
        return new BowerLibrariesNodeFactory();
    }

    public static NodeFactory forWebProject() {
        return new BowerLibrariesNodeFactory();
    }

    public static NodeFactory forMavenProject() {
        return new BowerLibrariesNodeFactory();
    }

    private static final class CustomizeLibrariesAction
    extends AbstractAction {
        private final Project project;

        CustomizeLibrariesAction(Project project) {
            assert (project != null);
            this.project = project;
            String name = Bundle.CustomizeLibrariesAction_name();
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer("BowerLibraries", null);
        }
    }

    private static final class BowerLibraryInfo
    implements Comparable<BowerLibraryInfo> {
        final Image icon;
        final String name;
        final String description;

        BowerLibraryInfo(Image icon, String name, String descrition) {
            assert (icon != null);
            assert (name != null);
            assert (descrition != null);
            this.icon = icon;
            this.name = name;
            this.description = descrition;
        }

        @Override
        public int compareTo(BowerLibraryInfo other) {
            return this.name.compareToIgnoreCase(other.name);
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.name);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BowerLibraryInfo other = (BowerLibraryInfo)obj;
            return this.name.equalsIgnoreCase(other.name);
        }
    }

    private static final class BowerLibraryNode
    extends AbstractNode {
        private final BowerLibraryInfo libraryInfo;

        BowerLibraryNode(BowerLibraryInfo libraryInfo) {
            super(Children.LEAF);
            this.libraryInfo = libraryInfo;
        }

        public String getName() {
            return this.libraryInfo.name;
        }

        public String getShortDescription() {
            return this.libraryInfo.description;
        }

        public Image getIcon(int type) {
            return this.libraryInfo.icon;
        }

        public Image getOpenedIcon(int type) {
            return this.libraryInfo.icon;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static final class BowerLibrariesChildren
    extends Children.Keys<BowerLibraryInfo> {
        private static final String LIBRARIES_ICON = "org/netbeans/modules/javascript/bower/ui/resources/libraries.gif";
        private static final String DEV_BADGE = "org/netbeans/modules/javascript/bower/ui/resources/libraries-dev-badge.gif";
        private final BowerJson bowerJson;
        private final Map<String, Image> icons = new HashMap<String, Image>();

        public BowerLibrariesChildren(BowerJson bowerJson) {
            super(true);
            assert (bowerJson != null);
            this.bowerJson = bowerJson;
        }

        public boolean hasDependencies() {
            return !this.bowerJson.getDependencies().isEmpty();
        }

        public void refreshDependencies() {
            this.setKeys();
        }

        protected Node[] createNodes(BowerLibraryInfo key) {
            return new Node[]{new BowerLibraryNode(key)};
        }

        protected void addNotify() {
            this.setKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        private void setKeys() {
            BowerJson.BowerDependencies dependencies = this.bowerJson.getDependencies();
            if (dependencies.isEmpty()) {
                this.setKeys(Collections.emptyList());
                return;
            }
            ArrayList<BowerLibraryInfo> keys = new ArrayList<BowerLibraryInfo>(dependencies.getCount());
            keys.addAll(this.getKeys(dependencies.dependencies, null, null));
            keys.addAll(this.getKeys(dependencies.devDependencies, DEV_BADGE, Bundle.BowerLibrariesChildren_library_dev()));
            this.setKeys(keys);
        }

        private List<BowerLibraryInfo> getKeys(Map<String, String> dependencies, String badge, String libraryType) {
            if (dependencies.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<BowerLibraryInfo> keys = new ArrayList<BowerLibraryInfo>(dependencies.size());
            for (Map.Entry<String, String> entry : dependencies.entrySet()) {
                String description = libraryType != null ? Bundle.BowerLibrariesChildren_description_long(entry.getKey(), entry.getValue(), libraryType) : Bundle.BowerLibrariesChildren_description_short(entry.getKey(), entry.getValue());
                keys.add(new BowerLibraryInfo(this.geIcon(badge), entry.getKey(), description));
            }
            Collections.sort(keys);
            return keys;
        }

        private Image geIcon(String badge) {
            Image icon = this.icons.get(badge);
            if (icon == null) {
                icon = ImageUtilities.loadImage((String)LIBRARIES_ICON);
                if (badge != null) {
                    icon = ImageUtilities.mergeImages((Image)icon, (Image)ImageUtilities.loadImage((String)badge), (int)8, (int)8);
                }
                this.icons.put(badge, icon);
            }
            return icon;
        }
    }

    private static final class BowerLibrariesNode
    extends AbstractNode {
        private static final String LIBRARIES_BADGE = "org/netbeans/modules/javascript/bower/ui/resources/libraries-badge.png";
        private final Project project;
        private final Node iconDelegate;

        BowerLibrariesNode(Project project, BowerLibrariesChildren bowerLibrariesChildren) {
            super((Children)bowerLibrariesChildren);
            assert (project != null);
            this.project = project;
            this.iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
        }

        public String getDisplayName() {
            return Bundle.BowerLibrariesNode_name();
        }

        public Image getIcon(int type) {
            return ImageUtilities.mergeImages((Image)this.iconDelegate.getIcon(type), (Image)ImageUtilities.loadImage((String)LIBRARIES_BADGE), (int)7, (int)7);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new CustomizeLibrariesAction(this.project)};
        }
    }

    private static final class BowerLibrariesNodeList
    implements NodeList<Node>,
    PropertyChangeListener {
        private final Project project;
        private final BowerJson bowerJson;
        private final BowerLibrariesChildren bowerLibrariesChildren;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Node bowerLibrariesNode;

        BowerLibrariesNodeList(Project project) {
            assert (project != null);
            this.project = project;
            this.bowerJson = new BowerJson(project.getProjectDirectory());
            this.bowerLibrariesChildren = new BowerLibrariesChildren(this.bowerJson);
        }

        public List<Node> keys() {
            if (!this.bowerLibrariesChildren.hasDependencies()) {
                return Collections.emptyList();
            }
            if (this.bowerLibrariesNode == null) {
                this.bowerLibrariesNode = new BowerLibrariesNode(this.project, this.bowerLibrariesChildren);
            }
            return Collections.singletonList(this.bowerLibrariesNode);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public Node node(Node key) {
            return key;
        }

        public void addNotify() {
            this.bowerJson.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.bowerJson));
        }

        public void removeNotify() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("DEPENDENCIES".equals(propertyName) || "DEV_DEPENDENCIES".equals(propertyName)) {
                this.fireChange();
            }
        }

        private void fireChange() {
            this.bowerLibrariesChildren.refreshDependencies();
            this.changeSupport.fireChange();
        }
    }

    private static final class BowerLibrariesNodeFactory
    implements NodeFactory {
        private BowerLibrariesNodeFactory() {
        }

        public NodeList<?> createNodes(Project project) {
            assert (project != null);
            return new BowerLibrariesNodeList(project);
        }
    }
}

