/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.api;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public final class Utils {
    private Utils() {
    }

    public static Comment getCommentForNode(Program root, ASTNode node) {
        List<Comment> comments = root.getComments();
        ASTNode possible = null;
        if (node.getEndOffset() <= root.getEndOffset()) {
            List<ASTNode> nodes;
            for (Comment comm : comments) {
                if (comm.getEndOffset() >= node.getStartOffset()) break;
                possible = comm;
            }
            if (!(possible == null || possible.getEndOffset() + 1 >= node.getStartOffset() || (nodes = new NodeRangeLocator().locate(root, new OffsetRange(possible.getEndOffset() + 1, node.getStartOffset() - 1))).isEmpty() || Utils.isConstantDeclaration(nodes, node) || Utils.isFieldDeclaration(nodes, node))) {
                possible = null;
            }
        }
        return possible;
    }

    private static boolean isConstantDeclaration(List<ASTNode> nodes, ASTNode node) {
        FunctionName fnc;
        String functionName;
        ASTNode next;
        boolean isConstantDeclaration = false;
        if (nodes.size() == 1 && node instanceof Scalar && (next = nodes.iterator().next()) instanceof FunctionName && (functionName = CodeUtils.extractFunctionName(fnc = (FunctionName)next)) != null && "define".equalsIgnoreCase(functionName)) {
            isConstantDeclaration = true;
        }
        return isConstantDeclaration;
    }

    private static boolean isFieldDeclaration(List<ASTNode> nodes, ASTNode node) {
        ASTNode next;
        boolean isFieldDeclaration = false;
        if (nodes.size() == 1 && node instanceof Identifier && ((next = nodes.iterator().next()) instanceof NamespaceName || next instanceof NullableType || next instanceof UnionType)) {
            isFieldDeclaration = true;
        }
        return isFieldDeclaration;
    }

    public static Program getRoot(ParserResult result) {
        if (result == null) {
            return null;
        }
        if (result instanceof PHPParseResult) {
            return ((PHPParseResult)result).getProgram();
        }
        return null;
    }

    public static ASTNode getNodeAtOffset(ParserResult info, int astOffset) {
        Program program = Utils.getRoot(info);
        return Utils.getNodeAtOffset(program, astOffset);
    }

    public static ASTNode getNodeAtOffset(ASTNode node, int offset) {
        if (node.getStartOffset() > offset || node.getEndOffset() < offset) {
            return null;
        }
        return new NodeLocator().locate(node, offset);
    }

    public static ASTNode getNodeAfterOffset(ParserResult info, int offset) {
        return new AfterOffsetLocator().locate(Utils.getRoot(info), offset);
    }

    public static ASTNode[] getNodeHierarchyAtOffset(ASTNode node, int offset) {
        if (node.getStartOffset() > offset || node.getEndOffset() < offset) {
            return null;
        }
        return new NodeHierarchyFinder().find(node, offset);
    }

    public static ASTNode getNodeAtOffset(ASTNode node, int offset, Class<? extends ASTNode> terminus) {
        if (node.getStartOffset() > offset || node.getEndOffset() < offset) {
            return null;
        }
        return new SpecificClassNodeLocator(terminus).locate(node, offset);
    }

    public static String resolveVariableName(Variable variable) {
        String name = null;
        if (variable.getName() instanceof Identifier) {
            name = ((Identifier)variable.getName()).getName();
        }
        return name;
    }

    public static List<PHPDocVarTypeTag> getPropertyTags(Program root, ClassDeclaration node) {
        ArrayList<PHPDocVarTypeTag> tags = new ArrayList<PHPDocVarTypeTag>();
        Comment comment = Utils.getCommentForNode(root, node);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock phpDoc = (PHPDocBlock)comment;
            for (PHPDocTag tag : phpDoc.getTags()) {
                if (!tag.getKind().equals((Object)PHPDocTag.Type.PROPERTY) && !tag.getKind().equals((Object)PHPDocTag.Type.PROPERTY_READ) && !tag.getKind().equals((Object)PHPDocTag.Type.PROPERTY_WRITE)) continue;
                tags.add((PHPDocVarTypeTag)tag);
            }
        }
        return tags;
    }

    private static class NodeRangeLocator
    extends DefaultVisitor {
        private OffsetRange range;
        private List<ASTNode> nodes = new ArrayList<ASTNode>();

        private NodeRangeLocator() {
        }

        public List<ASTNode> locate(ASTNode beginNode, OffsetRange range) {
            this.range = range;
            this.scan(beginNode);
            return this.nodes;
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null) {
                if (this.range.getStart() <= node.getStartOffset() && node.getEndOffset() <= this.range.getEnd()) {
                    this.nodes.add(node);
                } else if (node.getStartOffset() < this.range.getStart() && this.range.getStart() < node.getEndOffset() || node.getStartOffset() < this.range.getEnd() && this.range.getEnd() < node.getEndOffset()) {
                    node.accept(this);
                }
            }
        }
    }

    private static class SpecificClassNodeLocator
    extends NodeLocator {
        private Class<? extends ASTNode> terminus;

        public SpecificClassNodeLocator(Class<? extends ASTNode> terminus) {
            this.terminus = terminus;
        }

        @Override
        public void scan(ASTNode node) {
            if (this.terminus.isInstance(node)) {
                if (node.getStartOffset() <= this.offset && this.offset <= node.getEndOffset()) {
                    this.node = node;
                }
            } else {
                super.scan(node);
            }
        }
    }

    private static class NodeHierarchyFinder
    extends DefaultTreePathVisitor {
        private ASTNode[] hierarchy;
        protected int offset = 0;

        private NodeHierarchyFinder() {
        }

        public ASTNode[] find(ASTNode beginNode, int astOffset) {
            this.offset = astOffset;
            this.scan(beginNode);
            return this.hierarchy;
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null && node.getStartOffset() <= this.offset && this.offset <= node.getEndOffset()) {
                this.hierarchy = this.getPath().toArray(new ASTNode[this.getPath().size()]);
                node.accept(this);
            }
        }
    }

    private static class NodeLocator
    extends DefaultVisitor {
        protected int offset = 0;
        protected ASTNode node = null;
        private Program programNode = null;

        private NodeLocator() {
        }

        public ASTNode locate(ASTNode beginNode, int astOffset) {
            this.offset = astOffset;
            this.scan(beginNode);
            if (this.node instanceof Program) {
                this.processComments((Program)this.node);
            } else if (this.programNode != null) {
                this.processComments(this.programNode);
            }
            return this.node;
        }

        private void processComments(Program program) {
            List<Comment> comments = program.getComments();
            for (Comment comment : comments) {
                if (comment.getStartOffset() > this.offset || this.offset > comment.getEndOffset()) continue;
                this.scan(comment);
            }
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null && node.getStartOffset() <= this.offset && this.offset <= node.getEndOffset()) {
                this.node = node;
                node.accept(this);
            }
        }

        @Override
        public void visit(Program node) {
            this.programNode = node;
            super.visit(node);
        }

        @Override
        public void visit(PHPDocTypeTag node) {
        }

        @Override
        public void visit(PHPDocVarTypeTag node) {
        }

        @Override
        public void visit(PHPDocMethodTag node) {
        }
    }

    private static class AfterOffsetLocator
    extends DefaultVisitor {
        private int offset;
        private ASTNode resultNode = null;
        private int lastStartOffset = -1;

        private AfterOffsetLocator() {
        }

        public ASTNode locate(ASTNode beginNode, int offset) {
            this.offset = offset;
            this.scan(beginNode);
            return this.resultNode;
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null) {
                int startOffset = node.getStartOffset();
                if (startOffset >= this.offset && (this.lastStartOffset == -1 || startOffset < this.lastStartOffset)) {
                    this.lastStartOffset = startOffset;
                    this.resultNode = node;
                }
                node.accept(this);
            }
        }
    }
}

