/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointsInfo;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class JSBreakpointsInfoManager {
    private static JSBreakpointsInfoManager INSTANCE;
    private JSBreakpointsInfo[] infoServices;
    private final Object infoServicesLock = new Object();
    private final PropertyChangeListener servicePCL = new ServicePropertyChangeListener();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Boolean lastActivated = null;

    private JSBreakpointsInfoManager(final Lookup.Result<JSBreakpointsInfo> lookupResult, JSBreakpointsInfo[] activeServices) {
        lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                JSBreakpointsInfoManager.this.updateServices(lookupResult.allInstances().toArray(new JSBreakpointsInfo[0]));
            }
        });
        this.initServices(activeServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSBreakpointsInfoManager getDefault() {
        Class<JSBreakpointsInfoManager> clazz = JSBreakpointsInfoManager.class;
        synchronized (JSBreakpointsInfoManager.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Lookup.Result lookupResult = Lookup.getDefault().lookupResult(JSBreakpointsInfo.class);
            JSBreakpointsInfo[] activeServices = lookupResult.allInstances().toArray(new JSBreakpointsInfo[0]);
            Class<JSBreakpointsInfoManager> clazz2 = JSBreakpointsInfoManager.class;
            synchronized (JSBreakpointsInfoManager.class) {
                if (INSTANCE == null) {
                    INSTANCE = new JSBreakpointsInfoManager((Lookup.Result<JSBreakpointsInfo>)lookupResult, activeServices);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServices(JSBreakpointsInfo[] activeServices) {
        for (JSBreakpointsInfo as : activeServices) {
            as.addPropertyChangeListener(this.servicePCL);
        }
        Object object = this.infoServicesLock;
        synchronized (object) {
            this.infoServices = activeServices;
            this.lastActivated = null;
        }
    }

    private void updateServices(JSBreakpointsInfo[] activeServices) {
        this.initServices(activeServices);
        this.fireChange("breakpointsActive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSBreakpointsInfo[] getServices() {
        JSBreakpointsInfo[] services;
        Object object = this.infoServicesLock;
        synchronized (object) {
            services = this.infoServices;
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areBreakpointsActivated() {
        Boolean activated;
        Object object = this.infoServicesLock;
        synchronized (object) {
            activated = this.lastActivated;
        }
        boolean are = true;
        if (activated != null) {
            are = activated;
        } else {
            for (JSBreakpointsInfo bi : this.getServices()) {
                if (bi.areBreakpointsActivated()) continue;
                are = false;
                break;
            }
            Object object2 = this.infoServicesLock;
            synchronized (object2) {
                this.lastActivated = are;
            }
        }
        return are;
    }

    public boolean isAnnotatable(FileObject fo) {
        for (JSBreakpointsInfo bi : this.getServices()) {
            if (!bi.isAnnotatable(fo)) continue;
            return true;
        }
        return false;
    }

    public boolean isTransientURL(URL url) {
        for (JSBreakpointsInfo bi : this.getServices()) {
            if (!bi.isTransientURL(url)) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private void fireChange(String propertyName) {
        this.pcs.firePropertyChange(propertyName, null, null);
    }

    private final class ServicePropertyChangeListener
    implements PropertyChangeListener {
        private ServicePropertyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("breakpointsActive".equals(evt.getPropertyName())) {
                Object object = JSBreakpointsInfoManager.this.infoServicesLock;
                synchronized (object) {
                    JSBreakpointsInfoManager.this.lastActivated = null;
                }
                JSBreakpointsInfoManager.this.fireChange("breakpointsActive");
            }
        }
    }
}

