/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.protractor.preferences;

import java.io.File;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.selenium2.webclient.protractor.preferences.Bundle;
import org.netbeans.modules.selenium2.webclient.protractor.preferences.ProtractorPreferences;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.ui.api.ExternalExecutableValidator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ProtractorPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public ProtractorPreferencesValidator validate(Project project) {
        this.validateProtractor(ProtractorPreferences.getProtractor(project));
        this.validateUserConfigurationFile(project, ProtractorPreferences.getUserConfigurationFile(project));
        return this;
    }

    public ProtractorPreferencesValidator validateProtractor(String protractor) {
        String warning = ExternalExecutableValidator.validateCommand((String)protractor, (String)Bundle.ProtractorPreferencesValidator_protractor_name());
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"path", warning));
        }
        return this;
    }

    public ProtractorPreferencesValidator validateUserConfigurationFile(Project project, String userConfigurationFile) {
        String warning = ProtractorPreferencesValidator.validateFile(project, Bundle.ProtractorPreferencesValidator_userConfigurationFile_name(), userConfigurationFile, false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"configuration file", warning));
        }
        return this;
    }

    @CheckForNull
    private static String validateFile(Project project, String source, String filePath, boolean writable) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return Bundle.ProtractorPreferencesValidator_validateFile_missing(source);
        }
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            return Bundle.ProtractorPreferencesValidator_validateFile_notAbsolute(source);
        }
        if (!file.isFile()) {
            return Bundle.ProtractorPreferencesValidator_validateFile_notFile(source);
        }
        if (!file.canRead()) {
            return Bundle.ProtractorPreferencesValidator_validateFile_notReadable(source);
        }
        if (writable && !file.canWrite()) {
            return Bundle.ProtractorPreferencesValidator_validateFile_notWritable(source);
        }
        if (project != null && !project.equals(FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)file)))) {
            return Bundle.ProtractorPreferencesValidator_validateFile_notUnderProject(source);
        }
        return null;
    }
}

