/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PermittedTaglibsTLV
extends TagLibraryValidator {
    private final String PERMITTED_TAGLIBS_PARAM = "permittedTaglibs";
    private final String JSP_ROOT_URI = "http://java.sun.com/JSP/Page";
    private final String JSP_ROOT_NAME = "root";
    private final String JSP_ROOT_QN = "jsp:root";
    private Set<String> permittedTaglibs;
    private boolean failed;
    private String uri;

    public PermittedTaglibsTLV() {
        this.init();
    }

    private void init() {
        this.permittedTaglibs = null;
        this.failed = false;
    }

    @Override
    public void release() {
        super.release();
        this.init();
    }

    @Override
    public synchronized ValidationMessage[] validate(String prefix, String uri, PageData page) {
        try {
            this.uri = uri;
            this.permittedTaglibs = this.readConfiguration();
            PermittedTaglibsHandler h = new PermittedTaglibsHandler();
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setValidating(true);
            SAXParser p = f.newSAXParser();
            p.parse(page.getInputStream(), (DefaultHandler)h);
            if (this.failed) {
                return this.vmFromString("taglib " + prefix + " (" + uri + ") allows only the " + "following taglibs to be imported: " + this.permittedTaglibs);
            }
            return null;
        }
        catch (SAXException ex) {
            return this.vmFromString(ex.toString());
        }
        catch (ParserConfigurationException ex) {
            return this.vmFromString(ex.toString());
        }
        catch (IOException ex) {
            return this.vmFromString(ex.toString());
        }
    }

    private Set<String> readConfiguration() {
        HashSet<String> s = new HashSet<String>();
        String uris = (String)this.getInitParameters().get("permittedTaglibs");
        StringTokenizer st = new StringTokenizer(uris);
        while (st.hasMoreTokens()) {
            s.add(st.nextToken());
        }
        return s;
    }

    private ValidationMessage[] vmFromString(String message) {
        return new ValidationMessage[]{new ValidationMessage(null, message)};
    }

    private class PermittedTaglibsHandler
    extends DefaultHandler {
        private PermittedTaglibsHandler() {
        }

        @Override
        public void startElement(String ns, String ln, String qn, Attributes a) {
            if (!(qn.equals("jsp:root") || ns.equals("http://java.sun.com/JSP/Page") && ln.equals("root"))) {
                return;
            }
            for (int i = 0; i < a.getLength(); ++i) {
                String value;
                String name = a.getQName(i);
                if (!name.startsWith("xmlns:") || name.equals("xmlns:jsp") || (value = a.getValue(i)).equals(PermittedTaglibsTLV.this.uri) || PermittedTaglibsTLV.this.permittedTaglibs.contains(value)) continue;
                PermittedTaglibsTLV.this.failed = true;
            }
        }
    }
}

