/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.stash;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.stash.ApplyStashAction;
import org.netbeans.modules.git.ui.stash.Bundle;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;

public final class Stash {
    private final GitRevisionInfo info;
    private final int index;
    private final String name;
    private final File repository;

    private Stash(File repository, GitRevisionInfo info, int index) {
        this.repository = repository;
        this.info = info;
        this.index = index;
        this.name = "stash@{" + index + "}";
    }

    public static List<Stash> create(File repository, List<GitRevisionInfo> stash) {
        int i = 0;
        ArrayList<Stash> items = new ArrayList<Stash>(stash.size());
        for (GitRevisionInfo info : stash) {
            items.add(new Stash(repository, info, i++));
        }
        return items;
    }

    public int getIndex() {
        return this.index;
    }

    public GitRevisionInfo getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    public Action getApplyAction() {
        return new AbstractAction(NbBundle.getMessage(ApplyStashAction.class, (String)"LBL_ApplyStashAction_PopupName")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Stash.this.apply(false);
            }
        };
    }

    public void apply(final boolean drop) {
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                GitProgressSupport supp = new GitProgressSupport(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void perform() {
                        try {
                            final GitClient client = this.getClient();
                            RepositoryInfo info = RepositoryInfo.getInstance(Stash.this.repository);
                            List<GitRevisionInfo> stashes = info.refreshStashes();
                            GitRevisionInfo currStash = stashes.get(Stash.this.index);
                            if (!currStash.getRevision().equals(Stash.this.getInfo().getRevision())) {
                                GitUtils.notifyError(Bundle.LBL_ApplyStashAction_outOfSync(), Bundle.MSG_ApplyStashAction_outOfSync());
                                return;
                            }
                            GitUtils.runWithoutIndexing(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    client.stashApply(Stash.this.index, drop, this.getProgressMonitor());
                                    return null;
                                }
                            }, Stash.this.repository);
                            if (drop) {
                                RepositoryInfo.getInstance(Stash.this.repository).refreshStashes();
                            }
                        }
                        catch (GitException ex) {
                            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                        }
                        finally {
                            this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                            Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(Stash.this.repository, Git.getInstance().getSeenRoots(Stash.this.repository)));
                        }
                    }
                };
                supp.start(Git.getInstance().getRequestProcessor(Stash.this.repository), Stash.this.repository, Bundle.MSG_ApplyStashAction_progressName());
            }
        }, (int)0);
    }
}

