/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.Realm;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AbstractRequestingAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.URLBasedX509CertificateSupplier;
import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.X509FederationClient;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.http.client.HttpResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalSdk
public abstract class AbstractFederationClientAuthenticationDetailsProviderBuilder<B extends AbstractFederationClientAuthenticationDetailsProviderBuilder<B, P>, P extends AbstractAuthenticationDetailsProvider>
extends AbstractRequestingAuthenticationDetailsProvider.Builder<B> {
    protected static final Service SERVICE = Services.serviceBuilder().serviceName("AUTH").serviceEndpointPrefix("auth").build();
    public static final String METADATA_SERVICE_BASE_URL = "http://169.254.169.254/opc/v2/";
    protected static final String FALLBACK_METADATA_SERVICE_URL = "http://169.254.169.254/opc/v1/";
    public static final String AUTHORIZATION_HEADER_VALUE = "Bearer Oracle";
    private static final String REGION_PATH_LITERAL = "region";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFederationClientAuthenticationDetailsProviderBuilder.class);
    protected volatile String metadataBaseUrl = "http://169.254.169.254/opc/v2/";
    protected String federationEndpoint;
    private volatile boolean wasFallbackCheckExecuted = false;
    protected X509CertificateSupplier leafCertificateSupplier;
    protected String tenancyId;
    private CircuitBreakerConfiguration circuitBreakerConfiguration;
    private String purpose = null;
    protected Region region = null;
    private static final Map<String, String> AUTHORIZATION_HEADER;

    public B metadataBaseUrl(String metadataBaseUrl) {
        this.metadataBaseUrl = metadataBaseUrl;
        if (!this.metadataBaseUrl.endsWith("/")) {
            this.metadataBaseUrl = this.metadataBaseUrl + "/";
        }
        return (B)this;
    }

    public B federationEndpoint(String federationEndpoint) {
        this.federationEndpoint = federationEndpoint;
        return (B)this;
    }

    public B leafCertificateSupplier(X509CertificateSupplier leafCertificateSupplier) {
        this.leafCertificateSupplier = leafCertificateSupplier;
        return (B)this;
    }

    public B tenancyId(String tenancyId) {
        this.tenancyId = tenancyId;
        return (B)this;
    }

    protected B purpose(String purpose) {
        this.purpose = purpose;
        return (B)this;
    }

    public B circuitBreakerConfigurator(CircuitBreakerConfiguration circuitBreakerConfiguration) {
        this.circuitBreakerConfiguration = circuitBreakerConfiguration;
        return (B)this;
    }

    public P build() {
        SessionKeySupplier sessionKeySupplierToUse = this.sessionKeySupplier != null ? this.sessionKeySupplier : new SessionKeySupplierImpl();
        this.federationClient = this.createFederationClient(sessionKeySupplierToUse);
        return this.buildProvider(sessionKeySupplierToUse);
    }

    protected FederationClient createFederationClient(SessionKeySupplier sessionKeySupplier) {
        CircuitBreakerConfiguration circuitBreakerConfig;
        CircuitBreakerConfiguration circuitBreakerConfiguration = circuitBreakerConfig = this.circuitBreakerConfiguration != null ? this.circuitBreakerConfiguration : CircuitBreakerUtils.getDefaultCircuitBreakerConfiguration();
        if (this.purpose != null) {
            return new X509FederationClient(this.federationEndpoint, this.tenancyId, this.leafCertificateSupplier, sessionKeySupplier, this.intermediateCertificateSuppliers, this.federationClientConfigurator, this.additionalFederationClientConfigurators, circuitBreakerConfig, this.purpose);
        }
        return new X509FederationClient(this.federationEndpoint, this.tenancyId, this.leafCertificateSupplier, sessionKeySupplier, this.intermediateCertificateSuppliers, this.federationClientConfigurator, this.additionalFederationClientConfigurators, circuitBreakerConfig);
    }

    protected void autoDetectUsingMetadataUrl() {
        this.autoDetectEndpointUsingMetadataUrl();
        this.autoDetectCertificatesUsingMetadataUrl();
    }

    protected String autoDetectEndpointUsingMetadataUrl() {
        if (this.federationEndpoint == null) {
            this.executeInstanceFallback();
            String regionStr = (String)this.fetchRegion(resp -> resp.textBody());
            LOG.info("Looking up region for {}", (Object)regionStr);
            try {
                this.region = Region.fromRegionCodeOrId(regionStr);
                LOG.info("Using region {}", (Object)this.region.getRegionId());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Region not supported by this version of the SDK, registering region '{}' under OC1", (Object)regionStr, (Object)e);
                this.region = Region.register(regionStr, Realm.OC1);
            }
            Optional<String> endpoint = this.region.getEndpoint(SERVICE);
            if (!endpoint.isPresent()) {
                throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + this.region);
            }
            this.federationEndpoint = endpoint.get();
        }
        return this.federationEndpoint;
    }

    protected void autoDetectCertificatesUsingMetadataUrl() {
        try {
            if (!this.wasFallbackCheckExecuted) {
                LOG.info(" Executing fallback check for certificates as federation endpoint was already set to {}", (Object)this.getFederationEndpoint());
                this.executeInstanceFallback();
            }
            if (this.leafCertificateSupplier == null) {
                this.leafCertificateSupplier = new URLBasedX509CertificateSupplier(this.getMetadataResourceDetails("identity/cert.pem"), this.getMetadataResourceDetails("identity/key.pem"), (char[])null);
            }
            if (this.tenancyId == null) {
                this.tenancyId = AuthUtils.getTenantIdFromCertificate(this.leafCertificateSupplier.getCertificateAndKeyPair().getCertificate());
            }
            if (this.intermediateCertificateSuppliers == null) {
                this.intermediateCertificateSuppliers = new HashSet();
                this.intermediateCertificateSuppliers.add(new URLBasedX509CertificateSupplier(this.getMetadataResourceDetails("identity/intermediate.pem"), null, (char[])null));
            }
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("The metadata service url is invalid.", ex);
        }
    }

    /*
     * Exception decompiling
     */
    private <R> R fetchRegion(Function<HttpResponse, CompletionStage<R>> responseHandler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeInstanceFallback() {
        try {
            int status = (Integer)this.fetchRegion(resp -> CompletableFuture.completedFuture(resp.status()));
            LOG.info("Rest call to verify if v2 endpoint exists, response from v2 was {}", (Object)status);
            if (status == 404) {
                LOG.warn("Falling back to v1, response from v2 was {}", (Object)status);
                this.metadataBaseUrl = FALLBACK_METADATA_SERVICE_URL;
            } else if (status >= 300) {
                throw new RuntimeException("Rest call to v2 endpoint failed : HTTP error code : " + status);
            }
            this.wasFallbackCheckExecuted = true;
            LOG.info(" Metadata base url on executing instance fallback is {}", (Object)this.getMetadataBaseUrl());
        }
        catch (RuntimeException e) {
            LOG.warn("Rest call to v2 endpoint failed & cannot fallback as it's not 404 ", (Throwable)e);
        }
    }

    private URLBasedX509CertificateSupplier.ResourceDetails getMetadataResourceDetails(String path) throws MalformedURLException {
        return URLBasedX509CertificateSupplier.ResourceDetails.builder().url(new URL(this.getMetadataBaseUrl() + path)).headers(AUTHORIZATION_HEADER).build();
    }

    protected abstract P buildProvider(SessionKeySupplier var1);

    public String getMetadataBaseUrl() {
        return this.metadataBaseUrl;
    }

    public String getFederationEndpoint() {
        return this.federationEndpoint;
    }

    public X509CertificateSupplier getLeafCertificateSupplier() {
        return this.leafCertificateSupplier;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public Region getRegion() {
        return this.region;
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("Authorization", AUTHORIZATION_HEADER_VALUE);
        AUTHORIZATION_HEADER = Collections.unmodifiableMap(temp);
    }

    static class SessionKeySupplierImpl
    implements SessionKeySupplier {
        private static final KeyPairGenerator GENERATOR;
        private KeyPair keyPair = GENERATOR.generateKeyPair();

        SessionKeySupplierImpl() {
        }

        @Override
        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public void refreshKeys() {
            this.keyPair = GENERATOR.generateKeyPair();
        }

        static {
            try {
                GENERATOR = KeyPairGenerator.getInstance("RSA");
                GENERATOR.initialize(2048);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error(e.getMessage(), e);
            }
        }
    }
}

