/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesConfigurableRefresh;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.GetResourcePrincipalSessionTokenRequest;
import com.oracle.bmc.auth.internal.GetResourcePrincipalTokenResponse;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.auth.internal.X509FederationClient;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.OciCircuitBreaker;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpClientBuilder;
import com.oracle.bmc.http.client.HttpProvider;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.StandardClientProperties;
import com.oracle.bmc.http.internal.AuthnClientFilter;
import com.oracle.bmc.http.internal.CircuitBreakerHelper;
import com.oracle.bmc.http.internal.ClientCall;
import com.oracle.bmc.http.internal.ClientIdFilter;
import com.oracle.bmc.http.internal.LogHeadersFilter;
import com.oracle.bmc.http.signing.DefaultRequestSigner;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Validate;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFederationClient
implements FederationClient,
ProvidesConfigurableRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFederationClient.class);
    protected final SessionKeySupplier sessionKeySupplier;
    private volatile SecurityTokenAdapter securityTokenAdapter = null;
    private final ClientConfigurator clientConfigurator;
    private final OciCircuitBreaker circuitBreaker;
    private final HttpClient resourcePrincipalTokenClient;
    private final HttpClient federationClient;

    public AbstractFederationClient(String resourcePrincipalTokenEndpoint, String federationEndpoint, SessionKeySupplier sessionKeySupplier, BasicAuthenticationDetailsProvider basicAuthenticationDetailsProvider, ClientConfigurator clientConfigurator, CircuitBreakerConfiguration circuitBreakerConfiguration) {
        Objects.requireNonNull(resourcePrincipalTokenEndpoint, "resourcePrincipalTokenEndpoint");
        Objects.requireNonNull(federationEndpoint, "federationEndpoint");
        this.sessionKeySupplier = Validate.notNull(sessionKeySupplier, "sessionKeySupplier must not be null", new Object[0]);
        RequestSigner requestSigner = DefaultRequestSigner.createRequestSigner(basicAuthenticationDetailsProvider);
        this.clientConfigurator = clientConfigurator;
        this.resourcePrincipalTokenClient = this.makeClient(resourcePrincipalTokenEndpoint, requestSigner);
        this.federationClient = this.makeClient(federationEndpoint, requestSigner);
        this.circuitBreaker = CircuitBreakerHelper.makeCircuitBreaker(this.federationClient, circuitBreakerConfiguration);
        this.securityTokenAdapter = new SecurityTokenAdapter(null, sessionKeySupplier);
    }

    private HttpClient makeClient(String endpoint, RequestSigner requestSigner) {
        HttpClientBuilder rptBuilder = HttpProvider.getDefault().newBuilder().property(StandardClientProperties.ASYNC_POOL_SIZE, (Object)1).baseUri(URI.create(endpoint)).registerRequestInterceptor(1000, (RequestInterceptor)new AuthnClientFilter(requestSigner, Collections.emptyMap())).registerRequestInterceptor(3000, (RequestInterceptor)new ClientIdFilter()).registerRequestInterceptor(5000, (RequestInterceptor)new LogHeadersFilter());
        if (this.clientConfigurator != null) {
            this.clientConfigurator.customizeClient(rptBuilder);
        }
        return rptBuilder.build();
    }

    @Override
    public String getSecurityToken() {
        if (this.securityTokenAdapter.isValid()) {
            return this.securityTokenAdapter.getSecurityToken();
        }
        return this.refreshAndGetSecurityTokenInner(true, Optional.empty(), true);
    }

    @Override
    public String refreshAndGetSecurityToken() {
        return this.refreshAndGetSecurityTokenInner(false, Optional.empty(), true);
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time, boolean refreshKeys) {
        return this.refreshAndGetSecurityTokenInner(true, Optional.of(time), refreshKeys);
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time) {
        return this.refreshAndGetSecurityTokenInner(true, Optional.of(time), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String refreshAndGetSecurityTokenInner(boolean doFinalTokenValidityCheck, Optional<Duration> time, boolean refreshKeys) {
        AbstractFederationClient abstractFederationClient = this;
        synchronized (abstractFederationClient) {
            if (!doFinalTokenValidityCheck || (time.isPresent() ? !this.securityTokenAdapter.isValid(time) : !this.securityTokenAdapter.isValid())) {
                if (refreshKeys) {
                    LOG.info("Refreshing session keys.");
                    this.sessionKeySupplier.refreshKeys();
                }
                this.securityTokenAdapter = this.getSecurityTokenFromServer();
                return this.securityTokenAdapter.getSecurityToken();
            }
            return this.securityTokenAdapter.getSecurityToken();
        }
    }

    protected abstract SecurityTokenAdapter getSecurityTokenFromServer();

    @Override
    public String getStringClaim(String key) {
        return null;
    }

    protected SecurityTokenAdapter requestSessionToken(final GetResourcePrincipalSessionTokenRequest getResourcePrincipalSessionTokenRequest) {
        X509FederationClient.SecurityToken securityToken = ((X509FederationClient.FederationResponseWrapper)ClientCall.builder((HttpClient)this.federationClient, new BmcRequest<GetResourcePrincipalSessionTokenRequest>(){

            @Override
            public GetResourcePrincipalSessionTokenRequest getBody$() {
                return getResourcePrincipalSessionTokenRequest;
            }
        }, (Supplier<X509FederationClient.FederationResponseWrapper.Builder>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lcom/oracle/bmc/auth/internal/X509FederationClient$FederationResponseWrapper$Builder;)()).method((Method)Method.POST).logger((Logger)AbstractFederationClient.LOG, (String)"ResourcePrincipalsFederationClient").handleBody(X509FederationClient.SecurityToken.class, (BiConsumer<X509FederationClient.FederationResponseWrapper.Builder, X509FederationClient.SecurityToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$requestSessionToken$0(com.oracle.bmc.auth.internal.X509FederationClient$FederationResponseWrapper$Builder com.oracle.bmc.auth.internal.X509FederationClient$SecurityToken ), (Lcom/oracle/bmc/auth/internal/X509FederationClient$FederationResponseWrapper$Builder;Lcom/oracle/bmc/auth/internal/X509FederationClient$SecurityToken;)V)()).clientConfigurator((ClientConfigurator)this.clientConfigurator).appendPathPart((String)"v1").appendPathPart((String)"resourcePrincipalSessionToken").circuitBreaker((OciCircuitBreaker)this.circuitBreaker).hasBody().callSync()).token;
        return new SecurityTokenAdapter(securityToken.getToken(), this.sessionKeySupplier);
    }

    protected ClientCall<?, GetResourcePrincipalTokenResponse.ResponseWrapper, ?> prepareRptCall() {
        return ClientCall.builder(this.resourcePrincipalTokenClient, new BmcRequest(), GetResourcePrincipalTokenResponse.ResponseWrapper.Builder::new).handleBody(GetResourcePrincipalTokenResponse.class, (w, b) -> {
            w.body = b;
        }).clientConfigurator(this.clientConfigurator).circuitBreaker(this.circuitBreaker);
    }

    private static /* synthetic */ void lambda$requestSessionToken$0(X509FederationClient.FederationResponseWrapper.Builder w, X509FederationClient.SecurityToken t) {
        w.token = t;
    }
}

