/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.Serialization;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHelper.class);
    private static final ObjectReader STRING_READER = Serialization.getObjectMapper().readerFor(String.class);
    private static final int MAX_RESPONSE_BUFFER_BYTES = 4096;
    private static final String OPC_REQUEST_ID_HEADER = "opc-request-id";
    @InternalSdk
    public static final Map<Integer, String> DEFAULT_ERROR_MESSAGES = new HashMap<Integer, String>();

    static {
        DEFAULT_ERROR_MESSAGES.put(404, "The resource does not exist or the request was not authorized");
        DEFAULT_ERROR_MESSAGES.put(412, "Precondition failed");
    }

    @JsonDeserialize(builder=Builder.class)
    public static final class ErrorCodeAndMessage {
        private final String code;
        private final String message;
        private final String originalMessage;
        private final String originalMessageTemplate;
        private final Map<String, String> messageArguments;

        @ConstructorProperties(value={"code", "message", "originalMessage", "originalMessageTemplate", "messageArguments"})
        ErrorCodeAndMessage(String code, String message, String originalMessage, String originalMessageTemplate, Map<String, String> messageArguments) {
            this.code = code;
            this.message = message;
            this.originalMessage = originalMessage;
            this.originalMessageTemplate = originalMessageTemplate;
            this.messageArguments = messageArguments;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String getOriginalMessage() {
            return this.originalMessage;
        }

        public String getOriginalMessageTemplate() {
            return this.originalMessageTemplate;
        }

        public Map<String, String> getMessageArguments() {
            return this.messageArguments;
        }

        public boolean equals(Object o) {
            Map<String, String> other$messageArguments;
            String other$originalMessageTemplate;
            String other$originalMessage;
            String other$message;
            String other$code;
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorCodeAndMessage)) {
                return false;
            }
            ErrorCodeAndMessage other = (ErrorCodeAndMessage)o;
            String this$code = this.getCode();
            if (!Objects.equals(this$code, other$code = other.getCode())) {
                return false;
            }
            String this$message = this.getMessage();
            if (!Objects.equals(this$message, other$message = other.getMessage())) {
                return false;
            }
            String this$originalMessage = this.getOriginalMessage();
            if (!Objects.equals(this$originalMessage, other$originalMessage = other.getOriginalMessage())) {
                return false;
            }
            String this$originalMessageTemplate = this.getOriginalMessageTemplate();
            if (!Objects.equals(this$originalMessageTemplate, other$originalMessageTemplate = other.getOriginalMessageTemplate())) {
                return false;
            }
            Map<String, String> this$messageArguments = this.getMessageArguments();
            return Objects.equals(this$messageArguments, other$messageArguments = other.getMessageArguments());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $originalMessage = this.getOriginalMessage();
            result = result * 59 + ($originalMessage == null ? 43 : $originalMessage.hashCode());
            String $originalMessageTemplate = this.getOriginalMessageTemplate();
            result = result * 59 + ($originalMessageTemplate == null ? 43 : $originalMessageTemplate.hashCode());
            Map<String, String> $messageArguments = this.getMessageArguments();
            result = result * 59 + ($messageArguments == null ? 43 : ((Object)$messageArguments).hashCode());
            return result;
        }

        public String toString() {
            return "ResponseHelper.ErrorCodeAndMessage(code=" + this.getCode() + ", message=" + this.getMessage() + ", originalMessage=" + this.getOriginalMessage() + ", originalMessageTemplate=" + this.getOriginalMessageTemplate() + ", messageArguments=" + this.getMessageArguments() + ")";
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private String code;
            private String message;
            private String originalMessage;
            private String originalMessageTemplate;
            private Map<String, String> messageArguments;

            Builder() {
            }

            public Builder code(String code) {
                this.code = code;
                return this;
            }

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder originalMessage(String originalMessage) {
                this.originalMessage = originalMessage;
                return this;
            }

            public Builder originalMessageTemplate(String originalMessageTemplate) {
                this.originalMessageTemplate = originalMessageTemplate;
                return this;
            }

            public Builder messageArguments(Map<String, String> messageArguments) {
                this.messageArguments = messageArguments;
                return this;
            }

            public ErrorCodeAndMessage build() {
                return new ErrorCodeAndMessage(this.code, this.message, this.originalMessage, this.originalMessageTemplate, this.messageArguments);
            }

            public String toString() {
                return "ResponseHelper.ErrorCodeAndMessage.Builder(code=" + this.code + ", message=" + this.message + ")";
            }
        }
    }
}

