/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletDialog;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class DownloadWalletAction
extends AbstractAction
implements ContextAwareAction {
    private static final Logger LOG = Logger.getLogger(DownloadWalletAction.class.getName());
    private static final String URL_TEMPLATE = "jdbc:oracle:thin:@{0}?TNS_ADMIN={1}";
    private final DatabaseItem context;
    private OCIProfile session;

    public DownloadWalletAction(DatabaseItem context) {
        this.context = context;
        this.session = OCIManager.getDefault().getActiveProfile();
    }

    DownloadWalletAction(OCIProfile session, DatabaseItem context) {
        this.context = context;
        this.session = session;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        OCIProfile session = (OCIProfile)actionContext.lookup(OCIProfile.class);
        return new DownloadWalletAction(session, this.context);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Optional<DownloadWalletDialog.WalletInfo> result = DownloadWalletDialog.showDialog(this.context);
        result.ifPresent(p -> this.addConnection((DownloadWalletDialog.WalletInfo)p));
    }

    void addConnection(DownloadWalletDialog.WalletInfo p) {
        try {
            Path walletPath = this.session.downloadWallet(this.context, new String(p.getWalletPassword()), p.getPath());
            if (p.getDbUser() != null && p.getDbPassword() != null) {
                JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers("oracle.jdbc.OracleDriver");
                JDBCDriver jarsPresent = null;
                if (drivers.length > 0) {
                    String connectionName;
                    for (JDBCDriver d : drivers) {
                        if (!DownloadWalletAction.isAvailable(d)) continue;
                        jarsPresent = d;
                        break;
                    }
                    if (jarsPresent == null) {
                        jarsPresent = drivers[0];
                        LOG.log(Level.WARNING, "Unable to find driver JARs for wallet {0}, using fallback driver: {1}", new Object[]{walletPath, jarsPresent.getName()});
                        NotifyDescriptor.Confirmation msg = new NotifyDescriptor.Confirmation((Object)Bundle.WARN_DriverWithoutJars(jarsPresent.getName()), 2, 0);
                        Object choice = DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        if (choice != NotifyDescriptor.YES_OPTION && choice != NotifyDescriptor.OK_OPTION) {
                            return;
                        }
                    }
                    if ((connectionName = this.context.getConnectionName()) == null) {
                        Optional n = this.parseConnectionNames(walletPath).stream().findFirst();
                        if (n.isPresent()) {
                            connectionName = (String)n.get();
                        } else {
                            StatusDisplayer.getDefault().setStatusText(Bundle.MSG_WalletNoConnection());
                            return;
                        }
                    }
                    Properties props = new Properties();
                    props.put("OCID", p.getOcid());
                    String dbUrl = MessageFormat.format(URL_TEMPLATE, connectionName, BaseUtilities.escapeParameters((String[])new String[]{walletPath.toString()}));
                    DatabaseConnection dbConn = DatabaseConnection.create((JDBCDriver)drivers[0], (String)dbUrl, (String)p.getDbUser(), (String)p.getDbUser(), (String)new String(p.getDbPassword()), (boolean)true, (String)this.context.getName(), (Properties)props);
                    ConnectionManager.getDefault().addConnection(dbConn);
                }
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_WalletDownloadedPassword(new String(p.getWalletPassword()))));
            } else {
                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_WalletDownloaded(walletPath.toString()));
            }
        }
        catch (IOException | DatabaseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static boolean isAvailable(JDBCDriver driver) {
        URL[] urls;
        for (URL u : urls = driver.getURLs()) {
            if (URLMapper.findFileObject((URL)u) != null) continue;
            return false;
        }
        if (urls.length > 0) {
            return true;
        }
        try {
            Class.forName(driver.getClassName(), true, ClassLoader.getSystemClassLoader());
            return true;
        }
        catch (ClassNotFoundException | LinkageError | SecurityException ex) {
            return false;
        }
    }

    protected List<String> parseConnectionNames(Path wallet) {
        Path tns = wallet.resolve("tnsnames.ora");
        try {
            return Files.newBufferedReader(tns).lines().filter(l -> l.contains("=")).map(l -> l.substring(0, l.indexOf("=")).trim()).collect(Collectors.toList());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }
}

