/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.Places;

public final class NewJ2SEPlatform
extends J2SEPlatformImpl
implements Runnable {
    public static final String DISPLAY_NAME_FILE_ATTR = "J2SEPlatform.displayName";
    private static final Logger LOGGER = Logger.getLogger(NewJ2SEPlatform.class.getName());
    private boolean valid;

    public static NewJ2SEPlatform create(FileObject installFolder) throws IOException {
        assert (installFolder != null);
        HashMap<String, String> platformProperties = new HashMap<String, String>();
        return new NewJ2SEPlatform(null, Collections.singletonList(installFolder.toURL()), platformProperties, Collections.emptyMap());
    }

    private NewJ2SEPlatform(String name, List<URL> installFolders, Map<String, String> platformProperties, Map<String, String> systemProperties) {
        super(name, name, installFolders, platformProperties, systemProperties, null, null);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void run() {
        try {
            for (String toolName : PlatformConvertor.IMPORTANT_TOOLS) {
                if (this.findTool(toolName) != null) continue;
                return;
            }
            FileObject java = this.findTool("java");
            if (java == null) {
                return;
            }
            File javaFile = FileUtil.toFile((FileObject)java);
            if (javaFile == null) {
                return;
            }
            String javapath = javaFile.getAbsolutePath();
            FileObject javac = this.findTool("javac");
            if (javac == null) {
                return;
            }
            File javacFile = FileUtil.toFile((FileObject)javac);
            if (javacFile == null) {
                return;
            }
            String javacpath = javacFile.getAbsolutePath();
            String filePath = File.createTempFile("nb-platformdetect", "properties").getAbsolutePath();
            String probePath = this.getSDKProperties(javapath, javacpath, filePath);
            File f = new File(filePath);
            Properties p = new Properties();
            try (FileInputStream is = new FileInputStream(f);){
                p.load(is);
            }
            Collection<FileObject> instFolders = this.getInstallFolders();
            HashMap<String, String> m = new HashMap<String, String>(p.size());
            Enumeration<Object> en = p.keys();
            while (en.hasMoreElements()) {
                String k = (String)en.nextElement();
                String v = p.getProperty(k);
                if ("user.dir".equals(k)) {
                    v = "";
                }
                v = Util.fixSymLinks(k, v, instFolders);
                m.put(k, v);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Platform properties: {0}", m);
            }
            this.setSystemProperties(Util.filterProbe(m, probePath));
            this.valid = true;
            f.delete();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot execute probe process", ex);
            this.valid = false;
        }
    }

    private String getSDKProperties(String javaPath, String javacPath, String path) throws IOException {
        try {
            String probeDir = Places.getCacheSubdirectory((String)"j2seplatform/probe").getAbsolutePath();
            File probeSrc = InstalledFileLocator.getDefault().locate("scripts/J2SEPlatformProbe.java", "org.netbeans.modules.java.j2seplatform", false);
            Process compile = new ProcessBuilder(javacPath, "-d", probeDir, probeSrc.getAbsolutePath()).inheritIO().start();
            compile.waitFor();
            int compileExitValue = compile.exitValue();
            if (compileExitValue != 0) {
                throw new IOException(String.format("javac process exit code: %d", compileExitValue));
            }
            Process probe = new ProcessBuilder(javaPath, "-cp", probeDir, "J2SEPlatformProbe", path).inheritIO().start();
            probe.waitFor();
            int probeExitValue = probe.exitValue();
            if (probeExitValue != 0) {
                throw new IOException(String.format("Java process exit code: %d", probeExitValue));
            }
            return probeDir;
        }
        catch (InterruptedException ex) {
            IOException e = new IOException(ex);
            throw e;
        }
    }
}

