/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.devops.DevopsAsync;
import com.oracle.bmc.devops.model.BuildPipeline;
import com.oracle.bmc.devops.model.BuildPipelineCollection;
import com.oracle.bmc.devops.model.BuildPipelineStage;
import com.oracle.bmc.devops.model.BuildPipelineStageCollection;
import com.oracle.bmc.devops.model.BuildRun;
import com.oracle.bmc.devops.model.BuildRunSummaryCollection;
import com.oracle.bmc.devops.model.Connection;
import com.oracle.bmc.devops.model.ConnectionCollection;
import com.oracle.bmc.devops.model.DeployArtifact;
import com.oracle.bmc.devops.model.DeployArtifactCollection;
import com.oracle.bmc.devops.model.DeployEnvironment;
import com.oracle.bmc.devops.model.DeployEnvironmentCollection;
import com.oracle.bmc.devops.model.DeployPipeline;
import com.oracle.bmc.devops.model.DeployPipelineCollection;
import com.oracle.bmc.devops.model.DeployStage;
import com.oracle.bmc.devops.model.DeployStageCollection;
import com.oracle.bmc.devops.model.Deployment;
import com.oracle.bmc.devops.model.DeploymentCollection;
import com.oracle.bmc.devops.model.DiffCollection;
import com.oracle.bmc.devops.model.DiffResponse;
import com.oracle.bmc.devops.model.FileDiffResponse;
import com.oracle.bmc.devops.model.Project;
import com.oracle.bmc.devops.model.ProjectCollection;
import com.oracle.bmc.devops.model.Repository;
import com.oracle.bmc.devops.model.RepositoryAuthorCollection;
import com.oracle.bmc.devops.model.RepositoryCollection;
import com.oracle.bmc.devops.model.RepositoryCommit;
import com.oracle.bmc.devops.model.RepositoryCommitCollection;
import com.oracle.bmc.devops.model.RepositoryFileLines;
import com.oracle.bmc.devops.model.RepositoryMirrorRecord;
import com.oracle.bmc.devops.model.RepositoryMirrorRecordCollection;
import com.oracle.bmc.devops.model.RepositoryObject;
import com.oracle.bmc.devops.model.RepositoryPathCollection;
import com.oracle.bmc.devops.model.RepositoryRef;
import com.oracle.bmc.devops.model.RepositoryRefCollection;
import com.oracle.bmc.devops.model.Trigger;
import com.oracle.bmc.devops.model.TriggerCollection;
import com.oracle.bmc.devops.model.TriggerCreateResult;
import com.oracle.bmc.devops.model.WorkRequest;
import com.oracle.bmc.devops.model.WorkRequestCollection;
import com.oracle.bmc.devops.model.WorkRequestErrorCollection;
import com.oracle.bmc.devops.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.devops.requests.ApproveDeploymentRequest;
import com.oracle.bmc.devops.requests.CancelBuildRunRequest;
import com.oracle.bmc.devops.requests.CancelDeploymentRequest;
import com.oracle.bmc.devops.requests.CancelScheduledCascadingProjectDeletionRequest;
import com.oracle.bmc.devops.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.devops.requests.CreateBuildPipelineRequest;
import com.oracle.bmc.devops.requests.CreateBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.CreateBuildRunRequest;
import com.oracle.bmc.devops.requests.CreateConnectionRequest;
import com.oracle.bmc.devops.requests.CreateDeployArtifactRequest;
import com.oracle.bmc.devops.requests.CreateDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.CreateDeployPipelineRequest;
import com.oracle.bmc.devops.requests.CreateDeployStageRequest;
import com.oracle.bmc.devops.requests.CreateDeploymentRequest;
import com.oracle.bmc.devops.requests.CreateProjectRequest;
import com.oracle.bmc.devops.requests.CreateRepositoryRequest;
import com.oracle.bmc.devops.requests.CreateTriggerRequest;
import com.oracle.bmc.devops.requests.DeleteBuildPipelineRequest;
import com.oracle.bmc.devops.requests.DeleteBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.DeleteConnectionRequest;
import com.oracle.bmc.devops.requests.DeleteDeployArtifactRequest;
import com.oracle.bmc.devops.requests.DeleteDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.DeleteDeployPipelineRequest;
import com.oracle.bmc.devops.requests.DeleteDeployStageRequest;
import com.oracle.bmc.devops.requests.DeleteProjectRequest;
import com.oracle.bmc.devops.requests.DeleteRefRequest;
import com.oracle.bmc.devops.requests.DeleteRepositoryRequest;
import com.oracle.bmc.devops.requests.DeleteTriggerRequest;
import com.oracle.bmc.devops.requests.GetBuildPipelineRequest;
import com.oracle.bmc.devops.requests.GetBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.GetBuildRunRequest;
import com.oracle.bmc.devops.requests.GetCommitDiffRequest;
import com.oracle.bmc.devops.requests.GetCommitRequest;
import com.oracle.bmc.devops.requests.GetConnectionRequest;
import com.oracle.bmc.devops.requests.GetDeployArtifactRequest;
import com.oracle.bmc.devops.requests.GetDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.GetDeployPipelineRequest;
import com.oracle.bmc.devops.requests.GetDeployStageRequest;
import com.oracle.bmc.devops.requests.GetDeploymentRequest;
import com.oracle.bmc.devops.requests.GetFileDiffRequest;
import com.oracle.bmc.devops.requests.GetMirrorRecordRequest;
import com.oracle.bmc.devops.requests.GetObjectContentRequest;
import com.oracle.bmc.devops.requests.GetObjectRequest;
import com.oracle.bmc.devops.requests.GetProjectRequest;
import com.oracle.bmc.devops.requests.GetRefRequest;
import com.oracle.bmc.devops.requests.GetRepoFileDiffRequest;
import com.oracle.bmc.devops.requests.GetRepoFileLinesRequest;
import com.oracle.bmc.devops.requests.GetRepositoryArchiveContentRequest;
import com.oracle.bmc.devops.requests.GetRepositoryFileLinesRequest;
import com.oracle.bmc.devops.requests.GetRepositoryRequest;
import com.oracle.bmc.devops.requests.GetTriggerRequest;
import com.oracle.bmc.devops.requests.GetWorkRequestRequest;
import com.oracle.bmc.devops.requests.ListAuthorsRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelineStagesRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelinesRequest;
import com.oracle.bmc.devops.requests.ListBuildRunsRequest;
import com.oracle.bmc.devops.requests.ListCommitDiffsRequest;
import com.oracle.bmc.devops.requests.ListCommitsRequest;
import com.oracle.bmc.devops.requests.ListConnectionsRequest;
import com.oracle.bmc.devops.requests.ListDeployArtifactsRequest;
import com.oracle.bmc.devops.requests.ListDeployEnvironmentsRequest;
import com.oracle.bmc.devops.requests.ListDeployPipelinesRequest;
import com.oracle.bmc.devops.requests.ListDeployStagesRequest;
import com.oracle.bmc.devops.requests.ListDeploymentsRequest;
import com.oracle.bmc.devops.requests.ListMirrorRecordsRequest;
import com.oracle.bmc.devops.requests.ListPathsRequest;
import com.oracle.bmc.devops.requests.ListProjectsRequest;
import com.oracle.bmc.devops.requests.ListRefsRequest;
import com.oracle.bmc.devops.requests.ListRepositoriesRequest;
import com.oracle.bmc.devops.requests.ListTriggersRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestsRequest;
import com.oracle.bmc.devops.requests.MirrorRepositoryRequest;
import com.oracle.bmc.devops.requests.PutRepositoryRefRequest;
import com.oracle.bmc.devops.requests.ScheduleCascadingProjectDeletionRequest;
import com.oracle.bmc.devops.requests.UpdateBuildPipelineRequest;
import com.oracle.bmc.devops.requests.UpdateBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.UpdateBuildRunRequest;
import com.oracle.bmc.devops.requests.UpdateConnectionRequest;
import com.oracle.bmc.devops.requests.UpdateDeployArtifactRequest;
import com.oracle.bmc.devops.requests.UpdateDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.UpdateDeployPipelineRequest;
import com.oracle.bmc.devops.requests.UpdateDeployStageRequest;
import com.oracle.bmc.devops.requests.UpdateDeploymentRequest;
import com.oracle.bmc.devops.requests.UpdateProjectRequest;
import com.oracle.bmc.devops.requests.UpdateRepositoryRequest;
import com.oracle.bmc.devops.requests.UpdateTriggerRequest;
import com.oracle.bmc.devops.responses.ApproveDeploymentResponse;
import com.oracle.bmc.devops.responses.CancelBuildRunResponse;
import com.oracle.bmc.devops.responses.CancelDeploymentResponse;
import com.oracle.bmc.devops.responses.CancelScheduledCascadingProjectDeletionResponse;
import com.oracle.bmc.devops.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.devops.responses.CreateBuildPipelineResponse;
import com.oracle.bmc.devops.responses.CreateBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.CreateBuildRunResponse;
import com.oracle.bmc.devops.responses.CreateConnectionResponse;
import com.oracle.bmc.devops.responses.CreateDeployArtifactResponse;
import com.oracle.bmc.devops.responses.CreateDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.CreateDeployPipelineResponse;
import com.oracle.bmc.devops.responses.CreateDeployStageResponse;
import com.oracle.bmc.devops.responses.CreateDeploymentResponse;
import com.oracle.bmc.devops.responses.CreateProjectResponse;
import com.oracle.bmc.devops.responses.CreateRepositoryResponse;
import com.oracle.bmc.devops.responses.CreateTriggerResponse;
import com.oracle.bmc.devops.responses.DeleteBuildPipelineResponse;
import com.oracle.bmc.devops.responses.DeleteBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.DeleteConnectionResponse;
import com.oracle.bmc.devops.responses.DeleteDeployArtifactResponse;
import com.oracle.bmc.devops.responses.DeleteDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.DeleteDeployPipelineResponse;
import com.oracle.bmc.devops.responses.DeleteDeployStageResponse;
import com.oracle.bmc.devops.responses.DeleteProjectResponse;
import com.oracle.bmc.devops.responses.DeleteRefResponse;
import com.oracle.bmc.devops.responses.DeleteRepositoryResponse;
import com.oracle.bmc.devops.responses.DeleteTriggerResponse;
import com.oracle.bmc.devops.responses.GetBuildPipelineResponse;
import com.oracle.bmc.devops.responses.GetBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.GetBuildRunResponse;
import com.oracle.bmc.devops.responses.GetCommitDiffResponse;
import com.oracle.bmc.devops.responses.GetCommitResponse;
import com.oracle.bmc.devops.responses.GetConnectionResponse;
import com.oracle.bmc.devops.responses.GetDeployArtifactResponse;
import com.oracle.bmc.devops.responses.GetDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.GetDeployPipelineResponse;
import com.oracle.bmc.devops.responses.GetDeployStageResponse;
import com.oracle.bmc.devops.responses.GetDeploymentResponse;
import com.oracle.bmc.devops.responses.GetFileDiffResponse;
import com.oracle.bmc.devops.responses.GetMirrorRecordResponse;
import com.oracle.bmc.devops.responses.GetObjectContentResponse;
import com.oracle.bmc.devops.responses.GetObjectResponse;
import com.oracle.bmc.devops.responses.GetProjectResponse;
import com.oracle.bmc.devops.responses.GetRefResponse;
import com.oracle.bmc.devops.responses.GetRepoFileDiffResponse;
import com.oracle.bmc.devops.responses.GetRepoFileLinesResponse;
import com.oracle.bmc.devops.responses.GetRepositoryArchiveContentResponse;
import com.oracle.bmc.devops.responses.GetRepositoryFileLinesResponse;
import com.oracle.bmc.devops.responses.GetRepositoryResponse;
import com.oracle.bmc.devops.responses.GetTriggerResponse;
import com.oracle.bmc.devops.responses.GetWorkRequestResponse;
import com.oracle.bmc.devops.responses.ListAuthorsResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelineStagesResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelinesResponse;
import com.oracle.bmc.devops.responses.ListBuildRunsResponse;
import com.oracle.bmc.devops.responses.ListCommitDiffsResponse;
import com.oracle.bmc.devops.responses.ListCommitsResponse;
import com.oracle.bmc.devops.responses.ListConnectionsResponse;
import com.oracle.bmc.devops.responses.ListDeployArtifactsResponse;
import com.oracle.bmc.devops.responses.ListDeployEnvironmentsResponse;
import com.oracle.bmc.devops.responses.ListDeployPipelinesResponse;
import com.oracle.bmc.devops.responses.ListDeployStagesResponse;
import com.oracle.bmc.devops.responses.ListDeploymentsResponse;
import com.oracle.bmc.devops.responses.ListMirrorRecordsResponse;
import com.oracle.bmc.devops.responses.ListPathsResponse;
import com.oracle.bmc.devops.responses.ListProjectsResponse;
import com.oracle.bmc.devops.responses.ListRefsResponse;
import com.oracle.bmc.devops.responses.ListRepositoriesResponse;
import com.oracle.bmc.devops.responses.ListTriggersResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestsResponse;
import com.oracle.bmc.devops.responses.MirrorRepositoryResponse;
import com.oracle.bmc.devops.responses.PutRepositoryRefResponse;
import com.oracle.bmc.devops.responses.ScheduleCascadingProjectDeletionResponse;
import com.oracle.bmc.devops.responses.UpdateBuildPipelineResponse;
import com.oracle.bmc.devops.responses.UpdateBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.UpdateBuildRunResponse;
import com.oracle.bmc.devops.responses.UpdateConnectionResponse;
import com.oracle.bmc.devops.responses.UpdateDeployArtifactResponse;
import com.oracle.bmc.devops.responses.UpdateDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.UpdateDeployPipelineResponse;
import com.oracle.bmc.devops.responses.UpdateDeployStageResponse;
import com.oracle.bmc.devops.responses.UpdateDeploymentResponse;
import com.oracle.bmc.devops.responses.UpdateProjectResponse;
import com.oracle.bmc.devops.responses.UpdateRepositoryResponse;
import com.oracle.bmc.devops.responses.UpdateTriggerResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevopsAsyncClient
extends BaseAsyncClient
implements DevopsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DEVOPS").serviceEndpointPrefix("").serviceEndpointTemplate("https://devops.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DevopsAsyncClient.class);

    private DevopsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ApproveDeploymentResponse> approveDeployment(ApproveDeploymentRequest request, AsyncHandler<ApproveDeploymentRequest, ApproveDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getApproveDeploymentDetails(), "approveDeploymentDetails is required");
        return this.clientCall(request, ApproveDeploymentResponse::builder).logger(LOG, "approveDeployment").serviceDetails("Devops", "ApproveDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/ApproveDeployment").method(Method.POST).requestBuilder(ApproveDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("approve").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Deployment.class, ApproveDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", ApproveDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ApproveDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelBuildRunResponse> cancelBuildRun(CancelBuildRunRequest request, AsyncHandler<CancelBuildRunRequest, CancelBuildRunResponse> handler) {
        Objects.requireNonNull(request.getCancelBuildRunDetails(), "cancelBuildRunDetails is required");
        Validate.notBlank((String)request.getBuildRunId(), (String)"buildRunId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelBuildRunResponse::builder).logger(LOG, "cancelBuildRun").serviceDetails("Devops", "CancelBuildRun", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/CancelBuildRun").method(Method.POST).requestBuilder(CancelBuildRunRequest::builder).basePath("/20210630").appendPathParam("buildRuns").appendPathParam(request.getBuildRunId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(BuildRun.class, CancelBuildRunResponse.Builder::buildRun).handleResponseHeaderString("etag", CancelBuildRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelBuildRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelDeploymentResponse> cancelDeployment(CancelDeploymentRequest request, AsyncHandler<CancelDeploymentRequest, CancelDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCancelDeploymentDetails(), "cancelDeploymentDetails is required");
        return this.clientCall(request, CancelDeploymentResponse::builder).logger(LOG, "cancelDeployment").serviceDetails("Devops", "CancelDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/CancelDeployment").method(Method.POST).requestBuilder(CancelDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Deployment.class, CancelDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", CancelDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelScheduledCascadingProjectDeletionResponse> cancelScheduledCascadingProjectDeletion(CancelScheduledCascadingProjectDeletionRequest request, AsyncHandler<CancelScheduledCascadingProjectDeletionRequest, CancelScheduledCascadingProjectDeletionResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelScheduledCascadingProjectDeletionResponse::builder).logger(LOG, "cancelScheduledCascadingProjectDeletion").serviceDetails("Devops", "CancelScheduledCascadingProjectDeletion", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/CancelScheduledCascadingProjectDeletion").method(Method.POST).requestBuilder(CancelScheduledCascadingProjectDeletionRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("cancelScheduledCascadingProjectDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", CancelScheduledCascadingProjectDeletionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CancelScheduledCascadingProjectDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeProjectCompartmentResponse> changeProjectCompartment(ChangeProjectCompartmentRequest request, AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProjectCompartmentDetails(), "changeProjectCompartmentDetails is required");
        return this.clientCall(request, ChangeProjectCompartmentResponse::builder).logger(LOG, "changeProjectCompartment").serviceDetails("Devops", "ChangeProjectCompartment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/ChangeProjectCompartment").method(Method.POST).requestBuilder(ChangeProjectCompartmentRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeProjectCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeProjectCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateBuildPipelineResponse> createBuildPipeline(CreateBuildPipelineRequest request, AsyncHandler<CreateBuildPipelineRequest, CreateBuildPipelineResponse> handler) {
        Objects.requireNonNull(request.getCreateBuildPipelineDetails(), "createBuildPipelineDetails is required");
        return this.clientCall(request, CreateBuildPipelineResponse::builder).logger(LOG, "createBuildPipeline").serviceDetails("Devops", "CreateBuildPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/CreateBuildPipeline").method(Method.POST).requestBuilder(CreateBuildPipelineRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BuildPipeline.class, CreateBuildPipelineResponse.Builder::buildPipeline).handleResponseHeaderString("etag", CreateBuildPipelineResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateBuildPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBuildPipelineResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateBuildPipelineResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateBuildPipelineStageResponse> createBuildPipelineStage(CreateBuildPipelineStageRequest request, AsyncHandler<CreateBuildPipelineStageRequest, CreateBuildPipelineStageResponse> handler) {
        Objects.requireNonNull(request.getCreateBuildPipelineStageDetails(), "createBuildPipelineStageDetails is required");
        return this.clientCall(request, CreateBuildPipelineStageResponse::builder).logger(LOG, "createBuildPipelineStage").serviceDetails("Devops", "CreateBuildPipelineStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/CreateBuildPipelineStage").method(Method.POST).requestBuilder(CreateBuildPipelineStageRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BuildPipelineStage.class, CreateBuildPipelineStageResponse.Builder::buildPipelineStage).handleResponseHeaderString("etag", CreateBuildPipelineStageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateBuildPipelineStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBuildPipelineStageResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateBuildPipelineStageResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateBuildRunResponse> createBuildRun(CreateBuildRunRequest request, AsyncHandler<CreateBuildRunRequest, CreateBuildRunResponse> handler) {
        Objects.requireNonNull(request.getCreateBuildRunDetails(), "createBuildRunDetails is required");
        return this.clientCall(request, CreateBuildRunResponse::builder).logger(LOG, "createBuildRun").serviceDetails("Devops", "CreateBuildRun", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/CreateBuildRun").method(Method.POST).requestBuilder(CreateBuildRunRequest::builder).basePath("/20210630").appendPathParam("buildRuns").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(BuildRun.class, CreateBuildRunResponse.Builder::buildRun).handleResponseHeaderString("etag", CreateBuildRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateBuildRunResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateBuildRunResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateConnectionResponse> createConnection(CreateConnectionRequest request, AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handler) {
        Objects.requireNonNull(request.getCreateConnectionDetails(), "createConnectionDetails is required");
        return this.clientCall(request, CreateConnectionResponse::builder).logger(LOG, "createConnection").serviceDetails("Devops", "CreateConnection", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/CreateConnection").method(Method.POST).requestBuilder(CreateConnectionRequest::builder).basePath("/20210630").appendPathParam("connections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Connection.class, CreateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", CreateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateConnectionResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateDeployArtifactResponse> createDeployArtifact(CreateDeployArtifactRequest request, AsyncHandler<CreateDeployArtifactRequest, CreateDeployArtifactResponse> handler) {
        Objects.requireNonNull(request.getCreateDeployArtifactDetails(), "createDeployArtifactDetails is required");
        return this.clientCall(request, CreateDeployArtifactResponse::builder).logger(LOG, "createDeployArtifact").serviceDetails("Devops", "CreateDeployArtifact", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/CreateDeployArtifact").method(Method.POST).requestBuilder(CreateDeployArtifactRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeployArtifact.class, CreateDeployArtifactResponse.Builder::deployArtifact).handleResponseHeaderString("location", CreateDeployArtifactResponse.Builder::location).handleResponseHeaderString("etag", CreateDeployArtifactResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDeployArtifactResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeployArtifactResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDeployEnvironmentResponse> createDeployEnvironment(CreateDeployEnvironmentRequest request, AsyncHandler<CreateDeployEnvironmentRequest, CreateDeployEnvironmentResponse> handler) {
        Objects.requireNonNull(request.getCreateDeployEnvironmentDetails(), "createDeployEnvironmentDetails is required");
        return this.clientCall(request, CreateDeployEnvironmentResponse::builder).logger(LOG, "createDeployEnvironment").serviceDetails("Devops", "CreateDeployEnvironment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/CreateDeployEnvironment").method(Method.POST).requestBuilder(CreateDeployEnvironmentRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeployEnvironment.class, CreateDeployEnvironmentResponse.Builder::deployEnvironment).handleResponseHeaderString("location", CreateDeployEnvironmentResponse.Builder::location).handleResponseHeaderString("etag", CreateDeployEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDeployEnvironmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeployEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDeployPipelineResponse> createDeployPipeline(CreateDeployPipelineRequest request, AsyncHandler<CreateDeployPipelineRequest, CreateDeployPipelineResponse> handler) {
        Objects.requireNonNull(request.getCreateDeployPipelineDetails(), "createDeployPipelineDetails is required");
        return this.clientCall(request, CreateDeployPipelineResponse::builder).logger(LOG, "createDeployPipeline").serviceDetails("Devops", "CreateDeployPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/CreateDeployPipeline").method(Method.POST).requestBuilder(CreateDeployPipelineRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeployPipeline.class, CreateDeployPipelineResponse.Builder::deployPipeline).handleResponseHeaderString("location", CreateDeployPipelineResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateDeployPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateDeployPipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDeployPipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDeployStageResponse> createDeployStage(CreateDeployStageRequest request, AsyncHandler<CreateDeployStageRequest, CreateDeployStageResponse> handler) {
        Objects.requireNonNull(request.getCreateDeployStageDetails(), "createDeployStageDetails is required");
        return this.clientCall(request, CreateDeployStageResponse::builder).logger(LOG, "createDeployStage").serviceDetails("Devops", "CreateDeployStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/CreateDeployStage").method(Method.POST).requestBuilder(CreateDeployStageRequest::builder).basePath("/20210630").appendPathParam("deployStages").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeployStage.class, CreateDeployStageResponse.Builder::deployStage).handleResponseHeaderString("location", CreateDeployStageResponse.Builder::location).handleResponseHeaderString("etag", CreateDeployStageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDeployStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeployStageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest request, AsyncHandler<CreateDeploymentRequest, CreateDeploymentResponse> handler) {
        Objects.requireNonNull(request.getCreateDeploymentDetails(), "createDeploymentDetails is required");
        return this.clientCall(request, CreateDeploymentResponse::builder).logger(LOG, "createDeployment").serviceDetails("Devops", "CreateDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/CreateDeployment").method(Method.POST).requestBuilder(CreateDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Deployment.class, CreateDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", CreateDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("Devops", "CreateProject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/CreateProject").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20210630").appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("location", CreateProjectResponse.Builder::location).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRepositoryResponse> createRepository(CreateRepositoryRequest request, AsyncHandler<CreateRepositoryRequest, CreateRepositoryResponse> handler) {
        Objects.requireNonNull(request.getCreateRepositoryDetails(), "createRepositoryDetails is required");
        return this.clientCall(request, CreateRepositoryResponse::builder).logger(LOG, "createRepository").serviceDetails("Devops", "CreateRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/CreateRepository").method(Method.POST).requestBuilder(CreateRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Repository.class, CreateRepositoryResponse.Builder::repository).handleResponseHeaderString("location", CreateRepositoryResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateRepositoryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRepositoryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateRepositoryResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateTriggerResponse> createTrigger(CreateTriggerRequest request, AsyncHandler<CreateTriggerRequest, CreateTriggerResponse> handler) {
        Objects.requireNonNull(request.getCreateTriggerDetails(), "createTriggerDetails is required");
        return this.clientCall(request, CreateTriggerResponse::builder).logger(LOG, "createTrigger").serviceDetails("Devops", "CreateTrigger", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/CreateTrigger").method(Method.POST).requestBuilder(CreateTriggerRequest::builder).basePath("/20210630").appendPathParam("triggers").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TriggerCreateResult.class, CreateTriggerResponse.Builder::triggerCreateResult).handleResponseHeaderString("etag", CreateTriggerResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateTriggerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateTriggerResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateTriggerResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<DeleteBuildPipelineResponse> deleteBuildPipeline(DeleteBuildPipelineRequest request, AsyncHandler<DeleteBuildPipelineRequest, DeleteBuildPipelineResponse> handler) {
        Validate.notBlank((String)request.getBuildPipelineId(), (String)"buildPipelineId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteBuildPipelineResponse::builder).logger(LOG, "deleteBuildPipeline").serviceDetails("Devops", "DeleteBuildPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/DeleteBuildPipeline").method(Method.DELETE).requestBuilder(DeleteBuildPipelineRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").appendPathParam(request.getBuildPipelineId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteBuildPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBuildPipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteBuildPipelineStageResponse> deleteBuildPipelineStage(DeleteBuildPipelineStageRequest request, AsyncHandler<DeleteBuildPipelineStageRequest, DeleteBuildPipelineStageResponse> handler) {
        Validate.notBlank((String)request.getBuildPipelineStageId(), (String)"buildPipelineStageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteBuildPipelineStageResponse::builder).logger(LOG, "deleteBuildPipelineStage").serviceDetails("Devops", "DeleteBuildPipelineStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/DeleteBuildPipelineStage").method(Method.DELETE).requestBuilder(DeleteBuildPipelineStageRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").appendPathParam(request.getBuildPipelineStageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteBuildPipelineStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBuildPipelineStageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest request, AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConnectionResponse::builder).logger(LOG, "deleteConnection").serviceDetails("Devops", "DeleteConnection", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/DeleteConnection").method(Method.DELETE).requestBuilder(DeleteConnectionRequest::builder).basePath("/20210630").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDeployArtifactResponse> deleteDeployArtifact(DeleteDeployArtifactRequest request, AsyncHandler<DeleteDeployArtifactRequest, DeleteDeployArtifactResponse> handler) {
        Validate.notBlank((String)request.getDeployArtifactId(), (String)"deployArtifactId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDeployArtifactResponse::builder).logger(LOG, "deleteDeployArtifact").serviceDetails("Devops", "DeleteDeployArtifact", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/DeleteDeployArtifact").method(Method.DELETE).requestBuilder(DeleteDeployArtifactRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").appendPathParam(request.getDeployArtifactId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDeployArtifactResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeployArtifactResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDeployEnvironmentResponse> deleteDeployEnvironment(DeleteDeployEnvironmentRequest request, AsyncHandler<DeleteDeployEnvironmentRequest, DeleteDeployEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getDeployEnvironmentId(), (String)"deployEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDeployEnvironmentResponse::builder).logger(LOG, "deleteDeployEnvironment").serviceDetails("Devops", "DeleteDeployEnvironment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/DeleteDeployEnvironment").method(Method.DELETE).requestBuilder(DeleteDeployEnvironmentRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").appendPathParam(request.getDeployEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDeployEnvironmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeployEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDeployPipelineResponse> deleteDeployPipeline(DeleteDeployPipelineRequest request, AsyncHandler<DeleteDeployPipelineRequest, DeleteDeployPipelineResponse> handler) {
        Validate.notBlank((String)request.getDeployPipelineId(), (String)"deployPipelineId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDeployPipelineResponse::builder).logger(LOG, "deleteDeployPipeline").serviceDetails("Devops", "DeleteDeployPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/DeleteDeployPipeline").method(Method.DELETE).requestBuilder(DeleteDeployPipelineRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").appendPathParam(request.getDeployPipelineId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDeployPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeployPipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDeployStageResponse> deleteDeployStage(DeleteDeployStageRequest request, AsyncHandler<DeleteDeployStageRequest, DeleteDeployStageResponse> handler) {
        Validate.notBlank((String)request.getDeployStageId(), (String)"deployStageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDeployStageResponse::builder).logger(LOG, "deleteDeployStage").serviceDetails("Devops", "DeleteDeployStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/DeleteDeployStage").method(Method.DELETE).requestBuilder(DeleteDeployStageRequest::builder).basePath("/20210630").appendPathParam("deployStages").appendPathParam(request.getDeployStageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDeployStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeployStageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("Devops", "DeleteProject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/DeleteProject").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRefResponse> deleteRef(DeleteRefRequest request, AsyncHandler<DeleteRefRequest, DeleteRefResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRefName(), (String)"refName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRefResponse::builder).logger(LOG, "deleteRef").serviceDetails("Devops", "DeleteRef", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/DeleteRef").method(Method.DELETE).requestBuilder(DeleteRefRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("refs").appendPathParam(request.getRefName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteRefResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRefResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest request, AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRepositoryResponse::builder).logger(LOG, "deleteRepository").serviceDetails("Devops", "DeleteRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/DeleteRepository").method(Method.DELETE).requestBuilder(DeleteRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteRepositoryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTriggerResponse> deleteTrigger(DeleteTriggerRequest request, AsyncHandler<DeleteTriggerRequest, DeleteTriggerResponse> handler) {
        Validate.notBlank((String)request.getTriggerId(), (String)"triggerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTriggerResponse::builder).logger(LOG, "deleteTrigger").serviceDetails("Devops", "DeleteTrigger", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/DeleteTrigger").method(Method.DELETE).requestBuilder(DeleteTriggerRequest::builder).basePath("/20210630").appendPathParam("triggers").appendPathParam(request.getTriggerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteTriggerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteTriggerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBuildPipelineResponse> getBuildPipeline(GetBuildPipelineRequest request, AsyncHandler<GetBuildPipelineRequest, GetBuildPipelineResponse> handler) {
        Validate.notBlank((String)request.getBuildPipelineId(), (String)"buildPipelineId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBuildPipelineResponse::builder).logger(LOG, "getBuildPipeline").serviceDetails("Devops", "GetBuildPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/GetBuildPipeline").method(Method.GET).requestBuilder(GetBuildPipelineRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").appendPathParam(request.getBuildPipelineId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BuildPipeline.class, GetBuildPipelineResponse.Builder::buildPipeline).handleResponseHeaderString("etag", GetBuildPipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBuildPipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBuildPipelineStageResponse> getBuildPipelineStage(GetBuildPipelineStageRequest request, AsyncHandler<GetBuildPipelineStageRequest, GetBuildPipelineStageResponse> handler) {
        Validate.notBlank((String)request.getBuildPipelineStageId(), (String)"buildPipelineStageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBuildPipelineStageResponse::builder).logger(LOG, "getBuildPipelineStage").serviceDetails("Devops", "GetBuildPipelineStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/GetBuildPipelineStage").method(Method.GET).requestBuilder(GetBuildPipelineStageRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").appendPathParam(request.getBuildPipelineStageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BuildPipelineStage.class, GetBuildPipelineStageResponse.Builder::buildPipelineStage).handleResponseHeaderString("etag", GetBuildPipelineStageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBuildPipelineStageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBuildRunResponse> getBuildRun(GetBuildRunRequest request, AsyncHandler<GetBuildRunRequest, GetBuildRunResponse> handler) {
        Validate.notBlank((String)request.getBuildRunId(), (String)"buildRunId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBuildRunResponse::builder).logger(LOG, "getBuildRun").serviceDetails("Devops", "GetBuildRun", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/GetBuildRun").method(Method.GET).requestBuilder(GetBuildRunRequest::builder).basePath("/20210630").appendPathParam("buildRuns").appendPathParam(request.getBuildRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BuildRun.class, GetBuildRunResponse.Builder::buildRun).handleResponseHeaderString("etag", GetBuildRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBuildRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCommitResponse> getCommit(GetCommitRequest request, AsyncHandler<GetCommitRequest, GetCommitResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCommitId(), (String)"commitId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCommitResponse::builder).logger(LOG, "getCommit").serviceDetails("Devops", "GetCommit", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetCommit").method(Method.GET).requestBuilder(GetCommitRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("commits").appendPathParam(request.getCommitId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryCommit.class, GetCommitResponse.Builder::repositoryCommit).handleResponseHeaderString("etag", GetCommitResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCommitResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCommitDiffResponse> getCommitDiff(GetCommitDiffRequest request, AsyncHandler<GetCommitDiffRequest, GetCommitDiffResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTargetVersion(), "targetVersion is required");
        return this.clientCall(request, GetCommitDiffResponse::builder).logger(LOG, "getCommitDiff").serviceDetails("Devops", "GetCommitDiff", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetCommitDiff").method(Method.GET).requestBuilder(GetCommitDiffRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("diff").appendQueryParam("baseVersion", (Object)request.getBaseVersion()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("isComparisonFromMergeBase", (Object)request.getIsComparisonFromMergeBase()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DiffResponse.class, GetCommitDiffResponse.Builder::diffResponse).handleResponseHeaderString("etag", GetCommitDiffResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCommitDiffResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConnectionResponse> getConnection(GetConnectionRequest request, AsyncHandler<GetConnectionRequest, GetConnectionResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectionResponse::builder).logger(LOG, "getConnection").serviceDetails("Devops", "GetConnection", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/GetConnection").method(Method.GET).requestBuilder(GetConnectionRequest::builder).basePath("/20210630").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Connection.class, GetConnectionResponse.Builder::connection).handleResponseHeaderString("etag", GetConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDeployArtifactResponse> getDeployArtifact(GetDeployArtifactRequest request, AsyncHandler<GetDeployArtifactRequest, GetDeployArtifactResponse> handler) {
        Validate.notBlank((String)request.getDeployArtifactId(), (String)"deployArtifactId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDeployArtifactResponse::builder).logger(LOG, "getDeployArtifact").serviceDetails("Devops", "GetDeployArtifact", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/GetDeployArtifact").method(Method.GET).requestBuilder(GetDeployArtifactRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").appendPathParam(request.getDeployArtifactId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeployArtifact.class, GetDeployArtifactResponse.Builder::deployArtifact).handleResponseHeaderString("etag", GetDeployArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeployArtifactResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDeployEnvironmentResponse> getDeployEnvironment(GetDeployEnvironmentRequest request, AsyncHandler<GetDeployEnvironmentRequest, GetDeployEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getDeployEnvironmentId(), (String)"deployEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDeployEnvironmentResponse::builder).logger(LOG, "getDeployEnvironment").serviceDetails("Devops", "GetDeployEnvironment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/GetDeployEnvironment").method(Method.GET).requestBuilder(GetDeployEnvironmentRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").appendPathParam(request.getDeployEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeployEnvironment.class, GetDeployEnvironmentResponse.Builder::deployEnvironment).handleResponseHeaderString("etag", GetDeployEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeployEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDeployPipelineResponse> getDeployPipeline(GetDeployPipelineRequest request, AsyncHandler<GetDeployPipelineRequest, GetDeployPipelineResponse> handler) {
        Validate.notBlank((String)request.getDeployPipelineId(), (String)"deployPipelineId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDeployPipelineResponse::builder).logger(LOG, "getDeployPipeline").serviceDetails("Devops", "GetDeployPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/GetDeployPipeline").method(Method.GET).requestBuilder(GetDeployPipelineRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").appendPathParam(request.getDeployPipelineId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeployPipeline.class, GetDeployPipelineResponse.Builder::deployPipeline).handleResponseHeaderString("etag", GetDeployPipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeployPipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDeployStageResponse> getDeployStage(GetDeployStageRequest request, AsyncHandler<GetDeployStageRequest, GetDeployStageResponse> handler) {
        Validate.notBlank((String)request.getDeployStageId(), (String)"deployStageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDeployStageResponse::builder).logger(LOG, "getDeployStage").serviceDetails("Devops", "GetDeployStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/GetDeployStage").method(Method.GET).requestBuilder(GetDeployStageRequest::builder).basePath("/20210630").appendPathParam("deployStages").appendPathParam(request.getDeployStageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeployStage.class, GetDeployStageResponse.Builder::deployStage).handleResponseHeaderString("etag", GetDeployStageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeployStageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDeploymentResponse> getDeployment(GetDeploymentRequest request, AsyncHandler<GetDeploymentRequest, GetDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDeploymentResponse::builder).logger(LOG, "getDeployment").serviceDetails("Devops", "GetDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/GetDeployment").method(Method.GET).requestBuilder(GetDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Deployment.class, GetDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", GetDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFileDiffResponse> getFileDiff(GetFileDiffRequest request, AsyncHandler<GetFileDiffRequest, GetFileDiffResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFilePath(), (String)"filePath must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBaseVersion(), "baseVersion is required");
        Objects.requireNonNull(request.getTargetVersion(), "targetVersion is required");
        return this.clientCall(request, GetFileDiffResponse::builder).logger(LOG, "getFileDiff").serviceDetails("Devops", "GetFileDiff", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetFileDiff").method(Method.GET).requestBuilder(GetFileDiffRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("diffs").appendPathParam(request.getFilePath()).appendQueryParam("baseVersion", (Object)request.getBaseVersion()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("isComparisonFromMergeBase", (Object)request.getIsComparisonFromMergeBase()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FileDiffResponse.class, GetFileDiffResponse.Builder::fileDiffResponse).handleResponseHeaderString("etag", GetFileDiffResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFileDiffResponse.Builder::opcRequestId).handleResponseHeaderString("Sunset", GetFileDiffResponse.Builder::sunset).callAsync(handler);
    }

    @Override
    public Future<GetMirrorRecordResponse> getMirrorRecord(GetMirrorRecordRequest request, AsyncHandler<GetMirrorRecordRequest, GetMirrorRecordResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMirrorRecordType().getValue(), (String)"mirrorRecordType must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMirrorRecordResponse::builder).logger(LOG, "getMirrorRecord").serviceDetails("Devops", "GetMirrorRecord", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetMirrorRecord").method(Method.GET).requestBuilder(GetMirrorRecordRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("mirrorRecords").appendPathParam(request.getMirrorRecordType().getValue()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryMirrorRecord.class, GetMirrorRecordResponse.Builder::repositoryMirrorRecord).handleResponseHeaderString("etag", GetMirrorRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMirrorRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetObjectResponse> getObject(GetObjectRequest request, AsyncHandler<GetObjectRequest, GetObjectResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetObjectResponse::builder).logger(LOG, "getObject").serviceDetails("Devops", "GetObject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryObject/GetObject").method(Method.GET).requestBuilder(GetObjectRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("object").appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("refName", (Object)request.getRefName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryObject.class, GetObjectResponse.Builder::repositoryObject).handleResponseHeaderString("opc-request-id", GetObjectResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetObjectResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetObjectContentResponse> getObjectContent(GetObjectContentRequest request, AsyncHandler<GetObjectContentRequest, GetObjectContentResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSha(), (String)"sha must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetObjectContentResponse::builder).logger(LOG, "getObjectContent").serviceDetails("Devops", "GetObjectContent", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetObjectContent").method(Method.GET).requestBuilder(GetObjectContentRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("objects").appendPathParam(request.getSha()).appendPathParam("content").appendQueryParam("filePath", (Object)request.getFilePath()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetObjectContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetObjectContentResponse.Builder::opcRequestId).handleResponseHeaderString("Content-Type", GetObjectContentResponse.Builder::contentType).handleResponseHeaderString("Content-Disposition", GetObjectContentResponse.Builder::contentDisposition).callAsync(handler);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("Devops", "GetProject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/GetProject").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRefResponse> getRef(GetRefRequest request, AsyncHandler<GetRefRequest, GetRefResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRefName(), (String)"refName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRefResponse::builder).logger(LOG, "getRef").serviceDetails("Devops", "GetRef", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRef").method(Method.GET).requestBuilder(GetRefRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("refs").appendPathParam(request.getRefName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryRef.class, GetRefResponse.Builder::repositoryRef).handleResponseHeaderString("etag", GetRefResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRefResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRepoFileDiffResponse> getRepoFileDiff(GetRepoFileDiffRequest request, AsyncHandler<GetRepoFileDiffRequest, GetRepoFileDiffResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBaseVersion(), "baseVersion is required");
        Objects.requireNonNull(request.getTargetVersion(), "targetVersion is required");
        return this.clientCall(request, GetRepoFileDiffResponse::builder).logger(LOG, "getRepoFileDiff").serviceDetails("Devops", "GetRepoFileDiff", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepoFileDiff").method(Method.GET).requestBuilder(GetRepoFileDiffRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("file").appendPathParam("diffs").appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("baseVersion", (Object)request.getBaseVersion()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("isComparisonFromMergeBase", (Object)request.getIsComparisonFromMergeBase()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FileDiffResponse.class, GetRepoFileDiffResponse.Builder::fileDiffResponse).handleResponseHeaderString("etag", GetRepoFileDiffResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRepoFileDiffResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRepoFileLinesResponse> getRepoFileLines(GetRepoFileLinesRequest request, AsyncHandler<GetRepoFileLinesRequest, GetRepoFileLinesResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRevision(), "revision is required");
        return this.clientCall(request, GetRepoFileLinesResponse::builder).logger(LOG, "getRepoFileLines").serviceDetails("Devops", "GetRepoFileLines", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepoFileLines").method(Method.GET).requestBuilder(GetRepoFileLinesRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("file").appendPathParam("lines").appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("revision", (Object)request.getRevision()).appendQueryParam("startLineNumber", (Object)request.getStartLineNumber()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryFileLines.class, GetRepoFileLinesResponse.Builder::repositoryFileLines).handleResponseHeaderString("opc-request-id", GetRepoFileLinesResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRepoFileLinesResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetRepositoryResponse> getRepository(GetRepositoryRequest request, AsyncHandler<GetRepositoryRequest, GetRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRepositoryResponse::builder).logger(LOG, "getRepository").serviceDetails("Devops", "GetRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepository").method(Method.GET).requestBuilder(GetRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Repository.class, GetRepositoryResponse.Builder::repository).handleResponseHeaderString("etag", GetRepositoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRepositoryArchiveContentResponse> getRepositoryArchiveContent(GetRepositoryArchiveContentRequest request, AsyncHandler<GetRepositoryArchiveContentRequest, GetRepositoryArchiveContentResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRepositoryArchiveContentResponse::builder).logger(LOG, "getRepositoryArchiveContent").serviceDetails("Devops", "GetRepositoryArchiveContent", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepositoryArchiveContent").method(Method.GET).requestBuilder(GetRepositoryArchiveContentRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("archive").appendPathParam("content").appendQueryParam("refName", (Object)request.getRefName()).appendQueryParam("format", (Object)request.getFormat()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetRepositoryArchiveContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetRepositoryArchiveContentResponse.Builder::opcRequestId).handleResponseHeaderString("Content-Type", GetRepositoryArchiveContentResponse.Builder::contentType).handleResponseHeaderString("Content-Disposition", GetRepositoryArchiveContentResponse.Builder::contentDisposition).callAsync(handler);
    }

    @Override
    public Future<GetRepositoryFileLinesResponse> getRepositoryFileLines(GetRepositoryFileLinesRequest request, AsyncHandler<GetRepositoryFileLinesRequest, GetRepositoryFileLinesResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFilePath(), (String)"filePath must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRevision(), "revision is required");
        return this.clientCall(request, GetRepositoryFileLinesResponse::builder).logger(LOG, "getRepositoryFileLines").serviceDetails("Devops", "GetRepositoryFileLines", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepositoryFileLines").method(Method.GET).requestBuilder(GetRepositoryFileLinesRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("files").appendPathParam(request.getFilePath()).appendPathParam("lines").appendQueryParam("revision", (Object)request.getRevision()).appendQueryParam("startLineNumber", (Object)request.getStartLineNumber()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryFileLines.class, GetRepositoryFileLinesResponse.Builder::repositoryFileLines).handleResponseHeaderString("opc-request-id", GetRepositoryFileLinesResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRepositoryFileLinesResponse.Builder::etag).handleResponseHeaderString("Sunset", GetRepositoryFileLinesResponse.Builder::sunset).callAsync(handler);
    }

    @Override
    public Future<GetTriggerResponse> getTrigger(GetTriggerRequest request, AsyncHandler<GetTriggerRequest, GetTriggerResponse> handler) {
        Validate.notBlank((String)request.getTriggerId(), (String)"triggerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTriggerResponse::builder).logger(LOG, "getTrigger").serviceDetails("Devops", "GetTrigger", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/GetTrigger").method(Method.GET).requestBuilder(GetTriggerRequest::builder).basePath("/20210630").appendPathParam("triggers").appendPathParam(request.getTriggerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Trigger.class, GetTriggerResponse.Builder::trigger).handleResponseHeaderString("etag", GetTriggerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTriggerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Devops", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListAuthorsResponse> listAuthors(ListAuthorsRequest request, AsyncHandler<ListAuthorsRequest, ListAuthorsResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAuthorsResponse::builder).logger(LOG, "listAuthors").serviceDetails("Devops", "ListAuthors", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListAuthors").method(Method.GET).requestBuilder(ListAuthorsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("authors").appendQueryParam("refName", (Object)request.getRefName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryAuthorCollection.class, ListAuthorsResponse.Builder::repositoryAuthorCollection).handleResponseHeaderString("opc-request-id", ListAuthorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAuthorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListBuildPipelineStagesResponse> listBuildPipelineStages(ListBuildPipelineStagesRequest request, AsyncHandler<ListBuildPipelineStagesRequest, ListBuildPipelineStagesResponse> handler) {
        return this.clientCall(request, ListBuildPipelineStagesResponse::builder).logger(LOG, "listBuildPipelineStages").serviceDetails("Devops", "ListBuildPipelineStages", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStageSummary/ListBuildPipelineStages").method(Method.GET).requestBuilder(ListBuildPipelineStagesRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").appendQueryParam("id", (Object)request.getId()).appendQueryParam("buildPipelineId", (Object)request.getBuildPipelineId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BuildPipelineStageCollection.class, ListBuildPipelineStagesResponse.Builder::buildPipelineStageCollection).handleResponseHeaderString("opc-request-id", ListBuildPipelineStagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBuildPipelineStagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListBuildPipelinesResponse> listBuildPipelines(ListBuildPipelinesRequest request, AsyncHandler<ListBuildPipelinesRequest, ListBuildPipelinesResponse> handler) {
        return this.clientCall(request, ListBuildPipelinesResponse::builder).logger(LOG, "listBuildPipelines").serviceDetails("Devops", "ListBuildPipelines", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineCollection/ListBuildPipelines").method(Method.GET).requestBuilder(ListBuildPipelinesRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BuildPipelineCollection.class, ListBuildPipelinesResponse.Builder::buildPipelineCollection).handleResponseHeaderString("opc-request-id", ListBuildPipelinesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBuildPipelinesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListBuildRunsResponse> listBuildRuns(ListBuildRunsRequest request, AsyncHandler<ListBuildRunsRequest, ListBuildRunsResponse> handler) {
        return this.clientCall(request, ListBuildRunsResponse::builder).logger(LOG, "listBuildRuns").serviceDetails("Devops", "ListBuildRuns", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRunSummary/ListBuildRuns").method(Method.GET).requestBuilder(ListBuildRunsRequest::builder).basePath("/20210630").appendPathParam("buildRuns").appendQueryParam("id", (Object)request.getId()).appendQueryParam("buildPipelineId", (Object)request.getBuildPipelineId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BuildRunSummaryCollection.class, ListBuildRunsResponse.Builder::buildRunSummaryCollection).handleResponseHeaderString("opc-request-id", ListBuildRunsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBuildRunsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCommitDiffsResponse> listCommitDiffs(ListCommitDiffsRequest request, AsyncHandler<ListCommitDiffsRequest, ListCommitDiffsResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBaseVersion(), "baseVersion is required");
        Objects.requireNonNull(request.getTargetVersion(), "targetVersion is required");
        return this.clientCall(request, ListCommitDiffsResponse::builder).logger(LOG, "listCommitDiffs").serviceDetails("Devops", "ListCommitDiffs", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListCommitDiffs").method(Method.GET).requestBuilder(ListCommitDiffsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("diffs").appendQueryParam("baseVersion", (Object)request.getBaseVersion()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("isComparisonFromMergeBase", (Object)request.getIsComparisonFromMergeBase()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DiffCollection.class, ListCommitDiffsResponse.Builder::diffCollection).handleResponseHeaderString("opc-request-id", ListCommitDiffsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCommitDiffsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCommitsResponse> listCommits(ListCommitsRequest request, AsyncHandler<ListCommitsRequest, ListCommitsResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListCommitsResponse::builder).logger(LOG, "listCommits").serviceDetails("Devops", "ListCommits", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryCommit/ListCommits").method(Method.GET).requestBuilder(ListCommitsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("commits").appendQueryParam("refName", (Object)request.getRefName()).appendQueryParam("excludeRefName", (Object)request.getExcludeRefName()).appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("timestampGreaterThanOrEqualTo", (Object)request.getTimestampGreaterThanOrEqualTo()).appendQueryParam("timestampLessThanOrEqualTo", (Object)request.getTimestampLessThanOrEqualTo()).appendQueryParam("commitMessage", (Object)request.getCommitMessage()).appendQueryParam("authorName", (Object)request.getAuthorName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryCommitCollection.class, ListCommitsResponse.Builder::repositoryCommitCollection).handleResponseHeaderString("opc-request-id", ListCommitsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCommitsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListConnectionsResponse> listConnections(ListConnectionsRequest request, AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handler) {
        return this.clientCall(request, ListConnectionsResponse::builder).logger(LOG, "listConnections").serviceDetails("Devops", "ListConnections", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ConnectionCollection/ListConnections").method(Method.GET).requestBuilder(ListConnectionsRequest::builder).basePath("/20210630").appendPathParam("connections").appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("connectionType", (BmcEnum)request.getConnectionType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionCollection.class, ListConnectionsResponse.Builder::connectionCollection).handleResponseHeaderString("opc-request-id", ListConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeployArtifactsResponse> listDeployArtifacts(ListDeployArtifactsRequest request, AsyncHandler<ListDeployArtifactsRequest, ListDeployArtifactsResponse> handler) {
        return this.clientCall(request, ListDeployArtifactsResponse::builder).logger(LOG, "listDeployArtifacts").serviceDetails("Devops", "ListDeployArtifacts", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifactSummary/ListDeployArtifacts").method(Method.GET).requestBuilder(ListDeployArtifactsRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeployArtifactCollection.class, ListDeployArtifactsResponse.Builder::deployArtifactCollection).handleResponseHeaderString("opc-request-id", ListDeployArtifactsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeployArtifactsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeployEnvironmentsResponse> listDeployEnvironments(ListDeployEnvironmentsRequest request, AsyncHandler<ListDeployEnvironmentsRequest, ListDeployEnvironmentsResponse> handler) {
        return this.clientCall(request, ListDeployEnvironmentsResponse::builder).logger(LOG, "listDeployEnvironments").serviceDetails("Devops", "ListDeployEnvironments", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironmentSummary/ListDeployEnvironments").method(Method.GET).requestBuilder(ListDeployEnvironmentsRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeployEnvironmentCollection.class, ListDeployEnvironmentsResponse.Builder::deployEnvironmentCollection).handleResponseHeaderString("opc-request-id", ListDeployEnvironmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeployEnvironmentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeployPipelinesResponse> listDeployPipelines(ListDeployPipelinesRequest request, AsyncHandler<ListDeployPipelinesRequest, ListDeployPipelinesResponse> handler) {
        return this.clientCall(request, ListDeployPipelinesResponse::builder).logger(LOG, "listDeployPipelines").serviceDetails("Devops", "ListDeployPipelines", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipelineSummary/ListDeployPipelines").method(Method.GET).requestBuilder(ListDeployPipelinesRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeployPipelineCollection.class, ListDeployPipelinesResponse.Builder::deployPipelineCollection).handleResponseHeaderString("opc-request-id", ListDeployPipelinesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeployPipelinesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeployStagesResponse> listDeployStages(ListDeployStagesRequest request, AsyncHandler<ListDeployStagesRequest, ListDeployStagesResponse> handler) {
        return this.clientCall(request, ListDeployStagesResponse::builder).logger(LOG, "listDeployStages").serviceDetails("Devops", "ListDeployStages", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStageSummary/ListDeployStages").method(Method.GET).requestBuilder(ListDeployStagesRequest::builder).basePath("/20210630").appendPathParam("deployStages").appendQueryParam("id", (Object)request.getId()).appendQueryParam("deployPipelineId", (Object)request.getDeployPipelineId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeployStageCollection.class, ListDeployStagesResponse.Builder::deployStageCollection).handleResponseHeaderString("opc-request-id", ListDeployStagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeployStagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest request, AsyncHandler<ListDeploymentsRequest, ListDeploymentsResponse> handler) {
        return this.clientCall(request, ListDeploymentsResponse::builder).logger(LOG, "listDeployments").serviceDetails("Devops", "ListDeployments", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeploymentSummary/ListDeployments").method(Method.GET).requestBuilder(ListDeploymentsRequest::builder).basePath("/20210630").appendPathParam("deployments").appendQueryParam("deployPipelineId", (Object)request.getDeployPipelineId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeploymentCollection.class, ListDeploymentsResponse.Builder::deploymentCollection).handleResponseHeaderString("opc-request-id", ListDeploymentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMirrorRecordsResponse> listMirrorRecords(ListMirrorRecordsRequest request, AsyncHandler<ListMirrorRecordsRequest, ListMirrorRecordsResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListMirrorRecordsResponse::builder).logger(LOG, "listMirrorRecords").serviceDetails("Devops", "ListMirrorRecords", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListMirrorRecords").method(Method.GET).requestBuilder(ListMirrorRecordsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("mirrorRecords").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryMirrorRecordCollection.class, ListMirrorRecordsResponse.Builder::repositoryMirrorRecordCollection).handleResponseHeaderString("opc-request-id", ListMirrorRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMirrorRecordsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPathsResponse> listPaths(ListPathsRequest request, AsyncHandler<ListPathsRequest, ListPathsResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPathsResponse::builder).logger(LOG, "listPaths").serviceDetails("Devops", "ListPaths", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryPathSummary/ListPaths").method(Method.GET).requestBuilder(ListPathsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("paths").appendQueryParam("ref", (Object)request.getRef()).appendQueryParam("pathsInSubtree", (Object)request.getPathsInSubtree()).appendQueryParam("folderPath", (Object)request.getFolderPath()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryPathCollection.class, ListPathsResponse.Builder::repositoryPathCollection).handleResponseHeaderString("opc-request-id", ListPathsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPathsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("Devops", "ListProjects", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProjectSummary/ListProjects").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20210630").appendPathParam("projects").appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProjectCollection.class, ListProjectsResponse.Builder::projectCollection).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRefsResponse> listRefs(ListRefsRequest request, AsyncHandler<ListRefsRequest, ListRefsResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRefsResponse::builder).logger(LOG, "listRefs").serviceDetails("Devops", "ListRefs", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryRef/ListRefs").method(Method.GET).requestBuilder(ListRefsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("refs").appendEnumQueryParam("refType", (BmcEnum)request.getRefType()).appendQueryParam("commitId", (Object)request.getCommitId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("refName", (Object)request.getRefName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryRefCollection.class, ListRefsResponse.Builder::repositoryRefCollection).handleResponseHeaderString("opc-request-id", ListRefsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRefsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRepositoriesResponse> listRepositories(ListRepositoriesRequest request, AsyncHandler<ListRepositoriesRequest, ListRepositoriesResponse> handler) {
        return this.clientCall(request, ListRepositoriesResponse::builder).logger(LOG, "listRepositories").serviceDetails("Devops", "ListRepositories", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListRepositories").method(Method.GET).requestBuilder(ListRepositoriesRequest::builder).basePath("/20210630").appendPathParam("repositories").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("repositoryId", (Object)request.getRepositoryId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryCollection.class, ListRepositoriesResponse.Builder::repositoryCollection).handleResponseHeaderString("opc-request-id", ListRepositoriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRepositoriesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTriggersResponse> listTriggers(ListTriggersRequest request, AsyncHandler<ListTriggersRequest, ListTriggersResponse> handler) {
        return this.clientCall(request, ListTriggersResponse::builder).logger(LOG, "listTriggers").serviceDetails("Devops", "ListTriggers", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/TriggerCollection/ListTriggers").method(Method.GET).requestBuilder(ListTriggersRequest::builder).basePath("/20210630").appendPathParam("triggers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TriggerCollection.class, ListTriggersResponse.Builder::triggerCollection).handleResponseHeaderString("opc-request-id", ListTriggersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTriggersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Devops", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Devops", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Devops", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210630").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("operationTypeMultiValueQuery", request.getOperationTypeMultiValueQuery(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<MirrorRepositoryResponse> mirrorRepository(MirrorRepositoryRequest request, AsyncHandler<MirrorRepositoryRequest, MirrorRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, MirrorRepositoryResponse::builder).logger(LOG, "mirrorRepository").serviceDetails("Devops", "MirrorRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/MirrorRepository").method(Method.POST).requestBuilder(MirrorRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("actions").appendPathParam("mirror").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", MirrorRepositoryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", MirrorRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<PutRepositoryRefResponse> putRepositoryRef(PutRepositoryRefRequest request, AsyncHandler<PutRepositoryRefRequest, PutRepositoryRefResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRefName(), (String)"refName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPutRepositoryRefDetails(), "putRepositoryRefDetails is required");
        return this.clientCall(request, PutRepositoryRefResponse::builder).logger(LOG, "putRepositoryRef").serviceDetails("Devops", "PutRepositoryRef", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/PutRepositoryRef").method(Method.PUT).requestBuilder(PutRepositoryRefRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("refs").appendPathParam(request.getRefName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RepositoryRef.class, PutRepositoryRefResponse.Builder::repositoryRef).handleResponseHeaderString("location", PutRepositoryRefResponse.Builder::location).handleResponseHeaderString("etag", PutRepositoryRefResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", PutRepositoryRefResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PutRepositoryRefResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScheduleCascadingProjectDeletionResponse> scheduleCascadingProjectDeletion(ScheduleCascadingProjectDeletionRequest request, AsyncHandler<ScheduleCascadingProjectDeletionRequest, ScheduleCascadingProjectDeletionResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ScheduleCascadingProjectDeletionResponse::builder).logger(LOG, "scheduleCascadingProjectDeletion").serviceDetails("Devops", "ScheduleCascadingProjectDeletion", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/ScheduleCascadingProjectDeletion").method(Method.POST).requestBuilder(ScheduleCascadingProjectDeletionRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("scheduleCascadingProjectDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", ScheduleCascadingProjectDeletionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ScheduleCascadingProjectDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateBuildPipelineResponse> updateBuildPipeline(UpdateBuildPipelineRequest request, AsyncHandler<UpdateBuildPipelineRequest, UpdateBuildPipelineResponse> handler) {
        Validate.notBlank((String)request.getBuildPipelineId(), (String)"buildPipelineId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBuildPipelineDetails(), "updateBuildPipelineDetails is required");
        return this.clientCall(request, UpdateBuildPipelineResponse::builder).logger(LOG, "updateBuildPipeline").serviceDetails("Devops", "UpdateBuildPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/UpdateBuildPipeline").method(Method.PUT).requestBuilder(UpdateBuildPipelineRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").appendPathParam(request.getBuildPipelineId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BuildPipeline.class, UpdateBuildPipelineResponse.Builder::buildPipeline).handleResponseHeaderString("etag", UpdateBuildPipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateBuildPipelineResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateBuildPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", UpdateBuildPipelineResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<UpdateBuildPipelineStageResponse> updateBuildPipelineStage(UpdateBuildPipelineStageRequest request, AsyncHandler<UpdateBuildPipelineStageRequest, UpdateBuildPipelineStageResponse> handler) {
        Validate.notBlank((String)request.getBuildPipelineStageId(), (String)"buildPipelineStageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBuildPipelineStageDetails(), "updateBuildPipelineStageDetails is required");
        return this.clientCall(request, UpdateBuildPipelineStageResponse::builder).logger(LOG, "updateBuildPipelineStage").serviceDetails("Devops", "UpdateBuildPipelineStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/UpdateBuildPipelineStage").method(Method.PUT).requestBuilder(UpdateBuildPipelineStageRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").appendPathParam(request.getBuildPipelineStageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BuildPipelineStage.class, UpdateBuildPipelineStageResponse.Builder::buildPipelineStage).handleResponseHeaderString("etag", UpdateBuildPipelineStageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateBuildPipelineStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBuildPipelineStageResponse.Builder::opcRequestId).handleResponseHeaderString("location", UpdateBuildPipelineStageResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<UpdateBuildRunResponse> updateBuildRun(UpdateBuildRunRequest request, AsyncHandler<UpdateBuildRunRequest, UpdateBuildRunResponse> handler) {
        Validate.notBlank((String)request.getBuildRunId(), (String)"buildRunId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBuildRunDetails(), "updateBuildRunDetails is required");
        return this.clientCall(request, UpdateBuildRunResponse::builder).logger(LOG, "updateBuildRun").serviceDetails("Devops", "UpdateBuildRun", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/UpdateBuildRun").method(Method.PUT).requestBuilder(UpdateBuildRunRequest::builder).basePath("/20210630").appendPathParam("buildRuns").appendPathParam(request.getBuildRunId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BuildRun.class, UpdateBuildRunResponse.Builder::buildRun).handleResponseHeaderString("etag", UpdateBuildRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateBuildRunResponse.Builder::opcRequestId).handleResponseHeaderString("location", UpdateBuildRunResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest request, AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectionDetails(), "updateConnectionDetails is required");
        return this.clientCall(request, UpdateConnectionResponse::builder).logger(LOG, "updateConnection").serviceDetails("Devops", "UpdateConnection", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/UpdateConnection").method(Method.PUT).requestBuilder(UpdateConnectionRequest::builder).basePath("/20210630").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Connection.class, UpdateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", UpdateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", UpdateConnectionResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<UpdateDeployArtifactResponse> updateDeployArtifact(UpdateDeployArtifactRequest request, AsyncHandler<UpdateDeployArtifactRequest, UpdateDeployArtifactResponse> handler) {
        Validate.notBlank((String)request.getDeployArtifactId(), (String)"deployArtifactId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeployArtifactDetails(), "updateDeployArtifactDetails is required");
        return this.clientCall(request, UpdateDeployArtifactResponse::builder).logger(LOG, "updateDeployArtifact").serviceDetails("Devops", "UpdateDeployArtifact", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/UpdateDeployArtifact").method(Method.PUT).requestBuilder(UpdateDeployArtifactRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").appendPathParam(request.getDeployArtifactId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeployArtifact.class, UpdateDeployArtifactResponse.Builder::deployArtifact).handleResponseHeaderString("location", UpdateDeployArtifactResponse.Builder::location).handleResponseHeaderString("etag", UpdateDeployArtifactResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateDeployArtifactResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeployArtifactResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDeployEnvironmentResponse> updateDeployEnvironment(UpdateDeployEnvironmentRequest request, AsyncHandler<UpdateDeployEnvironmentRequest, UpdateDeployEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getDeployEnvironmentId(), (String)"deployEnvironmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeployEnvironmentDetails(), "updateDeployEnvironmentDetails is required");
        return this.clientCall(request, UpdateDeployEnvironmentResponse::builder).logger(LOG, "updateDeployEnvironment").serviceDetails("Devops", "UpdateDeployEnvironment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/UpdateDeployEnvironment").method(Method.PUT).requestBuilder(UpdateDeployEnvironmentRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").appendPathParam(request.getDeployEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeployEnvironment.class, UpdateDeployEnvironmentResponse.Builder::deployEnvironment).handleResponseHeaderString("location", UpdateDeployEnvironmentResponse.Builder::location).handleResponseHeaderString("etag", UpdateDeployEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateDeployEnvironmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeployEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDeployPipelineResponse> updateDeployPipeline(UpdateDeployPipelineRequest request, AsyncHandler<UpdateDeployPipelineRequest, UpdateDeployPipelineResponse> handler) {
        Validate.notBlank((String)request.getDeployPipelineId(), (String)"deployPipelineId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeployPipelineDetails(), "updateDeployPipelineDetails is required");
        return this.clientCall(request, UpdateDeployPipelineResponse::builder).logger(LOG, "updateDeployPipeline").serviceDetails("Devops", "UpdateDeployPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/UpdateDeployPipeline").method(Method.PUT).requestBuilder(UpdateDeployPipelineRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").appendPathParam(request.getDeployPipelineId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeployPipeline.class, UpdateDeployPipelineResponse.Builder::deployPipeline).handleResponseHeaderString("location", UpdateDeployPipelineResponse.Builder::location).handleResponseHeaderString("etag", UpdateDeployPipelineResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateDeployPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeployPipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDeployStageResponse> updateDeployStage(UpdateDeployStageRequest request, AsyncHandler<UpdateDeployStageRequest, UpdateDeployStageResponse> handler) {
        Validate.notBlank((String)request.getDeployStageId(), (String)"deployStageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeployStageDetails(), "updateDeployStageDetails is required");
        return this.clientCall(request, UpdateDeployStageResponse::builder).logger(LOG, "updateDeployStage").serviceDetails("Devops", "UpdateDeployStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/UpdateDeployStage").method(Method.PUT).requestBuilder(UpdateDeployStageRequest::builder).basePath("/20210630").appendPathParam("deployStages").appendPathParam(request.getDeployStageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeployStage.class, UpdateDeployStageResponse.Builder::deployStage).handleResponseHeaderString("location", UpdateDeployStageResponse.Builder::location).handleResponseHeaderString("etag", UpdateDeployStageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateDeployStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeployStageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest request, AsyncHandler<UpdateDeploymentRequest, UpdateDeploymentResponse> handler) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeploymentDetails(), "updateDeploymentDetails is required");
        return this.clientCall(request, UpdateDeploymentResponse::builder).logger(LOG, "updateDeployment").serviceDetails("Devops", "UpdateDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/UpdateDeployment").method(Method.PUT).requestBuilder(UpdateDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Deployment.class, UpdateDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", UpdateDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("Devops", "UpdateProject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/UpdateProject").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, UpdateProjectResponse.Builder::project).handleResponseHeaderString("location", UpdateProjectResponse.Builder::location).handleResponseHeaderString("etag", UpdateProjectResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRepositoryResponse> updateRepository(UpdateRepositoryRequest request, AsyncHandler<UpdateRepositoryRequest, UpdateRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRepositoryDetails(), "updateRepositoryDetails is required");
        return this.clientCall(request, UpdateRepositoryResponse::builder).logger(LOG, "updateRepository").serviceDetails("Devops", "UpdateRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/UpdateRepository").method(Method.PUT).requestBuilder(UpdateRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Repository.class, UpdateRepositoryResponse.Builder::repository).handleResponseHeaderString("opc-work-request-id", UpdateRepositoryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRepositoryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateRepositoryResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateTriggerResponse> updateTrigger(UpdateTriggerRequest request, AsyncHandler<UpdateTriggerRequest, UpdateTriggerResponse> handler) {
        Validate.notBlank((String)request.getTriggerId(), (String)"triggerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTriggerDetails(), "updateTriggerDetails is required");
        return this.clientCall(request, UpdateTriggerResponse::builder).logger(LOG, "updateTrigger").serviceDetails("Devops", "UpdateTrigger", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/UpdateTrigger").method(Method.PUT).requestBuilder(UpdateTriggerRequest::builder).basePath("/20210630").appendPathParam("triggers").appendPathParam(request.getTriggerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Trigger.class, UpdateTriggerResponse.Builder::trigger).handleResponseHeaderString("etag", UpdateTriggerResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateTriggerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateTriggerResponse.Builder::opcRequestId).handleResponseHeaderString("location", UpdateTriggerResponse.Builder::location).callAsync(handler);
    }

    @Deprecated
    public DevopsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DevopsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DevopsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DevopsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DevopsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DevopsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DevopsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DevopsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DevopsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DevopsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DevopsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DevopsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DevopsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DevopsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DevopsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DevopsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DevopsAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

