/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionMap
extends BaseContextMap {
    private final HttpServletRequest request;

    SessionMap(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void clear() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            Enumeration e = session.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                session.removeAttribute(name);
            }
        }
    }

    @Override
    public void putAll(Map t) {
        HttpSession session = this.getSession(true);
        for (Map.Entry entry : t.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        HttpSession session = this.getSession(false);
        return session != null ? session.getAttribute(key.toString()) : null;
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        HttpSession session = this.getSession(true);
        Object result = session.getAttribute(key.toString());
        session.setAttribute(key.toString(), value);
        return result;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        HttpSession session = this.getSession(false);
        if (session != null) {
            String keyString = key.toString();
            Object result = session.getAttribute(keyString);
            session.removeAttribute(keyString);
            return result;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        HttpSession session = this.getSession(false);
        return session != null && session.getAttribute(key.toString()) != null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof SessionMap && super.equals(obj);
    }

    private HttpSession getSession(boolean createNew) {
        return this.request.getSession(createNew);
    }

    @Override
    public int hashCode() {
        HttpSession session = this.getSession(false);
        int hashCode = 7 * (session != null ? session.hashCode() : super.hashCode());
        if (session != null) {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                hashCode += ((Object)i.next()).hashCode();
            }
        }
        return hashCode;
    }

    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        HttpSession session = this.getSession(false);
        return session != null ? new BaseContextMap.EntryIterator(session.getAttributeNames()) : Collections.emptyMap().entrySet().iterator();
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        HttpSession session = this.getSession(false);
        return session != null ? new BaseContextMap.KeyIterator(session.getAttributeNames()) : Collections.emptyMap().entrySet().iterator();
    }

    protected Iterator<Object> getValueIterator() {
        HttpSession session = this.getSession(false);
        return session != null ? new BaseContextMap.ValueIterator(session.getAttributeNames()) : Collections.emptyMap().entrySet().iterator();
    }
}

