/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.config.WildflyMailSessionResource;
import org.netbeans.modules.javaee.wildfly.nodes.Util;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyAsyncChildren;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyMailSessionNode;
import org.netbeans.modules.javaee.wildfly.nodes.actions.Refreshable;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

class WildflyMailSessionsChildren
extends WildflyAsyncChildren
implements Refreshable {
    private static final Logger LOGGER = Logger.getLogger(WildflyMailSessionsChildren.class.getName());
    private final Lookup lookup;

    public WildflyMailSessionsChildren(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void updateKeys() {
        this.setKeys(new Object[]{"wait_node"});
        this.getExecutorService().submit(new WildflyMailSessionsNodeUpdater(), 0);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof WildflyMailSessionNode) {
            return new Node[]{(WildflyMailSessionNode)((Object)key)};
        }
        if (key instanceof String && key.equals("wait_node")) {
            return new Node[]{Util.createWaitNode()};
        }
        return null;
    }

    class WildflyMailSessionsNodeUpdater
    implements Runnable {
        List<WildflyMailSessionNode> keys = new ArrayList<WildflyMailSessionNode>();

        WildflyMailSessionsNodeUpdater() {
        }

        @Override
        public void run() {
            try {
                WildflyDeploymentManager dm = (WildflyDeploymentManager)WildflyMailSessionsChildren.this.lookup.lookup(WildflyDeploymentManager.class);
                for (WildflyMailSessionResource mailSession : dm.getClient().listMailSessions()) {
                    this.keys.add(new WildflyMailSessionNode(mailSession.getName(), mailSession, WildflyMailSessionsChildren.this.lookup));
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            WildflyMailSessionsChildren.this.setKeys(this.keys);
        }
    }
}

