/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.launch;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class NIOStreams {
    private static final int PREREAD_BUFFER_SIZE = 100;
    private static final Logger LOG = Logger.getLogger(NIOStreams.class.getName());
    private static final RequestProcessor CLOSE_RP = new RequestProcessor("SocketChannel close handler");
    private static final int WATCH_TIMEOUT = 5000;
    private static StreamWatch WATCHER;

    NIOStreams() {
    }

    public static OutputStream createOutputStream(SocketChannel channel, int timeout) throws IOException {
        assert (!channel.isBlocking());
        Output o = new Output(channel, timeout);
        LOG.log(Level.FINER, "Created OutputStream {0} for socket {1}", new Object[]{o, channel});
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StreamWatch watch() throws IOException {
        StreamWatch watcher;
        RequestProcessor requestProcessor = CLOSE_RP;
        synchronized (requestProcessor) {
            watcher = WATCHER;
            if (WATCHER == null) {
                WATCHER = watcher = new StreamWatch();
                CLOSE_RP.post((Runnable)watcher);
            }
        }
        return watcher;
    }

    public static InputStream createInputStream(SocketChannel channel, Consumer<SocketChannel> closeCallback) throws IOException {
        assert (!channel.isBlocking());
        Input i = new Input(channel, closeCallback);
        LOG.log(Level.FINER, "Created InputStream {0} for socket {1}", new Object[]{i, channel});
        return i;
    }

    public static class Input
    extends InputStream {
        private Consumer<SocketChannel> closeCallback;
        private final SocketChannel channel;
        private final Selector selector;
        private int timeout = 0;
        private ByteBuffer prereadContents = ByteBuffer.allocate(100);
        private boolean eof;
        private boolean localClose;
        private final ByteBuffer singleBuffer = ByteBuffer.allocate(1);

        public Input(SocketChannel channel, Consumer<SocketChannel> closeCallback) throws IOException {
            this.closeCallback = closeCallback;
            this.channel = channel;
            this.selector = Selector.open();
            channel.register(this.selector, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean preReadContents() throws IOException {
            Input input = this;
            synchronized (input) {
                int count;
                while (true) {
                    count = this.channel.read(this.prereadContents);
                    if (this.prereadContents.remaining() != 0) break;
                    ByteBuffer expand = ByteBuffer.allocate(this.prereadContents.capacity() * 2);
                    this.prereadContents.flip();
                    expand.put(this.prereadContents);
                    this.prereadContents = expand;
                }
                LOG.log(Level.FINE, "Preread channel {0}: got {1} bytes, buffer: {2}", new Object[]{this.channel, this.prereadContents.position(), this.prereadContents.toString()});
                if (count != -1 && this.channel.isOpen()) {
                    return false;
                }
                this.eof = true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int totalRead = 0;
            ByteBuffer bb = ByteBuffer.wrap(b, off, len);
            int read = 0;
            while (true) {
                Input input = this;
                synchronized (input) {
                    if (this.prereadContents.position() > 0) {
                        this.prereadContents.flip();
                        int end = this.prereadContents.limit();
                        int l = Math.min(end, len);
                        this.prereadContents.limit(l);
                        bb.put(this.prereadContents);
                        this.prereadContents.limit(end);
                        this.prereadContents.compact();
                        LOG.log(Level.FINE, "Preread from channel {0}: given {1} bytes, preread buffer: {2}", new Object[]{this.channel, l, this.prereadContents.toString()});
                        if (l == len) {
                            return l;
                        }
                        off += l;
                        len -= l;
                        totalRead = l;
                    }
                    if (this.eof || !this.channel.isConnected()) {
                        read = -1;
                        break;
                    }
                }
                LOG.log(Level.FINE, "Reading from channel: {0}", this.channel);
                read = this.channel.read(bb);
                LOG.log(Level.FINE, "Reading from channel: {0}, read {1} bytes", new Object[]{this.channel, read});
                if (read < 0) break;
                totalRead += read;
                if (bb.remaining() == 0) {
                    return totalRead;
                }
                this.selector.select(this.timeout);
                input = this;
                synchronized (input) {
                    if (this.eof || !this.channel.isConnected()) {
                        read = -1;
                        break;
                    }
                }
            }
            if (totalRead == 0 && read < 0) {
                this.notifyClose();
                return -1;
            }
            return totalRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Input input = this;
            synchronized (input) {
                this.eof = true;
                this.localClose = true;
                this.selector.wakeup();
            }
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyClose() {
            Consumer<SocketChannel> c;
            Input input = this;
            synchronized (input) {
                c = this.closeCallback;
                this.closeCallback = null;
            }
            if (c != null) {
                c.accept(this.channel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            boolean end = false;
            while (!end) {
                Input input = this;
                synchronized (input) {
                    if (this.prereadContents.position() > 0) {
                        this.prereadContents.limit(this.prereadContents.position());
                        this.prereadContents.position(0);
                        byte b = this.prereadContents.get();
                        this.prereadContents.compact();
                        LOG.log(Level.FINE, "Single read from channel: {0}, got from preread. Buffe state: {1}", new Object[]{this.channel, this.prereadContents});
                        return b;
                    }
                    end = this.eof || !this.channel.isConnected();
                }
                this.singleBuffer.clear();
                int read = this.channel.read(this.singleBuffer);
                LOG.log(Level.FINE, "Single read from channel: {0}, got: {1}", new Object[]{this.channel, read});
                if (read > 0) {
                    this.singleBuffer.flip();
                    return this.singleBuffer.get();
                }
                if (read == -1) break;
                this.selector.select(this.timeout);
                Input input2 = this;
                synchronized (input2) {
                    end = this.eof || !this.channel.isConnected();
                }
            }
            this.notifyClose();
            return -1;
        }

        public String toString() {
            return "NIO-Input@" + Integer.toString(this.hashCode(), 16);
        }
    }

    private static final class Output
    extends OutputStream {
        private final SocketChannel channel;
        private final Selector selector;
        private final int timeout;
        private ByteBuffer singleBuffer = ByteBuffer.allocate(1);

        public Output(SocketChannel channel, int timeout) throws IOException {
            this.timeout = timeout;
            this.channel = channel;
            this.selector = Selector.open();
            channel.register(this.selector, 4);
        }

        @Override
        public void close() throws IOException {
            this.selector.wakeup();
            this.channel.close();
            super.close();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ByteBuffer bb = ByteBuffer.wrap(b, off, len);
            while (bb.remaining() > 0) {
                this.channel.write(bb);
                if (bb.remaining() == 0) {
                    return;
                }
                int sel = this.selector.select(this.timeout);
                if (sel == 0) {
                    throw new IOException("Timed out");
                }
                if (this.channel.isConnected()) continue;
                throw new EOFException("Closed");
            }
        }

        @Override
        public void write(int b) throws IOException {
            int sel;
            byte out = (byte)(b & 0xFF);
            this.singleBuffer.clear();
            this.singleBuffer.put(out);
            this.singleBuffer.flip();
            do {
                int written;
                if ((written = this.channel.write(this.singleBuffer)) > 0) {
                    return;
                }
                sel = this.selector.select(this.timeout);
                if (this.channel.isConnected()) continue;
                throw new EOFException("Connection closed");
            } while (sel > 0);
            throw new IOException("Timed out");
        }

        public String toString() {
            return "NIO-Output@" + Integer.toString(this.hashCode(), 16);
        }
    }

    private static final class StreamWatch
    implements Runnable {
        private final Selector openedStreams = Selector.open();
        private final Set<Channel> watchedChannels = new HashSet<Channel>();
        private final Map<SelectableChannel, InputData> requests = new HashMap<SelectableChannel, InputData>();

        StreamWatch() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(SocketChannel channel, InputData info) throws IOException {
            Map<SelectableChannel, InputData> map = this.requests;
            synchronized (map) {
                if (!this.watchedChannels.add(channel)) {
                    return;
                }
                this.openedStreams.wakeup();
                this.requests.put(channel, info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRegistrations() {
            ArrayList<Map.Entry<SelectableChannel, InputData>> closedRequests = new ArrayList<Map.Entry<SelectableChannel, InputData>>();
            Map<SelectableChannel, InputData> map = this.requests;
            synchronized (map) {
                for (Map.Entry<SelectableChannel, InputData> entry : this.requests.entrySet()) {
                    try {
                        SelectionKey key = entry.getKey().register(this.openedStreams, 1);
                        key.attach(entry.getValue());
                    }
                    catch (ClosedChannelException ex) {
                        closedRequests.add(entry);
                    }
                }
                this.requests.clear();
            }
            for (Map.Entry entry : closedRequests) {
                InputData inputData = (InputData)entry.getValue();
                if (inputData.closeCallback == null) continue;
                inputData.closeCallback.accept((SocketChannel)entry.getKey());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        InputData info;
                        this.processRegistrations();
                        int sel = this.openedStreams.select(5000L);
                        Set<SelectionKey> keys = this.openedStreams.selectedKeys();
                        Iterator<SelectionKey> it = keys.iterator();
                        while (it.hasNext()) {
                            SelectionKey k = it.next();
                            SelectableChannel ch = k.channel();
                            if (!k.isValid() || !ch.isOpen()) continue;
                            info = (InputData)k.attachment();
                            if (info.input != null && info.input.preReadContents()) continue;
                            it.remove();
                        }
                        if (keys.isEmpty()) continue;
                        ArrayList<SelectableChannel> removed = new ArrayList<SelectableChannel>();
                        LOG.log(Level.FINER, "Closehandler woke up with {0} channels, keys: {1}", new Object[]{sel, keys});
                        for (SelectionKey k : keys) {
                            info = (InputData)k.attachment();
                            SelectableChannel ch = k.channel();
                            removed.add(ch);
                            try {
                                if (info.input != null) {
                                    info.input.notifyClose();
                                } else {
                                    info.closeCallback.accept((SocketChannel)ch);
                                }
                                k.cancel();
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        Map<SelectableChannel, InputData> map = this.requests;
                        synchronized (map) {
                            this.watchedChannels.removeAll(removed);
                        }
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Exception occurred during close processing", ex);
                    continue;
                }
                break;
            }
        }
    }

    private static class InputData {
        Consumer<SocketChannel> closeCallback;
        Input input;

        private InputData() {
        }
    }
}

