/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wcadmin;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CleanupAction
extends ContextAction {
    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected int getFileEnabledStatus() {
        return 0;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_Cleanup_Title";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Context ctx = this.getContext(nodes);
        final File[] roots = ctx.getRootFiles();
        if (roots == null || roots.length == 0) {
            Subversion.LOG.log(Level.FINE, "No versioned folder in the selected context for {0}", nodes);
            return;
        }
        File root = roots[0];
        SVNUrl repository = null;
        try {
            repository = SvnUtils.getRepositoryRootUrl(root);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
        }
        final SVNUrl repositoryUrl = repository;
        if (repositoryUrl == null) {
            Subversion.LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{root});
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        SvnProgressSupport support = new SvnProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                for (File root : roots) {
                    try {
                        SvnClient client = repositoryUrl == null ? Subversion.getInstance().getClient(false) : Subversion.getInstance().getClient(root);
                        this.setCancellableDelegate(client);
                        client.cleanup(root);
                    }
                    catch (SVNClientException ex) {
                        this.annotate(ex);
                    }
                    finally {
                        if (repositoryUrl != null) {
                            this.getLogger().getOpenOutputAction().actionPerformed(new ActionEvent(this, 1001, ""));
                        }
                    }
                }
            }
        };
        support.start(rp, repositoryUrl, NbBundle.getMessage(CleanupAction.class, (String)"LBL_Cleanup_Progress"));
    }
}

