/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.adm.ApplicationDependencyManagement;
import com.oracle.bmc.adm.ApplicationDependencyManagementPaginators;
import com.oracle.bmc.adm.ApplicationDependencyManagementWaiters;
import com.oracle.bmc.adm.model.ApplicationDependencyVulnerabilityCollection;
import com.oracle.bmc.adm.model.KnowledgeBase;
import com.oracle.bmc.adm.model.KnowledgeBaseCollection;
import com.oracle.bmc.adm.model.VulnerabilityAudit;
import com.oracle.bmc.adm.model.VulnerabilityAuditCollection;
import com.oracle.bmc.adm.model.WorkRequest;
import com.oracle.bmc.adm.model.WorkRequestErrorCollection;
import com.oracle.bmc.adm.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.adm.model.WorkRequestSummaryCollection;
import com.oracle.bmc.adm.requests.CancelWorkRequestRequest;
import com.oracle.bmc.adm.requests.ChangeKnowledgeBaseCompartmentRequest;
import com.oracle.bmc.adm.requests.ChangeVulnerabilityAuditCompartmentRequest;
import com.oracle.bmc.adm.requests.CreateKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.CreateVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.DeleteKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.DeleteVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.GetVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.GetWorkRequestRequest;
import com.oracle.bmc.adm.requests.ListApplicationDependencyVulnerabilitiesRequest;
import com.oracle.bmc.adm.requests.ListKnowledgeBasesRequest;
import com.oracle.bmc.adm.requests.ListVulnerabilityAuditsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestsRequest;
import com.oracle.bmc.adm.requests.UpdateKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.UpdateVulnerabilityAuditRequest;
import com.oracle.bmc.adm.responses.CancelWorkRequestResponse;
import com.oracle.bmc.adm.responses.ChangeKnowledgeBaseCompartmentResponse;
import com.oracle.bmc.adm.responses.ChangeVulnerabilityAuditCompartmentResponse;
import com.oracle.bmc.adm.responses.CreateKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.CreateVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.DeleteKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.DeleteVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.GetVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.GetWorkRequestResponse;
import com.oracle.bmc.adm.responses.ListApplicationDependencyVulnerabilitiesResponse;
import com.oracle.bmc.adm.responses.ListKnowledgeBasesResponse;
import com.oracle.bmc.adm.responses.ListVulnerabilityAuditsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestsResponse;
import com.oracle.bmc.adm.responses.UpdateKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.UpdateVulnerabilityAuditResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDependencyManagementClient
extends BaseSyncClient
implements ApplicationDependencyManagement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPLICATIONDEPENDENCYMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://adm.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDependencyManagementClient.class);
    private final ApplicationDependencyManagementWaiters waiters;
    private final ApplicationDependencyManagementPaginators paginators;

    private ApplicationDependencyManagementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ApplicationDependencyManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ApplicationDependencyManagementWaiters(executorService, this);
        this.paginators = new ApplicationDependencyManagementPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("ApplicationDependencyManagement", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeKnowledgeBaseCompartmentResponse changeKnowledgeBaseCompartment(ChangeKnowledgeBaseCompartmentRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeKnowledgeBaseCompartmentDetails(), "changeKnowledgeBaseCompartmentDetails is required");
        return (ChangeKnowledgeBaseCompartmentResponse)this.clientCall(request, ChangeKnowledgeBaseCompartmentResponse::builder).logger(LOG, "changeKnowledgeBaseCompartment").serviceDetails("ApplicationDependencyManagement", "ChangeKnowledgeBaseCompartment", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/ChangeKnowledgeBaseCompartment").method(Method.POST).requestBuilder(ChangeKnowledgeBaseCompartmentRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeKnowledgeBaseCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeKnowledgeBaseCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeVulnerabilityAuditCompartmentResponse changeVulnerabilityAuditCompartment(ChangeVulnerabilityAuditCompartmentRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVulnerabilityAuditCompartmentDetails(), "changeVulnerabilityAuditCompartmentDetails is required");
        return (ChangeVulnerabilityAuditCompartmentResponse)this.clientCall(request, ChangeVulnerabilityAuditCompartmentResponse::builder).logger(LOG, "changeVulnerabilityAuditCompartment").serviceDetails("ApplicationDependencyManagement", "ChangeVulnerabilityAuditCompartment", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/ChangeVulnerabilityAuditCompartment").method(Method.POST).requestBuilder(ChangeVulnerabilityAuditCompartmentRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeVulnerabilityAuditCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateKnowledgeBaseResponse createKnowledgeBase(CreateKnowledgeBaseRequest request) {
        Objects.requireNonNull(request.getCreateKnowledgeBaseDetails(), "createKnowledgeBaseDetails is required");
        return (CreateKnowledgeBaseResponse)this.clientCall(request, CreateKnowledgeBaseResponse::builder).logger(LOG, "createKnowledgeBase").serviceDetails("ApplicationDependencyManagement", "CreateKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/CreateKnowledgeBase").method(Method.POST).requestBuilder(CreateKnowledgeBaseRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateKnowledgeBaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateKnowledgeBaseResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateVulnerabilityAuditResponse createVulnerabilityAudit(CreateVulnerabilityAuditRequest request) {
        Objects.requireNonNull(request.getCreateVulnerabilityAuditDetails(), "createVulnerabilityAuditDetails is required");
        return (CreateVulnerabilityAuditResponse)this.clientCall(request, CreateVulnerabilityAuditResponse::builder).logger(LOG, "createVulnerabilityAudit").serviceDetails("ApplicationDependencyManagement", "CreateVulnerabilityAudit", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/CreateVulnerabilityAudit").method(Method.POST).requestBuilder(CreateVulnerabilityAuditRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(VulnerabilityAudit.class, CreateVulnerabilityAuditResponse.Builder::vulnerabilityAudit).handleResponseHeaderString("etag", CreateVulnerabilityAuditResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateVulnerabilityAuditResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVulnerabilityAuditResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteKnowledgeBaseResponse deleteKnowledgeBase(DeleteKnowledgeBaseRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        return (DeleteKnowledgeBaseResponse)this.clientCall(request, DeleteKnowledgeBaseResponse::builder).logger(LOG, "deleteKnowledgeBase").serviceDetails("ApplicationDependencyManagement", "DeleteKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/DeleteKnowledgeBase").method(Method.DELETE).requestBuilder(DeleteKnowledgeBaseRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteKnowledgeBaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteKnowledgeBaseResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteVulnerabilityAuditResponse deleteVulnerabilityAudit(DeleteVulnerabilityAuditRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        return (DeleteVulnerabilityAuditResponse)this.clientCall(request, DeleteVulnerabilityAuditResponse::builder).logger(LOG, "deleteVulnerabilityAudit").serviceDetails("ApplicationDependencyManagement", "DeleteVulnerabilityAudit", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/DeleteVulnerabilityAudit").method(Method.DELETE).requestBuilder(DeleteVulnerabilityAuditRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteVulnerabilityAuditResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetKnowledgeBaseResponse getKnowledgeBase(GetKnowledgeBaseRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        return (GetKnowledgeBaseResponse)this.clientCall(request, GetKnowledgeBaseResponse::builder).logger(LOG, "getKnowledgeBase").serviceDetails("ApplicationDependencyManagement", "GetKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/GetKnowledgeBase").method(Method.GET).requestBuilder(GetKnowledgeBaseRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(KnowledgeBase.class, GetKnowledgeBaseResponse.Builder::knowledgeBase).handleResponseHeaderString("opc-request-id", GetKnowledgeBaseResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetKnowledgeBaseResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetVulnerabilityAuditResponse getVulnerabilityAudit(GetVulnerabilityAuditRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        return (GetVulnerabilityAuditResponse)this.clientCall(request, GetVulnerabilityAuditResponse::builder).logger(LOG, "getVulnerabilityAudit").serviceDetails("ApplicationDependencyManagement", "GetVulnerabilityAudit", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/GetVulnerabilityAudit").method(Method.GET).requestBuilder(GetVulnerabilityAuditRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VulnerabilityAudit.class, GetVulnerabilityAuditResponse.Builder::vulnerabilityAudit).handleResponseHeaderString("etag", GetVulnerabilityAuditResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVulnerabilityAuditResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ApplicationDependencyManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListApplicationDependencyVulnerabilitiesResponse listApplicationDependencyVulnerabilities(ListApplicationDependencyVulnerabilitiesRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        return (ListApplicationDependencyVulnerabilitiesResponse)this.clientCall(request, ListApplicationDependencyVulnerabilitiesResponse::builder).logger(LOG, "listApplicationDependencyVulnerabilities").serviceDetails("ApplicationDependencyManagement", "ListApplicationDependencyVulnerabilities", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/ListApplicationDependencyVulnerabilities").method(Method.GET).requestBuilder(ListApplicationDependencyVulnerabilitiesRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).appendPathParam("applicationDependencyVulnerabilities").appendQueryParam("vulnerabilityId", (Object)request.getVulnerabilityId()).appendQueryParam("cvssV3GreaterThanOrEqual", (Object)request.getCvssV3GreaterThanOrEqual()).appendQueryParam("cvssV2GreaterThanOrEqual", (Object)request.getCvssV2GreaterThanOrEqual()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("rootNodeId", (Object)request.getRootNodeId()).appendQueryParam("depth", (Object)request.getDepth()).appendQueryParam("gav", (Object)request.getGav()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApplicationDependencyVulnerabilityCollection.class, ListApplicationDependencyVulnerabilitiesResponse.Builder::applicationDependencyVulnerabilityCollection).handleResponseHeaderString("opc-request-id", ListApplicationDependencyVulnerabilitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApplicationDependencyVulnerabilitiesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListKnowledgeBasesResponse listKnowledgeBases(ListKnowledgeBasesRequest request) {
        return (ListKnowledgeBasesResponse)this.clientCall(request, ListKnowledgeBasesResponse::builder).logger(LOG, "listKnowledgeBases").serviceDetails("ApplicationDependencyManagement", "ListKnowledgeBases", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/ListKnowledgeBases").method(Method.GET).requestBuilder(ListKnowledgeBasesRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(KnowledgeBaseCollection.class, ListKnowledgeBasesResponse.Builder::knowledgeBaseCollection).handleResponseHeaderString("opc-request-id", ListKnowledgeBasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListKnowledgeBasesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListVulnerabilityAuditsResponse listVulnerabilityAudits(ListVulnerabilityAuditsRequest request) {
        return (ListVulnerabilityAuditsResponse)this.clientCall(request, ListVulnerabilityAuditsResponse::builder).logger(LOG, "listVulnerabilityAudits").serviceDetails("ApplicationDependencyManagement", "ListVulnerabilityAudits", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/ListVulnerabilityAudits").method(Method.GET).requestBuilder(ListVulnerabilityAuditsRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("knowledgeBaseId", (Object)request.getKnowledgeBaseId()).appendQueryParam("isSuccess", (Object)request.getIsSuccess()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VulnerabilityAuditCollection.class, ListVulnerabilityAuditsResponse.Builder::vulnerabilityAuditCollection).handleResponseHeaderString("opc-request-id", ListVulnerabilityAuditsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVulnerabilityAuditsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ApplicationDependencyManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ApplicationDependencyManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ApplicationDependencyManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateKnowledgeBaseResponse updateKnowledgeBase(UpdateKnowledgeBaseRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateKnowledgeBaseDetails(), "updateKnowledgeBaseDetails is required");
        return (UpdateKnowledgeBaseResponse)this.clientCall(request, UpdateKnowledgeBaseResponse::builder).logger(LOG, "updateKnowledgeBase").serviceDetails("ApplicationDependencyManagement", "UpdateKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/UpdateKnowledgeBase").method(Method.PUT).requestBuilder(UpdateKnowledgeBaseRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateKnowledgeBaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateKnowledgeBaseResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateVulnerabilityAuditResponse updateVulnerabilityAudit(UpdateVulnerabilityAuditRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVulnerabilityAuditDetails(), "updateVulnerabilityAuditDetails is required");
        return (UpdateVulnerabilityAuditResponse)this.clientCall(request, UpdateVulnerabilityAuditResponse::builder).logger(LOG, "updateVulnerabilityAudit").serviceDetails("ApplicationDependencyManagement", "UpdateVulnerabilityAudit", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/UpdateVulnerabilityAudit").method(Method.PUT).requestBuilder(UpdateVulnerabilityAuditRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(VulnerabilityAudit.class, UpdateVulnerabilityAuditResponse.Builder::vulnerabilityAudit).handleResponseHeaderString("etag", UpdateVulnerabilityAuditResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVulnerabilityAuditResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ApplicationDependencyManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ApplicationDependencyManagementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ApplicationDependencyManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ApplicationDependencyManagementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ApplicationDependencyManagementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApplicationDependencyManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ApplicationDependencyManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ApplicationDependencyManagementClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

