/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey;

import com.oracle.bmc.http.client.HttpResponse;
import com.oracle.bmc.http.client.Options;
import com.oracle.bmc.http.client.jersey.JerseyHttpRequest;
import com.oracle.bmc.http.client.jersey.WrappedResponseInputStream;
import com.oracle.bmc.http.client.jersey.io.internal.AutoCloseableContentLengthVerifyingInputStream;
import com.oracle.bmc.http.client.jersey.io.internal.ContentLengthVerifyingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JerseyHttpResponse
implements HttpResponse {
    private static final Logger log = LoggerFactory.getLogger(JerseyHttpResponse.class);
    private final Response response;
    private boolean bodyConsumed = false;

    JerseyHttpResponse(Response response) {
        this.response = response;
    }

    public int status() {
        return this.response.getStatus();
    }

    public Map<String, List<String>> headers() {
        return this.response.getStringHeaders();
    }

    public String header(String name) {
        return this.response.getHeaderString(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<InputStream> streamBody() {
        this.bodyConsumed = true;
        List contentType = (List)this.response.getHeaders().remove((Object)"Content-Type");
        log.debug("Entity type is InputStream, ignoring contentType {} and processing as stream", (Object)contentType);
        try {
            long contentLength;
            InputStream rawInputStream = (InputStream)this.response.readEntity(InputStream.class);
            InputStream inputStream = new WrappedResponseInputStream(rawInputStream, this.response);
            String contentLengthStr = this.header("Content-Length");
            if (contentLengthStr != null && this.header("Content-Encoding") == null && (contentLength = Long.parseLong(contentLengthStr)) > 0L) {
                if (Options.getShouldAutoCloseResponseInputStream()) {
                    if (JerseyHttpRequest.isExtraStreamLogsEnabled) {
                        log.warn("Wrapping response stream into auto closeable stream, to disable this, please use Options.shouldAutoCloseResponseInputStream(false)");
                    }
                    inputStream = new AutoCloseableContentLengthVerifyingInputStream(inputStream, contentLength);
                } else {
                    inputStream = new ContentLengthVerifyingInputStream(inputStream, contentLength);
                }
            }
            CompletableFuture<InputStream> completableFuture = CompletableFuture.completedFuture(inputStream);
            return completableFuture;
        }
        catch (Exception e) {
            CompletableFuture<InputStream> completableFuture = JerseyHttpResponse.failedFuture(e);
            return completableFuture;
        }
        finally {
            if (contentType != null) {
                this.response.getHeaders().addAll((Object)"Content-Type", contentType);
            }
        }
    }

    public <T> CompletionStage<T> body(Class<T> type) {
        this.bodyConsumed = true;
        try {
            return CompletableFuture.completedFuture(this.readEntitySync(new GenericType(type)));
        }
        catch (Exception e) {
            return JerseyHttpResponse.failedFuture(e);
        }
    }

    public <T> CompletionStage<List<T>> listBody(Class<T> type) {
        this.bodyConsumed = true;
        GenericType listType = new GenericType((Type)new SimpleParameterizedType(List.class, type));
        try {
            return CompletableFuture.completedFuture(this.readEntitySync(listType));
        }
        catch (Exception e) {
            return JerseyHttpResponse.failedFuture(e);
        }
    }

    private <T> T readEntitySync(GenericType<T> type) {
        this.response.bufferEntity();
        return (T)this.response.readEntity(type);
    }

    public CompletionStage<String> textBody() {
        this.bodyConsumed = true;
        return CompletableFuture.completedFuture(this.response.readEntity(String.class));
    }

    public void close() {
        if (!this.bodyConsumed && this.response.hasEntity()) {
            try {
                ((InputStream)this.response.readEntity(InputStream.class)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.response.close();
    }

    private static <T> CompletableFuture<T> failedFuture(Throwable failure) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(failure);
        return future;
    }

    private static final class SimpleParameterizedType
    implements ParameterizedType {
        private final Class<?> rawType;
        private final Type contentType;

        SimpleParameterizedType(Class<?> rawType, Type contentType) {
            this.rawType = rawType;
            this.contentType = contentType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.contentType};
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }
}

