/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;

public final class SurroundWithHint
extends CodeActionsProvider {
    private static final String COMMAND_INSERT_SNIPPET = "editor.action.insertSnippet";
    private static final String COMMAND_SURROUND_WITH = "java.surround.with";
    private static final String DOTS = "...";
    private static final String SNIPPET = "snippet";
    private static final String SELECTION_VAR = "${selection}";
    private static final String SELECTED_TEXT_VAR = "${0:$TM_SELECTED_TEXT}";
    private static final Pattern SNIPPET_VAR_PATTERN = Pattern.compile("\\$\\{\\s*([-\\w]++)((?:\\s*[-\\w]++(?:\\s*=\\s*(?:\\\"[^\\\"]*\\\"|[-\\w]++))?)*\\s*)?}");
    private static final Pattern SNIPPET_HINT_PATTERN = Pattern.compile("([-\\w]++)(?:\\s*=\\s*(\\\"([^\\\"]*)\\\"|[-\\w]++))?");
    private static final String UNCAUGHT_EXCEPTION_CATCH_STATEMENTS = "uncaughtExceptionCatchStatements";
    private static final Set<String> TO_FILTER = Collections.singleton("fcom");
    private static final Set<String> TO_SHOW = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bcom", "dowhile", "iff", "fore", "sy", "trycatch", "whilexp")));

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        Document doc;
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        int startOffset = SurroundWithHint.getOffset((CompilationInfo)info, params.getRange().getStart());
        int endOffset = SurroundWithHint.getOffset((CompilationInfo)info, params.getRange().getEnd());
        if (startOffset >= endOffset) {
            return Collections.emptyList();
        }
        try {
            doc = info.getDocument();
        }
        catch (IOException ex) {
            return Collections.emptyList();
        }
        Collection<? extends CodeTemplateFilter> filters = SurroundWithHint.getTemplateFilters(doc, startOffset, endOffset);
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        ArrayList<QuickPickItem> items = new ArrayList<QuickPickItem>();
        for (CodeTemplate codeTemplate : CodeTemplateManager.get((Document)doc).getCodeTemplates()) {
            int idx;
            String parametrizedText = codeTemplate.getParametrizedText();
            if (!parametrizedText.toLowerCase().contains(SELECTION_VAR) || TO_FILTER.contains(codeTemplate.getAbbreviation()) || codeTemplate.getContexts() != null && !codeTemplate.getContexts().isEmpty() && !SurroundWithHint.accept(codeTemplate, filters)) continue;
            String text = SurroundWithHint.convert(codeTemplate.getParametrizedText(), null);
            String label = SurroundWithHint.html2text(codeTemplate.getDescription());
            if (label == null) {
                int idx2 = text.indexOf(10);
                label = idx2 < 0 ? text : text.substring(0, idx2) + DOTS;
            }
            StringBuilder sb = new StringBuilder();
            AtomicInteger last = new AtomicInteger();
            List<TextEdit> edits = SurroundWithHint.updateSelection((CompilationInfo)info, startOffset, endOffset, text, sb, last);
            String snippet = SurroundWithHint.convert(codeTemplate.getParametrizedText(), last);
            if (sb.length() > 0) {
                snippet = sb.append(snippet).toString();
            }
            CodeAction codeAction = this.createCodeAction(Bundle.DN_SurroundWith((idx = label.indexOf(32)) < 0 ? label : label.substring(0, idx)), "refactor.rewrite", null, COMMAND_INSERT_SNIPPET, Collections.singletonMap(SNIPPET, snippet));
            if (!edits.isEmpty()) {
                codeAction.setEdit(new WorkspaceEdit(Collections.singletonMap(params.getTextDocument().getUri(), edits)));
            }
            if (TO_SHOW.contains(codeTemplate.getAbbreviation())) {
                codeActions.add(codeAction);
            }
            items.add(new QuickPickItem(label, null, text, false, codeAction));
        }
        if (items.size() > codeActions.size()) {
            codeActions.add(this.createCodeAction(Bundle.DN_SurroundWithAll(), "refactor.rewrite", null, COMMAND_SURROUND_WITH, items));
        }
        return codeActions;
    }

    private static Collection<? extends CodeTemplateFilter> getTemplateFilters(Document doc, int startOffset, int endOffset) {
        String mimeType = DocumentUtilities.getMimeType((Document)doc);
        Collection filterFactories = MimeLookup.getLookup((String)mimeType).lookupAll(CodeTemplateFilter.Factory.class);
        ArrayList<CodeTemplateFilter> result = new ArrayList<CodeTemplateFilter>(filterFactories.size());
        for (CodeTemplateFilter.Factory factory : filterFactories) {
            result.add(factory.createFilter(doc, startOffset, endOffset));
        }
        return result;
    }

    private static boolean accept(CodeTemplate template, Collection<? extends CodeTemplateFilter> filters) {
        for (CodeTemplateFilter codeTemplateFilter : filters) {
            if (codeTemplateFilter.accept(template)) continue;
            return false;
        }
        return true;
    }

    private static String convert(String s, AtomicInteger last) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = SNIPPET_VAR_PATTERN.matcher(s);
        int idx = 0;
        HashMap<String, Integer> placeholders = new HashMap<String, Integer>();
        HashMap<String, String> values = new HashMap<String, String>();
        HashSet<String> nonEditables = new HashSet<String>();
        while (matcher.find(idx)) {
            String name;
            int start = matcher.start();
            sb.append(s.substring(idx, start));
            switch (name = matcher.group(1)) {
                case "cursor": 
                case "no-format": 
                case "no-indent": {
                    break;
                }
                case "selection": {
                    if (last == null) {
                        sb.append(' ');
                        break;
                    }
                    sb.append(SELECTED_TEXT_VAR);
                    break;
                }
                default: {
                    String params;
                    String string = params = matcher.groupCount() > 1 ? matcher.group(2) : null;
                    if (params == null || params.isEmpty()) {
                        if (last == null || nonEditables.contains(name)) {
                            sb.append(values.getOrDefault(name, ""));
                            break;
                        }
                        sb.append('$').append(placeholders.computeIfAbsent(name, n -> last.incrementAndGet()));
                        break;
                    }
                    Map<String, String> hints = SurroundWithHint.getHints(params);
                    String defaultValue = hints.get("default");
                    if (defaultValue != null) {
                        values.put(name, defaultValue);
                    }
                    if (hints.containsKey(UNCAUGHT_EXCEPTION_CATCH_STATEMENTS)) {
                        if (last == null) {
                            sb.append(defaultValue);
                            break;
                        }
                        sb.append("catch (${").append(last.incrementAndGet()).append(":Exception} ${").append(last.incrementAndGet()).append(":e}) {\n}");
                        break;
                    }
                    if ("false".equalsIgnoreCase(hints.get("editable"))) {
                        nonEditables.add(name);
                        sb.append(values.getOrDefault(name, ""));
                        break;
                    }
                    if (defaultValue != null) {
                        if (last == null) {
                            sb.append(defaultValue);
                            break;
                        }
                        sb.append("${").append(placeholders.computeIfAbsent(name, n -> last.incrementAndGet())).append(':').append(defaultValue).append('}');
                        break;
                    }
                    if (last == null) {
                        sb.append(values.getOrDefault(name, ""));
                        break;
                    }
                    sb.append('$').append(placeholders.computeIfAbsent(name, n -> last.incrementAndGet()));
                }
            }
            idx = matcher.end();
        }
        String tail = s.substring(idx);
        return sb.append(tail.endsWith("\n") ? tail.substring(0, tail.length() - 1) : tail).toString();
    }

    private static Map<String, String> getHints(String text) {
        HashMap<String, String> hint2Values = new HashMap<String, String>();
        Matcher matcher = SNIPPET_HINT_PATTERN.matcher(text);
        int idx = 0;
        while (matcher.find(idx)) {
            String insideString = matcher.groupCount() > 2 ? matcher.group(3) : null;
            String value = matcher.groupCount() > 1 ? matcher.group(2) : null;
            hint2Values.put(matcher.group(1), insideString != null ? insideString : value);
            idx = matcher.end();
        }
        return hint2Values;
    }

    private static String html2text(String html) throws IOException {
        if (html == null) {
            return html;
        }
        final StringBuilder sb = new StringBuilder();
        new ParserDelegator().parse(new StringReader(html), new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleText(char[] text, int pos) {
                sb.append(text);
            }
        }, Boolean.TRUE);
        return sb.toString();
    }

    private static List<TextEdit> updateSelection(CompilationInfo info, int startOffset, int endOffset, String templateText, final StringBuilder sb, final AtomicInteger last) {
        TreePath treePath;
        Tree tree;
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        TreeUtilities tu = info.getTreeUtilities();
        StatementTree stat = tu.parseStatement(templateText, null);
        EnumSet<Tree.Kind[]> kinds = EnumSet.of(Tree.Kind.BLOCK, new Tree.Kind[]{Tree.Kind.DO_WHILE_LOOP, Tree.Kind.ENHANCED_FOR_LOOP, Tree.Kind.FOR_LOOP, Tree.Kind.IF, Tree.Kind.SYNCHRONIZED, Tree.Kind.TRY, Tree.Kind.WHILE_LOOP});
        if (stat != null && kinds.contains((Object)stat.getKind()) && (tree = (treePath = tu.pathFor(startOffset)).getLeaf()).getKind() == Tree.Kind.BLOCK && tree == tu.pathFor(endOffset).getLeaf()) {
            final Trees trees = info.getTrees();
            SourcePositions sp = trees.getSourcePositions();
            final HashMap<VariableElement, VariableTree> vars = new HashMap<VariableElement, VariableTree>();
            LinkedList<VariableTree> varList = new LinkedList<VariableTree>();
            ErrorAwareTreePathScanner scanner = new ErrorAwareTreePathScanner(){
                private int cnt = 0;

                public Object visitIdentifier(IdentifierTree node, Object p) {
                    VariableTree var;
                    Element e = trees.getElement(this.getCurrentPath());
                    if (e != null && (var = (VariableTree)vars.remove(e)) != null) {
                        sb.append(var.getType()).append(' ').append(var.getName());
                        TypeMirror tm = ((VariableElement)e).asType();
                        switch (tm.getKind()) {
                            case ARRAY: 
                            case DECLARED: {
                                sb.append(" = ${").append(last.incrementAndGet()).append(':').append("\"null\"}");
                                break;
                            }
                            case BOOLEAN: {
                                sb.append(" = ${").append(last.incrementAndGet()).append(':').append("\"false\"}");
                                break;
                            }
                            case BYTE: 
                            case CHAR: 
                            case DOUBLE: 
                            case FLOAT: 
                            case INT: 
                            case LONG: 
                            case SHORT: {
                                sb.append(" = ${").append(last.incrementAndGet()).append(':').append("\"0\"}");
                            }
                        }
                        sb.append(";\n");
                    }
                    return null;
                }
            };
            for (StatementTree statementTree : ((BlockTree)tree).getStatements()) {
                if (sp.getStartPosition(info.getCompilationUnit(), statementTree) < (long)startOffset) continue;
                if (sp.getEndPosition(info.getCompilationUnit(), statementTree) <= (long)endOffset) {
                    Element e;
                    if (statementTree.getKind() != Tree.Kind.VARIABLE || (e = trees.getElement(new TreePath(treePath, statementTree))) == null || e.getKind() != ElementKind.LOCAL_VARIABLE) continue;
                    vars.put((VariableElement)e, (VariableTree)statementTree);
                    varList.addFirst((VariableTree)statementTree);
                    continue;
                }
                scanner.scan(new TreePath(treePath, statementTree), null);
            }
            Collection vals = vars.values();
            for (VariableTree var : varList) {
                if (vals.contains(var)) continue;
                int start = (int)sp.getStartPosition(info.getCompilationUnit(), var.getType());
                int[] span = tu.findNameSpan(var);
                int end = span != null ? span[0] : (int)sp.getEndPosition(info.getCompilationUnit(), var.getType());
                edits.add(new TextEdit(new Range(Utils.createPosition(info.getCompilationUnit().getLineMap(), start), Utils.createPosition(info.getCompilationUnit().getLineMap(), end)), ""));
            }
        }
        return edits;
    }
}

