/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLContainer;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.SourceRef;
import org.openide.filesystems.FileObject;

public class HCLStructureItem
implements ElementHandle,
StructureItem {
    final HCLElement element;
    final SourceRef references;
    private List<? extends StructureItem> nestedCache;

    public HCLStructureItem(HCLElement element, SourceRef references) {
        this.element = element;
        this.references = references;
    }

    public FileObject getFileObject() {
        return this.references.getFileObject();
    }

    public String getMimeType() {
        return this.getFileObject().getMIMEType();
    }

    public String getName() {
        return this.element.id();
    }

    public String getIn() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean signatureEquals(ElementHandle handle) {
        return false;
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        return this.references.getOffsetRange(this.element).orElse(OffsetRange.NONE);
    }

    public String getSortText() {
        return this.getName();
    }

    public String getHtml(HtmlFormatter formatter) {
        return this.getName();
    }

    public ElementHandle getElementHandle() {
        return this;
    }

    public boolean isLeaf() {
        return this.element instanceof HCLAttribute;
    }

    public List<? extends StructureItem> getNestedItems() {
        if (this.nestedCache == null) {
            if (this.element instanceof HCLContainer) {
                HCLContainer c = (HCLContainer)this.element;
                ArrayList<? extends StructureItem> nested = new ArrayList<StructureItem>();
                for (HCLBlock hCLBlock : c.getBlocks()) {
                    nested.add(new HCLStructureItem(hCLBlock, this.references));
                }
                for (HCLAttribute hCLAttribute : c.getAttributes()) {
                    nested.add(new HCLStructureItem(hCLAttribute, this.references));
                }
                this.nestedCache = nested;
            } else {
                this.nestedCache = Collections.emptyList();
            }
        }
        return this.nestedCache;
    }

    public long getPosition() {
        return this.getOffsetRange(null).getStart();
    }

    public long getEndPosition() {
        return this.getOffsetRange(null).getEnd();
    }

    public ImageIcon getCustomIcon() {
        return null;
    }

    public ElementKind getKind() {
        return this.element instanceof HCLAttribute ? ElementKind.ATTRIBUTE : ElementKind.TAG;
    }
}

