/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class SourceRef {
    public final Snapshot source;
    private Map<HCLElement, OffsetRange> elementOffsets = new HashMap<HCLElement, OffsetRange>();
    private final Comparator<HCLElement> sourceOrder = Comparator.comparing(e -> this.elementOffsets.get(e));

    public SourceRef(Snapshot source) {
        this.source = source;
    }

    void add(HCLElement e, OffsetRange r) {
        this.elementOffsets.put(e, r);
    }

    void add(HCLElement e, int startOffset, int endOffset) {
        this.add(e, new OffsetRange(startOffset, endOffset));
    }

    public FileObject getFileObject() {
        return this.source.getSource().getFileObject();
    }

    public Optional<OffsetRange> getOffsetRange(HCLElement e) {
        return Optional.ofNullable(this.elementOffsets.get(e));
    }

    <E extends HCLElement> List<E> sortBySource(List<? extends E> elements) {
        ArrayList<? extends E> ret = new ArrayList<E>(elements);
        Collections.sort(ret, this.sourceOrder);
        return ret;
    }
}

