/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.ContextView;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ui.BasicAbstractResultsPanel;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class BasicSearchResultsPanel
extends BasicAbstractResultsPanel {
    private final RequestProcessor.Task SAVE_TASK = RequestProcessor.getDefault().create((Runnable)new SaveTask());
    private JSplitPane splitPane;

    public BasicSearchResultsPanel(ResultModel resultModel, BasicComposition composition, boolean details, Node infoNode) {
        super(resultModel, composition, details, new ResultsOutlineSupport(false, details, resultModel, composition, infoNode));
        this.init();
    }

    private void init() {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        leftPanel.add((Component)this.resultsOutlineSupport.getOutlineView());
        this.splitPane = new JSplitPane();
        this.splitPane.setLeftComponent(leftPanel);
        this.splitPane.setRightComponent(new ContextView(this.resultModel, this.getExplorerManager()));
        this.initSplitDividerLocationHandling();
        this.getContentPanel().add(this.splitPane);
    }

    private void initSplitDividerLocationHandling() {
        int location = FindDialogMemory.getDefault().getReplaceResultsDivider();
        if (location > 0) {
            this.splitPane.setDividerLocation(location);
        }
        this.splitPane.addPropertyChangeListener(evt -> {
            String pn = evt.getPropertyName();
            if (pn.equals("dividerLocation")) {
                this.SAVE_TASK.schedule(1000);
            }
        });
    }

    private class SaveTask
    implements Runnable {
        private SaveTask() {
        }

        @Override
        public void run() {
            if (BasicSearchResultsPanel.this.splitPane != null) {
                FindDialogMemory.getDefault().setReplaceResultsDivider(BasicSearchResultsPanel.this.splitPane.getDividerLocation());
            }
        }
    }
}

