/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.watchesfiltering;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.web.debug.watchesfiltering.JspElWatch;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class JspWatchesNodeModel
implements NodeModel {
    private static final String ICON_BASE = "org/netbeans/modules/debugger/resources/watchesView/Watch";
    private final Collection<ModelListener> modelListeners = new HashSet<ModelListener>();
    private final Map<JspElWatch, String> shortDescriptionMap = new HashMap<JspElWatch, String>();
    private RequestProcessor evaluationRP;

    public JspWatchesNodeModel(ContextProvider lookupProvider) {
        this.evaluationRP = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (!(node instanceof JspElWatch)) {
            throw new UnknownTypeException(node);
        }
        JspElWatch watch = (JspElWatch)node;
        return watch.getExpression();
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (!(node instanceof JspElWatch)) {
            throw new UnknownTypeException(node);
        }
        return ICON_BASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(Object node) throws UnknownTypeException {
        if (!(node instanceof JspElWatch)) {
            throw new UnknownTypeException(node);
        }
        final JspElWatch watch = (JspElWatch)node;
        Map<JspElWatch, String> map = this.shortDescriptionMap;
        synchronized (map) {
            String shortDescription = this.shortDescriptionMap.remove(watch);
            if (shortDescription != null) {
                return shortDescription;
            }
        }
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String shortDescription = JspWatchesNodeModel.getShortDescriptionSynch(watch);
                if (shortDescription != null && !"".equals(shortDescription)) {
                    Map map = JspWatchesNodeModel.this.shortDescriptionMap;
                    synchronized (map) {
                        JspWatchesNodeModel.this.shortDescriptionMap.put(watch, shortDescription);
                    }
                    JspWatchesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)JspWatchesNodeModel.this, (Object)watch, 4));
                }
            }
        });
        return "";
    }

    private static String getShortDescriptionSynch(JspElWatch watch) {
        String t = watch.getType();
        String e = watch.getExceptionDescription();
        if (e != null) {
            return watch.getExpression() + " = >" + e + "<";
        }
        if (t == null) {
            return watch.getExpression() + " = " + watch.getValue();
        }
        try {
            return watch.getExpression() + " = (" + watch.getType() + ") " + watch.getToStringValue();
        }
        catch (InvalidExpressionException ex) {
            return ex.getLocalizedMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChange(ModelEvent me) {
        ModelListener[] listeners;
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray(new ModelListener[0]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].modelChanged(me);
        }
    }
}

