/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.moduletask;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.Attribute;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.ClassFile;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.ConstantPool;

public final class ModuleMainClass
extends Task {
    private static final String ATTR_MODULE_MAIN_CLZ = "ModuleMainClass";
    private String mainClass;
    private File moduleInfo;
    private boolean failOnError = true;

    public String getMainclass() {
        return this.mainClass;
    }

    public void setMainclass(String mainClass) {
        this.mainClass = mainClass;
    }

    public File getModuleinfo() {
        return this.moduleInfo;
    }

    public void setModuleinfo(File moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public boolean isFailonerror() {
        return this.failOnError;
    }

    public void setFailonerror(boolean value) {
        this.failOnError = value;
    }

    public void execute() throws BuildException {
        block26: {
            if (this.mainClass == null) {
                String msg = "MainClass must be set.";
                if (this.failOnError) {
                    throw new BuildException("MainClass must be set.");
                }
                this.getProject().log("MainClass must be set.", 1);
                return;
            }
            if (this.moduleInfo == null) {
                String msg = "ModuleInfo must be set.";
                if (this.failOnError) {
                    throw new BuildException("ModuleInfo must be set.");
                }
                this.getProject().log("ModuleInfo must be set.", 1);
                return;
            }
            if (!this.moduleInfo.canRead()) {
                String msg = "MainClass must be readable.";
                if (this.failOnError) {
                    throw new BuildException("MainClass must be readable.");
                }
                this.getProject().log("MainClass must be readable.", 1);
                return;
            }
            if (!this.moduleInfo.canWrite()) {
                String msg = "MainClass must be writable.";
                if (this.failOnError) {
                    throw new BuildException("MainClass must be writable.");
                }
                this.getProject().log("MainClass must be writable.", 1);
                return;
            }
            try {
                ClassFile cf = null;
                try (InputStream in = Files.newInputStream(this.moduleInfo.toPath(), new OpenOption[0]);){
                    cf = new ClassFile(in);
                    ConstantPool cp = cf.getConstantPool();
                    int attrNameIndex = cp.add(new ConstantPool.CPUtf8(cp, ATTR_MODULE_MAIN_CLZ));
                    int classNameIndex = cp.add(new ConstantPool.CPUtf8(cp, ModuleMainClass.internalName(this.mainClass)));
                    int classIndex = cp.add(new ConstantPool.CPClass(cp, classNameIndex));
                    byte[] data = new byte[]{(byte)(classIndex >>> 8), (byte)classIndex};
                    Attribute[] attrs = cf.getAttributes();
                    int toDelete = -1;
                    for (int i = 0; i < attrs.length; ++i) {
                        if (attrs[i].getNameIndex() != attrNameIndex) continue;
                        toDelete = i;
                        break;
                    }
                    if (toDelete != -1) {
                        cf.removeAttribute(toDelete);
                    }
                    cf.addAttribute(new Attribute(attrNameIndex, data));
                }
                if (cf == null) break block26;
                try (OutputStream out = Files.newOutputStream(this.moduleInfo.toPath(), new OpenOption[0]);){
                    cf.write(out);
                }
            }
            catch (IOException | IllegalArgumentException ioe) {
                if (this.failOnError) {
                    throw new BuildException((Throwable)ioe);
                }
                this.getProject().log(ioe.getMessage(), 1);
            }
        }
    }

    private static String internalName(String externalName) {
        return externalName.replace('.', '/');
    }
}

