/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.method;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AbstractProducerAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.MethodElementAnalyzer;
import org.openide.util.NbBundle;

public class ProducerMethodAnalyzer
extends AbstractProducerAnalyzer
implements MethodElementAnalyzer.MethodAnalyzer {
    @Override
    public void analyze(ExecutableElement element, TypeMirror returnType, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        if (!AnnotationUtil.hasAnnotation(element, "jakarta.enterprise.inject.Produces", result.getInfo())) {
            return;
        }
        result.requireCdiEnabled(element);
        if (cancel.get()) {
            return;
        }
        this.checkType(element, returnType, result);
        if (cancel.get()) {
            return;
        }
        this.checkSpecializes(element, result);
    }

    @Override
    protected void hasTypeVar(Element element, TypeMirror type, CdiAnalysisResult result) {
        result.addError(element, NbBundle.getMessage(ProducerMethodAnalyzer.class, (String)"ERR_ProducerReturnIsTypeVar"));
    }

    @Override
    protected void hasWildCard(Element element, TypeMirror type, CdiAnalysisResult result) {
        result.addError(element, NbBundle.getMessage(ProducerMethodAnalyzer.class, (String)"ERR_ProducerReturnHasWildcard"));
    }

    private void checkSpecializes(ExecutableElement element, CdiAnalysisResult result) {
        CompilationInfo compInfo;
        ExecutableElement overridenMethod;
        if (!AnnotationUtil.hasAnnotation(element, "jakarta.enterprise.inject.Specializes", result.getInfo())) {
            return;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.STATIC)) {
            result.addError(element, NbBundle.getMessage(ProducerMethodAnalyzer.class, (String)"ERR_StaticSpecializesProducer"));
        }
        if ((overridenMethod = (compInfo = result.getInfo()).getElementUtilities().getOverriddenMethod(element)) == null) {
            return;
        }
        TypeElement superClass = compInfo.getElementUtilities().enclosingTypeElement((Element)overridenMethod);
        TypeElement containingClass = compInfo.getElementUtilities().enclosingTypeElement((Element)element);
        TypeMirror typeDirectSuper = containingClass.getSuperclass();
        if (!superClass.equals(compInfo.getTypes().asElement(typeDirectSuper)) || !AnnotationUtil.hasAnnotation(overridenMethod, "jakarta.enterprise.inject.Produces", compInfo)) {
            result.addError(element, NbBundle.getMessage(ProducerMethodAnalyzer.class, (String)"ERR_NoDirectSpecializedProducer"));
        }
    }
}

