/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.WorkingCopyInfo;
import org.netbeans.modules.mercurial.options.AnnotationColorProvider;
import org.netbeans.modules.mercurial.ui.add.AddAction;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateAction;
import org.netbeans.modules.mercurial.ui.branch.HgBranch;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.LogAction;
import org.netbeans.modules.mercurial.ui.menu.BranchMenu;
import org.netbeans.modules.mercurial.ui.menu.ConflictsMenu;
import org.netbeans.modules.mercurial.ui.menu.DiffMenu;
import org.netbeans.modules.mercurial.ui.menu.IgnoreMenu;
import org.netbeans.modules.mercurial.ui.menu.PatchesMenu;
import org.netbeans.modules.mercurial.ui.menu.QueuesMenu;
import org.netbeans.modules.mercurial.ui.menu.RecoverMenu;
import org.netbeans.modules.mercurial.ui.menu.RemoteMenu;
import org.netbeans.modules.mercurial.ui.properties.PropertiesAction;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.ui.view.ViewAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class MercurialAnnotator
extends VCSAnnotator
implements PropertyChangeListener {
    private static final int INITIAL_ACTION_ARRAY_LENGTH = 25;
    private static final int STATUS_TEXT_ANNOTABLE = 6494;
    private static final Pattern lessThan = Pattern.compile("<");
    private static final int STATUS_BADGEABLE = 28;
    private static int STATUS_IS_IMPORTANT = 6622;
    public static final String ANNOTATION_STATUS = "status";
    public static final String ANNOTATION_FOLDER = "folder";
    public static String[] LABELS = new String[]{"status", "folder"};
    public static final String ACTIONS_PATH_PREFIX = "Actions/Mercurial/";
    private FileStatusCache cache;
    private MessageFormat format;
    private String emptyFormat;
    private static final String badgeModified = "org/netbeans/modules/mercurial/resources/icons/modified-badge.png";
    private static final String badgeConflicts = "org/netbeans/modules/mercurial/resources/icons/conflicts-badge.png";
    private static final String toolTipModified = "<img src=\"" + MercurialAnnotator.class.getClassLoader().getResource("org/netbeans/modules/mercurial/resources/icons/modified-badge.png") + "\">&nbsp;" + NbBundle.getMessage(MercurialAnnotator.class, (String)"MSG_Contains_Modified_Locally");
    private static final String toolTipConflict = "<img src=\"" + MercurialAnnotator.class.getClassLoader().getResource("org/netbeans/modules/mercurial/resources/icons/conflicts-badge.png") + "\">&nbsp;" + NbBundle.getMessage(MercurialAnnotator.class, (String)"MSG_Contains_Conflicts");
    private static final Logger LOG = Logger.getLogger(MercurialAnnotator.class.getName());
    private final Map<WorkingCopyInfo, Set<File>> filesWithRepositoryAnnotations = new HashMap<WorkingCopyInfo, Set<File>>(3);

    MercurialAnnotator(FileStatusCache cache) {
        this.cache = cache;
        this.initDefaults();
    }

    private void initDefaults() {
        this.refresh();
    }

    public void refresh() {
        String string = HgModuleConfig.getDefault().getAnnotationFormat();
        if (string != null && !string.trim().equals("")) {
            if (!HgUtils.isAnnotationFormatValid(string = HgUtils.createAnnotationFormat(string))) {
                Mercurial.LOG.log(Level.WARNING, "Bad annotation format, switching to defaults");
                string = NbBundle.getMessage(MercurialAnnotator.class, (String)"MercurialAnnotator.defaultFormat");
            }
            this.format = new MessageFormat(string);
            this.emptyFormat = this.format.format(new String[]{"", "", ""}, new StringBuffer(), (FieldPosition)null).toString().trim();
        }
    }

    public String annotateName(String name, VCSContext context) {
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.markAsSeenInUI(file);
            int status = info.getStatus();
            if ((status & STATUS_IS_IMPORTANT) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
            folderAnnotation = file.isDirectory();
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        if (mostImportantInfo == null) {
            return null;
        }
        return folderAnnotation ? this.annotateFolderNameHtml(name, context, mostImportantInfo, mostImportantFile) : this.annotateNameHtml(name, mostImportantInfo, mostImportantFile);
    }

    public Image annotateIcon(Image icon, VCSContext context) {
        boolean folderAnnotation = false;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "annotateIcon(): for {0}", new Object[]{context.getRootFiles()});
        }
        for (File file : context.getRootFiles()) {
            if (!file.isDirectory()) continue;
            folderAnnotation = true;
            break;
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        icon = !folderAnnotation ? this.annotateFileIcon(context, icon) : this.annotateFolderIcon(context, icon);
        return this.addToolTip(icon, context);
    }

    private Image annotateFileIcon(VCSContext context, Image icon) throws IllegalArgumentException {
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.markAsSeenInUI(file);
            int status = info.getStatus();
            if ((status & STATUS_IS_IMPORTANT) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
        }
        if (mostImportantInfo == null) {
            return icon;
        }
        String statusText = null;
        int status = mostImportantInfo.getStatus();
        if (0 != (status & 2)) {
            statusText = this.getAnnotationProvider().EXCLUDED_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x800)) {
            statusText = this.getAnnotationProvider().DELETED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x100)) {
            statusText = this.getAnnotationProvider().REMOVED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 4)) {
            statusText = this.getAnnotationProvider().NEW_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x1000)) {
            FileStatus fileStatus = mostImportantInfo.getStatus(mostImportantFile);
            statusText = fileStatus != null && fileStatus.isCopied() ? (!EventQueue.isDispatchThread() && !fileStatus.getOriginalFile().exists() ? this.getAnnotationProvider().MOVED_LOCALY_FILE_TOOLTIP : this.getAnnotationProvider().COPIED_LOCALLY_FILE_TOOLTIP).getFormat().format(new Object[]{mostImportantInfo.getStatusText()}) : this.getAnnotationProvider().ADDED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x10)) {
            statusText = this.getAnnotationProvider().MODIFIED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 8)) {
            statusText = null;
        } else if (0 != (status & 0x40)) {
            statusText = this.getAnnotationProvider().CONFLICT_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 1)) {
            statusText = null;
        } else if (status == 0) {
            statusText = null;
        } else {
            throw new IllegalArgumentException("Uncomparable status: " + status);
        }
        return statusText != null ? ImageUtilities.addToolTipToImage((Image)icon, (String)statusText) : icon;
    }

    private Image annotateFolderIcon(VCSContext context, Image icon) {
        boolean isVersioned = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.markAsSeenInUI(file);
            if (info == null || (info.getStatus() & 0x1C) == 0) continue;
            isVersioned = true;
            break;
        }
        if (!isVersioned) {
            return icon;
        }
        Image badge = null;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "annotateFolderIcon(): for {0}", new Object[]{context.getRootFiles()});
        }
        if (this.cache.containsFileOfStatus(context, 64, true)) {
            badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeConflicts, (boolean)true), (String)toolTipConflict);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "annotateFolderIcon(): contains conflict");
            }
        } else if (this.cache.containsFileOfStatus(context, 6612, true)) {
            badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeModified, (boolean)true), (String)toolTipModified);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "annotateFolderIcon(): contains local change");
            }
        }
        if (badge != null) {
            return ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
        }
        return icon;
    }

    public Action[] getActions(VCSContext ctx, VCSAnnotator.ActionDestination destination) {
        ResourceBundle loc = NbBundle.getBundle(MercurialAnnotator.class);
        Node[] nodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
        Set files = ctx.getRootFiles();
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        boolean noneVersioned = roots == null || roots.isEmpty();
        ArrayList<Action> actions = new ArrayList<Action>(25);
        if (destination == VCSAnnotator.ActionDestination.MainMenu) {
            if (noneVersioned) {
                Action a = Utils.getAcceleratedAction((String)"Actions/Mercurial/org-netbeans-modules-mercurial-ui-create-CreateAction.instance");
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(Lookups.fixed((Object[])files.toArray()));
                }
                if (a != null) {
                    actions.add(a);
                }
                if ((a = Utils.getAcceleratedAction((String)"Actions/Mercurial/org-netbeans-modules-mercurial-ui-clone-CloneExternalAction.instance")) != null) {
                    actions.add(a);
                }
            } else {
                actions.add((Action)SystemAction.get(StatusAction.class));
                actions.add(new DiffMenu(null));
                actions.add((Action)SystemAction.get(AddAction.class));
                actions.add((Action)SystemAction.get(CommitAction.class));
                actions.add((Action)SystemAction.get(UpdateAction.class));
                actions.add((Action)SystemAction.get(RevertModificationsAction.class));
                actions.add((Action)SystemAction.get(AnnotateAction.class));
                actions.add((Action)SystemAction.get(LogAction.class));
                actions.add(new ConflictsMenu(null));
                actions.add(null);
                actions.add(new IgnoreMenu(null, null));
                actions.add(new PatchesMenu(null));
                actions.add(null);
                actions.add(new BranchMenu(null));
                actions.add(new QueuesMenu(null));
                actions.add(new RemoteMenu(null));
                actions.add(new RecoverMenu(null));
                actions.add(null);
                actions.add((Action)SystemAction.get(ViewAction.class));
                actions.add((Action)SystemAction.get(PropertiesAction.class));
            }
            Utils.setAcceleratorBindings((String)ACTIONS_PATH_PREFIX, (Action[])actions.toArray(new Action[0]));
        } else {
            Lookup context = ctx.getElements();
            if (noneVersioned) {
                Action a = Actions.forID((String)"Mercurial", (String)"org.netbeans.modules.mercurial.ui.create.CreateAction");
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(Lookups.fixed((Object[])files.toArray()));
                }
                if (a != null) {
                    actions.add(a);
                }
            } else {
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)loc.getString("CTL_PopupMenuItem_Status"), (Lookup)context));
                actions.add(new DiffMenu(context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(AddAction.class), (String)NbBundle.getMessage(AddAction.class, (String)"CTL_PopupMenuItem_Add"), (Lookup)context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)loc.getString("CTL_PopupMenuItem_Commit"), (Lookup)context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(UpdateAction.class), (String)loc.getString("CTL_PopupMenuItem_Update"), (Lookup)context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(RevertModificationsAction.class), (String)loc.getString("CTL_PopupMenuItem_Revert"), (Lookup)context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(AnnotateAction.class), (String)(((AnnotateAction)SystemAction.get(AnnotateAction.class)).visible(nodes) ? loc.getString("CTL_PopupMenuItem_HideAnnotations") : loc.getString("CTL_PopupMenuItem_ShowAnnotations")), (Lookup)context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(LogAction.class), (String)loc.getString("CTL_PopupMenuItem_Log"), (Lookup)context));
                actions.add(new ConflictsMenu(context));
                actions.add(null);
                actions.add(new IgnoreMenu(context, ctx));
                actions.add(new PatchesMenu(context));
                actions.add(null);
                actions.add(new BranchMenu(context, ctx));
                actions.add(new QueuesMenu(context));
                actions.add(new RemoteMenu(context));
                actions.add(new RecoverMenu(context));
                actions.add(null);
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(PropertiesAction.class), (String)loc.getString("CTL_PopupMenuItem_Properties"), (Lookup)context));
            }
        }
        return actions.toArray(new Action[0]);
    }

    private String formatAnnotation(FileInformation info, File file) {
        Object[] arguments;
        String annotation;
        String stickyString;
        String statusString = "";
        int status = info.getStatus();
        if (status != 8) {
            statusString = info.getShortStatusText();
        }
        if ((stickyString = null) == null) {
            stickyString = "";
        }
        if ((annotation = this.format.format(arguments = new Object[]{statusString, stickyString}, new StringBuffer(), (FieldPosition)null).toString().trim()).equals(this.emptyFormat)) {
            return "";
        }
        return " " + annotation;
    }

    public String annotateNameHtml(File file, FileInformation info) {
        return this.annotateNameHtml(file.getName(), info, file);
    }

    public String annotateNameHtml(String name, FileInformation mostImportantInfo, File mostImportantFile) {
        String textAnnotation;
        name = this.htmlEncode(name);
        boolean annotationsVisible = VersioningSupport.isTextAnnotationVisible();
        int status = mostImportantInfo.getStatus();
        if (annotationsVisible && mostImportantFile != null && (status & 0x195E) != 0) {
            if (this.format != null) {
                textAnnotation = this.formatAnnotation(mostImportantInfo, mostImportantFile);
            } else {
                String statusText;
                String sticky = null;
                textAnnotation = status == 8 && sticky == null ? "" : (status == 8 ? " [" + sticky + "]" : (sticky == null ? (!(statusText = mostImportantInfo.getShortStatusText()).equals("") ? " [" + mostImportantInfo.getShortStatusText() + "]" : "") : " [" + mostImportantInfo.getShortStatusText() + "; " + sticky + "]"));
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = this.getAnnotationProvider().TEXT_ANNOTATION.getFormat().format(new Object[]{textAnnotation});
        }
        if (0 != (status & 2)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x800)) {
            return this.getAnnotationProvider().DELETED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x100)) {
            return this.getAnnotationProvider().REMOVED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 4)) {
            return this.getAnnotationProvider().NEW_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x1000)) {
            FileStatus fileStatus = mostImportantInfo.getStatus(mostImportantFile);
            if (fileStatus != null && fileStatus.isCopied()) {
                return (!EventQueue.isDispatchThread() && !fileStatus.getOriginalFile().exists() ? this.getAnnotationProvider().MOVED_LOCALY_FILE : this.getAnnotationProvider().COPIED_LOCALLY_FILE).getFormat().format(new Object[]{name, textAnnotation});
            }
            return this.getAnnotationProvider().ADDED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x10)) {
            return this.getAnnotationProvider().MODIFIED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 8)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x40)) {
            return this.getAnnotationProvider().CONFLICT_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 1)) {
            return name;
        }
        if (status == 0) {
            return name;
        }
        throw new IllegalArgumentException("Uncomparable status: " + status);
    }

    public Color getAnnotatedColor(FileInformation mostImportantInfo) {
        int status = mostImportantInfo.getStatus();
        if (0 != (status & 2)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getActualColor();
        }
        if (0 != (status & 0x800)) {
            return this.getAnnotationProvider().DELETED_LOCALLY_FILE.getActualColor();
        }
        if (0 != (status & 0x100)) {
            return this.getAnnotationProvider().REMOVED_LOCALLY_FILE.getActualColor();
        }
        if (0 != (status & 4)) {
            return this.getAnnotationProvider().NEW_LOCALLY_FILE.getActualColor();
        }
        if (0 != (status & 0x1000)) {
            FileStatus fileStatus = mostImportantInfo.getStatus(null);
            if (fileStatus != null && fileStatus.isCopied()) {
                return (!EventQueue.isDispatchThread() && !fileStatus.getOriginalFile().exists() ? this.getAnnotationProvider().MOVED_LOCALY_FILE : this.getAnnotationProvider().COPIED_LOCALLY_FILE).getActualColor();
            }
            return this.getAnnotationProvider().ADDED_LOCALLY_FILE.getActualColor();
        }
        if (0 != (status & 0x10)) {
            return this.getAnnotationProvider().MODIFIED_LOCALLY_FILE.getActualColor();
        }
        if (0 != (status & 8)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getActualColor();
        }
        if (0 != (status & 0x40)) {
            return this.getAnnotationProvider().CONFLICT_FILE.getActualColor();
        }
        return null;
    }

    private String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    private String annotateFolderNameHtml(String name, VCSContext context, FileInformation mostImportantInfo, File mostImportantFile) {
        String nameHtml = this.htmlEncode(name);
        if (mostImportantInfo.getStatus() == 2) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{nameHtml, ""});
        }
        boolean annotationsVisible = VersioningSupport.isTextAnnotationVisible();
        MessageFormat uptodateFormat = this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat();
        Set rootFiles = context.getRootFiles();
        File repo = null;
        String folderAnotation = "";
        File root = null;
        boolean isRepoRoot = false;
        if (rootFiles.size() == 1) {
            File file = (File)rootFiles.iterator().next();
            repo = Mercurial.getInstance().getRepositoryRoot(file);
            if (repo == null) {
                Mercurial.LOG.log(Level.WARNING, "Couldn''t find repository root for file {0}", file);
            } else {
                root = file;
                isRepoRoot = repo.equals(root);
            }
            if (repo == null || !isRepoRoot) {
                return uptodateFormat.format(new Object[]{nameHtml, ""});
            }
        } else {
            File parentFile = null;
            for (File file : rootFiles) {
                if (parentFile == null) {
                    parentFile = file.getParentFile();
                    continue;
                }
                File p = file.getParentFile();
                if (p != null && parentFile.equals(p)) continue;
                return uptodateFormat.format(new Object[]{nameHtml, ""});
            }
            for (File file : rootFiles) {
                repo = Mercurial.getInstance().getRepositoryRoot(file);
                if (repo == null) {
                    Mercurial.LOG.log(Level.WARNING, "Couldn''t find repository root for file {0}", file);
                    continue;
                }
                root = file;
                break;
            }
            boolean bl = isRepoRoot = parentFile != null && parentFile.equals(repo);
        }
        if (annotationsVisible && repo != null) {
            if (isRepoRoot && !repo.getName().equals(name)) {
                folderAnotation = repo.getName();
            }
            WorkingCopyInfo info = WorkingCopyInfo.getInstance(repo);
            this.addFileWithRepositoryAnnotation(info, root);
            HgLogMessage[] parents = info.getWorkingCopyParents();
            StringBuilder label = new StringBuilder();
            if (parents.length == 1) {
                HgLogMessage parent = parents[0];
                for (String b : parent.getBranches()) {
                    label.append(b);
                }
                if (label.length() == 0) {
                    label.append(HgBranch.DEFAULT_NAME);
                }
                if (parent.getTags().length == 0) {
                    label.append(' ').append(parent.getCSetShortID().substring(0, Math.min(7, parent.getCSetShortID().length())));
                } else {
                    for (String b : parent.getTags()) {
                        label.append(' ').append(b);
                    }
                }
            } else if (parents.length > 1) {
                String b2;
                String b1 = parents[0].getBranches().length == 0 ? HgBranch.DEFAULT_NAME : parents[0].getBranches()[0];
                String string = b2 = parents[1].getBranches().length == 0 ? HgBranch.DEFAULT_NAME : parents[1].getBranches()[0];
                if (b1.equals(b2)) {
                    label.append(NbBundle.getMessage(MercurialAnnotator.class, (String)"LBL_Annotator.label.merged.oneBranch", (Object[])new Object[]{parents[0].getCSetShortID().substring(0, Math.min(7, parents[0].getCSetShortID().length())), parents[1].getCSetShortID().substring(0, Math.min(7, parents[1].getCSetShortID().length())), b1}));
                } else {
                    label.append(NbBundle.getMessage(MercurialAnnotator.class, (String)"LBL_Annotator.label.merged.twoBranches", (Object[])new Object[]{b1, b2}));
                }
            }
            if (!folderAnotation.isEmpty() && label.length() > 0) {
                label.insert(0, ", ");
            }
            label.insert(0, folderAnotation);
            folderAnotation = label.toString();
        }
        return uptodateFormat.format(new Object[]{nameHtml, folderAnotation.isEmpty() ? "" : this.getAnnotationProvider().TEXT_ANNOTATION.getFormat().format(new Object[]{" [" + folderAnotation + "]"})});
    }

    private boolean isMoreImportant(FileInformation a, FileInformation b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return MercurialAnnotator.getComparableStatus(a.getStatus()) < MercurialAnnotator.getComparableStatus(b.getStatus());
    }

    public static int getComparableStatus(int status) {
        if (0 != (status & 0x40)) {
            return 0;
        }
        if (0 != (status & 0x80)) {
            return 1;
        }
        if (0 != (status & 0x800)) {
            return 10;
        }
        if (0 != (status & 0x100)) {
            return 11;
        }
        if (0 != (status & 4)) {
            return 12;
        }
        if (0 != (status & 0x1000)) {
            return 13;
        }
        if (0 != (status & 0x10)) {
            return 14;
        }
        if (0 != (status & 0x400)) {
            return 30;
        }
        if (0 != (status & 0x200)) {
            return 31;
        }
        if (0 != (status & 0x20)) {
            return 32;
        }
        if (0 != (status & 8)) {
            return 50;
        }
        if (0 != (status & 2)) {
            return 100;
        }
        if (0 != (status & 1)) {
            return 101;
        }
        if (status == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + status);
    }

    private AnnotationColorProvider getAnnotationProvider() {
        return AnnotationColorProvider.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileWithRepositoryAnnotation(WorkingCopyInfo info, File file) {
        info.removePropertyChangeListener(this);
        info.addPropertyChangeListener(this);
        Map<WorkingCopyInfo, Set<File>> map = this.filesWithRepositoryAnnotations;
        synchronized (map) {
            Set<File> files = this.filesWithRepositoryAnnotations.get(info);
            if (files == null) {
                files = new HashSet<File>();
                this.filesWithRepositoryAnnotations.put(info, files);
            }
            files.add(file);
        }
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (WorkingCopyInfo.PROPERTY_WORKING_COPY_PARENT.equals(evt.getPropertyName())) {
            Utils.post((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set filesToRefresh;
                    WorkingCopyInfo info = (WorkingCopyInfo)evt.getSource();
                    Map map = MercurialAnnotator.this.filesWithRepositoryAnnotations;
                    synchronized (map) {
                        filesToRefresh = (Set)MercurialAnnotator.this.filesWithRepositoryAnnotations.remove(info);
                    }
                    if (filesToRefresh != null && !filesToRefresh.isEmpty()) {
                        Mercurial.getInstance().refreshAnnotations(filesToRefresh);
                    }
                }
            }, (int)400);
        }
    }

    private Image addToolTip(Image icon, VCSContext context) {
        if (!VersioningSupport.isTextAnnotationVisible()) {
            return icon;
        }
        File root = null;
        File repository = null;
        for (File f : context.getRootFiles()) {
            File repo = Mercurial.getInstance().getRepositoryRoot(f);
            if (repo == null) continue;
            if (repository == null) {
                repository = repo;
                root = f;
                continue;
            }
            if (repository.equals(repo)) continue;
            return icon;
        }
        if (repository != null) {
            WorkingCopyInfo info = WorkingCopyInfo.getInstance(repository);
            this.addFileWithRepositoryAnnotation(info, root);
            HgLogMessage[] parents = info.getWorkingCopyParents();
            String label = null;
            if (parents.length == 1) {
                HgLogMessage parent = parents[0];
                String branchName = null;
                String[] stringArray = parent.getBranches();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String b;
                    branchName = b = stringArray[i];
                }
                if (branchName != null) {
                    label = NbBundle.getMessage(MercurialAnnotator.class, (String)"LBL_Annotator.currentBranch.toolTip", (Object)branchName);
                }
            } else if (parents.length > 1) {
                String b1 = parents[0].getBranches().length == 0 ? HgBranch.DEFAULT_NAME : parents[0].getBranches()[0];
                String b2 = parents[1].getBranches().length == 0 ? HgBranch.DEFAULT_NAME : parents[1].getBranches()[0];
                label = b1.equals(b2) ? NbBundle.getMessage(MercurialAnnotator.class, (String)"LBL_Annotator.mergeNeeded.oneBranch.toolTip", (Object[])new Object[]{parents[0].getCSetShortID().substring(0, Math.min(7, parents[0].getCSetShortID().length())), parents[1].getCSetShortID().substring(0, Math.min(7, parents[1].getCSetShortID().length())), b1}) : NbBundle.getMessage(MercurialAnnotator.class, (String)"LBL_Annotator.mergeNeeded.twoBranches.toolTip", (Object[])new Object[]{b1, b2});
            }
            if (label != null) {
                icon = ImageUtilities.addToolTipToImage((Image)icon, (String)label.toString());
            }
        }
        return icon;
    }
}

