/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.spi.templates.completion.CompletionProvider;
import org.openide.filesystems.FileObject;

public final class PhpTypeCompletionProviderWrapper
implements CompletionProvider {
    public Set<String> getItems(FileObject sourceFile, String prefix) {
        return PhpTypeCompletionProvider.getInstance().getItems(sourceFile, prefix);
    }

    public static final class PhpTypeCompletionProvider
    implements CompletionProvider {
        private static final PhpTypeCompletionProvider INSTANCE = new PhpTypeCompletionProvider();
        private Set<TypeElement> cachedElements;

        private PhpTypeCompletionProvider() {
        }

        public static PhpTypeCompletionProvider getInstance() {
            return INSTANCE;
        }

        public Set<String> getItems(FileObject sourceFile, String prefix) {
            HashSet<String> result = new HashSet<String>();
            for (TypeElement typeElement : ElementFilter.forName(NameKind.prefix(prefix)).filter(this.getElements(sourceFile))) {
                if (CodeUtils.isSyntheticTypeName(typeElement.getName())) continue;
                result.add(typeElement.getFullyQualifiedName().toString());
            }
            return result;
        }

        private synchronized Set<TypeElement> getElements(FileObject fileObject) {
            if (this.cachedElements == null) {
                ElementQuery.Index indexQuery = ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(fileObject));
                this.cachedElements = indexQuery.getTypes(NameKind.empty());
            }
            return this.cachedElements;
        }

        public synchronized void clearCache() {
            this.cachedElements = null;
        }
    }
}

