/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.typinghooks;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.php.editor.indent.IndentUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.typinghooks.TypingHooksUtils;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class PhpTypedTextInterceptor
implements TypedTextInterceptor {
    private static final Logger LOGGER = Logger.getLogger(PhpTypedTextInterceptor.class.getName());
    private int previousAdjustmentOffset = -1;
    private boolean isAfter;
    private int previousAdjustmentIndent;
    private boolean codeTemplateEditing;
    private boolean bracketCompleted;

    public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        TokenSequence<PHPTokenId> ts;
        this.isAfter = false;
        this.codeTemplateEditing = false;
        this.bracketCompleted = false;
        Document document = context.getDocument();
        BaseDocument doc = (BaseDocument)document;
        int caretOffset = context.getOffset();
        char ch = context.getText().charAt(0);
        if (this.doNotAutoComplete(ch) || caretOffset == 0) {
            return;
        }
        String selection = context.getReplacedText();
        if (selection != null && selection.length() > 0) {
            TokenSequence<? extends PHPTokenId> ts2;
            char firstChar;
            this.codeTemplateEditing = GsfUtilities.isCodeTemplateEditing((Document)doc);
            if (!(this.codeTemplateEditing || ch != '\"' && ch != '\'' && ch != '(' && ch != '{' && ch != '[' || (firstChar = selection.charAt(0)) == ch || (ts2 = LexUtilities.getPositionedSequence(doc, caretOffset)) == null || TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)ts2.token()) && firstChar != '\"' && firstChar != '\'')) {
                char lastChar = selection.charAt(selection.length() - 1);
                if (selection.length() > 1 && (firstChar == '\"' || firstChar == '\'' || firstChar == '(' || firstChar == '{' || firstChar == '[') && lastChar == this.matching(firstChar)) {
                    String innerText = selection.substring(1, selection.length() - 1);
                    String text = Character.toString(ch) + innerText + Character.toString(this.matching(ch));
                    context.setText(text, text.length());
                    this.bracketCompleted = true;
                    return;
                } else if (selection.length() == 1 && (firstChar == '\"' || firstChar == '\'')) {
                    if (ts2.token().id() != PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING) return;
                    String original = ts2.token().text().toString();
                    if (original.length() <= 1) return;
                    String text = ch + original.substring(1, original.length() - 1) + ch;
                    doc.remove(ts2.offset(), text.length());
                    context.setText(text, text.length() - 1);
                    return;
                } else {
                    String text = ch + selection + this.matching(ch);
                    context.setText(text, text.length());
                    this.bracketCompleted = true;
                }
                return;
            }
        }
        if ((ts = LexUtilities.getPHPTokenSequence((Document)doc, caretOffset)) == null) {
            return;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return;
        }
        Token token = ts.token();
        TokenId id = token.id();
        if (id == PHPTokenId.PHP_LINE_COMMENT && selection != null && selection.length() > 0 && (ch == '*' || ch == '+' || ch == '_') && selection.charAt(0) != ch && selection.indexOf(32) == -1) {
            String text = ch + selection + this.matching(ch);
            context.setText(text, text.length());
            return;
        }
        if (ch != '\"' && ch != '\'') return;
        this.completeQuote(context);
    }

    public void afterInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
        BaseDocument doc = (BaseDocument)context.getDocument();
        doc.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                try {
                    PhpTypedTextInterceptor.this.afterInsertUnderWriteLock(context);
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
            }
        });
    }

    private void afterInsertUnderWriteLock(TypedTextInterceptor.Context context) throws BadLocationException {
        this.isAfter = true;
        JTextComponent target = context.getComponent();
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)context.getDocument();
        int dotPos = context.getOffset();
        char ch = context.getText().charAt(0);
        if (this.previousAdjustmentOffset != -1) {
            TokenSequence<PHPTokenId> ts;
            if (dotPos == this.previousAdjustmentOffset && (ts = LexUtilities.getPHPTokenSequence((Document)doc, dotPos)) != null) {
                ts.move(dotPos);
                if (ts.moveNext() && ts.offset() < dotPos) {
                    GsfUtilities.setLineIndentation((Document)doc, (int)dotPos, (int)this.previousAdjustmentIndent);
                }
            }
            this.previousAdjustmentOffset = -1;
        }
        switch (ch) {
            case '\t': 
            case ' ': 
            case '(': 
            case ')': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                if (!TypingHooksUtils.isInsertMatchingEnabled() && ch != '{' && ch != '}') {
                    return;
                }
                Token<? extends PHPTokenId> token = LexUtilities.getToken(doc, dotPos);
                if (token == null) {
                    return;
                }
                TokenId id = token.id();
                if (id == PHPTokenId.PHP_VARIABLE && token.length() == 1 || LexUtilities.textEquals(token.text(), '[') || LexUtilities.textEquals(token.text(), ']') || LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), ')') || id == PHPTokenId.PHP_ATTRIBUTE) {
                    if (ch == ']' || ch == ')') {
                        this.skipClosingBracket(doc, caret, ch);
                    } else if (ch == '[' || ch == '(') {
                        this.completeOpeningBracket(doc, dotPos, caret, ch);
                    }
                } else if (id == PHPTokenId.PHP_CASTING && ch == ')') {
                    this.skipClosingBracket(doc, caret, ch);
                }
                if (ch == '}') {
                    this.reindent(doc, dotPos, PHPTokenId.PHP_CURLY_CLOSE, caret);
                    break;
                }
                if (ch == '{') {
                    this.reindent(doc, dotPos, PHPTokenId.PHP_CURLY_OPEN, caret);
                    break;
                }
                if (ch == '\t' || ch == ' ') {
                    this.reindent(doc, dotPos, PHPTokenId.WHITESPACE, caret);
                    break;
                }
                if (ch != ':') break;
                this.reindent(doc, dotPos, PHPTokenId.PHP_TOKEN, caret);
                break;
            }
        }
    }

    public void cancelled(TypedTextInterceptor.Context context) {
    }

    private boolean doNotAutoComplete(char ch) {
        return !TypingHooksUtils.isInsertMatchingEnabled() && this.isBracket(ch) || this.isQuote(ch) && !OptionsUtils.autoCompletionSmartQuotes();
    }

    private boolean isBracket(char ch) {
        return this.isOpeningBracket(ch) || this.isClosingBracket(ch);
    }

    private boolean isOpeningBracket(char ch) {
        return ch == '(' || ch == '{' || ch == '[';
    }

    private boolean isClosingBracket(char ch) {
        return ch == ')' || ch == '}' || ch == ']';
    }

    private boolean isQuote(char ch) {
        return ch == '\"' || ch == '\'';
    }

    private boolean isQuote(Token<? extends PHPTokenId> token) {
        return this.isQuote(token.text().charAt(0));
    }

    private char matching(char bracket) {
        switch (bracket) {
            case '(': {
                return ')';
            }
            case '/': {
                return '/';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
        }
        return bracket;
    }

    private void completeQuote(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        Token previousToken;
        int dotPos = context.getOffset();
        BaseDocument doc = (BaseDocument)context.getDocument();
        char bracket = context.getText().charAt(0);
        if (this.codeTemplateEditing) {
            String text = context.getText() + bracket;
            context.setText(text, text.length() - 1);
            return;
        }
        if (this.isEscapeSequence(doc, dotPos)) {
            return;
        }
        Object[] result = PhpTypedTextInterceptor.findPhpSectionBoundaries(doc, dotPos, true);
        if (result == null) {
            return;
        }
        TokenSequence ts = (TokenSequence)result[0];
        int sectionEnd = (Integer)result[2];
        boolean onlyWhitespaceFollows = (Boolean)result[4];
        Token token = ts.token();
        if (token == null) {
            return;
        }
        Token token2 = previousToken = ts.movePrevious() ? ts.token() : null;
        if (token.id() == PHPTokenId.PHP_COMMENT || token.id() == PHPTokenId.PHP_LINE_COMMENT || token.id() == PHPTokenId.PHPDOC_COMMENT || token.id() == PHPTokenId.T_INLINE_HTML) {
            return;
        }
        boolean insideString = TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)token);
        if (!insideString && onlyWhitespaceFollows && previousToken != null && TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)previousToken)) {
            insideString = true;
        }
        if (insideString) {
            char chr;
            if (!onlyWhitespaceFollows && (chr = doc.getChars(dotPos, 1)[0]) == bracket) {
                if (!this.isAfter) {
                    String text = "" + bracket;
                    context.setText(text, text.length());
                }
                doc.remove(dotPos, 1);
            }
        } else {
            int firstNonWhiteFwd;
            boolean insert = onlyWhitespaceFollows;
            if (!insert && (firstNonWhiteFwd = LineDocumentUtils.getNextNonWhitespace((LineDocument)doc, (int)dotPos, (int)sectionEnd)) != -1) {
                char chr = doc.getChars(firstNonWhiteFwd, 1)[0];
                boolean bl = insert = (chr == ')' || chr == ',' || chr == '+' || chr == '}' || chr == ';' || chr == ']' || chr == '.') && !TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)previousToken) && !this.isQuote((Token<? extends PHPTokenId>)token);
            }
            if (insert) {
                String text = "" + bracket + (this.isAfter ? "" : Character.valueOf(this.matching(bracket)));
                context.setText(text, this.isAfter ? text.length() : text.length() - 1);
            }
        }
    }

    private boolean isEscapeSequence(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos <= 0) {
            return false;
        }
        char previousChar = doc.getChars(dotPos - 1, 1)[0];
        return previousChar == '\\';
    }

    private static Object[] findPhpSectionBoundaries(BaseDocument doc, int offset, boolean currentLineOnly) {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        int lowest = 0;
        int highest = doc.getLength();
        if (currentLineOnly) {
            lowest = doc.getParagraphElement(offset).getStartOffset();
            highest = Math.max(doc.getParagraphElement(offset).getEndOffset() - 1, lowest);
        }
        int sectionEnd = highest;
        boolean onlyWhitespaceFollows = true;
        while (highest >= ts.offset()) {
            if (ts.token().id() == PHPTokenId.PHP_CLOSETAG) {
                sectionEnd = ts.offset();
                break;
            }
            if (ts.token().id() != PHPTokenId.WHITESPACE) {
                onlyWhitespaceFollows = false;
            }
            if (ts.moveNext()) continue;
        }
        int sectionStart = lowest;
        boolean onlyWhitespacePreceeds = true;
        while (ts.movePrevious() && lowest <= ts.offset()) {
            if (ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                sectionStart = ts.offset();
                break;
            }
            if (ts.token().id() == PHPTokenId.WHITESPACE) continue;
            onlyWhitespacePreceeds = false;
        }
        ts.move(offset);
        if (!ts.moveNext()) assert (ts.movePrevious());
        assert (sectionStart != -1 && sectionEnd != -1) : "sectionStart=" + sectionStart + ", sectionEnd=" + sectionEnd;
        return new Object[]{ts, sectionStart, sectionEnd, onlyWhitespacePreceeds, onlyWhitespaceFollows};
    }

    private void reindent(BaseDocument doc, int offset, TokenId id, Caret caret) throws BadLocationException {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts != null) {
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return;
            }
            Token token = ts.token();
            if (token.id() == id) {
                OffsetRange begin;
                int rowFirstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
                if (id == PHPTokenId.PHP_CURLY_OPEN && ts.offset() == rowFirstNonWhite && ts.movePrevious()) {
                    int previousExprestion = LexUtilities.findStartTokenOfExpression(ts);
                    int previousIndent = Utilities.getRowIndent((BaseDocument)doc, (int)previousExprestion);
                    int currentIndent = Utilities.getRowIndent((BaseDocument)doc, (int)offset);
                    int newIndent = IndentUtils.countIndent(doc, offset, previousIndent);
                    if (newIndent != currentIndent) {
                        GsfUtilities.setLineIndentation((Document)doc, (int)offset, (int)Math.max(newIndent, 0));
                    }
                } else if (id == PHPTokenId.WHITESPACE || id == PHPTokenId.PHP_TOKEN && token.text().charAt(0) == ':') {
                    Token<? extends PHPTokenId> firstCaseInSwitch;
                    Token<? extends PHPTokenId> previousToken = null;
                    if (id == PHPTokenId.WHITESPACE) {
                        previousToken = LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_CASE, PHPTokenId.PHP_TOKEN));
                    } else if (ts.movePrevious()) {
                        previousToken = LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_DEFAULT, PHPTokenId.PHP_TOKEN));
                    }
                    if (ts.offset() >= rowFirstNonWhite && previousToken != null && (previousToken.id() == PHPTokenId.PHP_CASE || previousToken.id() == PHPTokenId.PHP_DEFAULT) && (previousToken = LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_SWITCH))) != null && previousToken.id() == PHPTokenId.PHP_SWITCH && (firstCaseInSwitch = LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_CASE))) != null && firstCaseInSwitch.id() == PHPTokenId.PHP_CASE) {
                        int indentOfFirstCase = GsfUtilities.getLineIndent((Document)doc, (int)ts.offset());
                        GsfUtilities.setLineIndentation((Document)doc, (int)offset, (int)indentOfFirstCase);
                    }
                } else if (id == PHPTokenId.PHP_CURLY_CLOSE && (begin = LexUtilities.findBwd(doc, ts, PHPTokenId.PHP_CURLY_OPEN, '{', PHPTokenId.PHP_CURLY_CLOSE, '}')) != OffsetRange.NONE) {
                    int beginOffset = begin.getStart();
                    int indent = GsfUtilities.getLineIndent((Document)doc, (int)beginOffset);
                    this.previousAdjustmentIndent = GsfUtilities.getLineIndent((Document)doc, (int)offset);
                    GsfUtilities.setLineIndentation((Document)doc, (int)offset, (int)indent);
                    this.previousAdjustmentOffset = caret.getDot();
                }
            }
        }
    }

    private void skipClosingBracket(BaseDocument doc, Caret caret, char bracket) throws BadLocationException {
        int caretOffset = caret.getDot();
        if (this.isSkipClosingBracket(doc, caretOffset, bracket)) {
            doc.remove(caretOffset - 1, 1);
            caret.setDot(caretOffset);
        }
    }

    private boolean isSkipClosingBracket(BaseDocument doc, int caretOffset, char bracket) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return false;
        }
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, caretOffset);
        if (ts == null) {
            return false;
        }
        ts.move(caretOffset);
        if (!ts.moveNext()) {
            return false;
        }
        Token token = ts.token();
        boolean skipClosingBracket = false;
        if (token != null && LexUtilities.textEquals(token.text(), bracket)) {
            char leftBracket = bracket == ')' ? (char)'(' : (bracket == ']' ? (char)'[' : '{');
            int bracketBalanceWithNewBracket = 0;
            ts.moveStart();
            if (!ts.moveNext()) {
                return false;
            }
            token = ts.token();
            while (token != null) {
                if (token.id() == PHPTokenId.PHP_TOKEN) {
                    if (LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), '[')) {
                        if (LexUtilities.textEquals(token.text(), leftBracket)) {
                            ++bracketBalanceWithNewBracket;
                        }
                    } else if ((LexUtilities.textEquals(token.text(), ')') || LexUtilities.textEquals(token.text(), ']')) && LexUtilities.textEquals(token.text(), bracket)) {
                        --bracketBalanceWithNewBracket;
                    }
                }
                if (!ts.moveNext()) break;
                token = ts.token();
            }
            skipClosingBracket = bracketBalanceWithNewBracket != 0;
        }
        return skipClosingBracket;
    }

    private void completeOpeningBracket(BaseDocument doc, int dotPos, Caret caret, char bracket) throws BadLocationException {
        if (!this.bracketCompleted && this.isCompletablePosition(doc, dotPos + 1)) {
            String matchingBracket = "" + this.matching(bracket);
            doc.insertString(dotPos + 1, matchingBracket, null);
            caret.setDot(dotPos + 1);
        }
    }

    private boolean isCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        char chr = doc.getChars(dotPos, 1)[0];
        return chr == ')' || chr == ',' || chr == '\"' || chr == '\'' || chr == ' ' || chr == ']' || chr == '}' || chr == '\n' || chr == '\t' || chr == ';';
    }

    public static class Factory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new PhpTypedTextInterceptor();
        }
    }
}

