/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.payara.common.CommonServerSupport;
import org.netbeans.modules.payara.common.CreateDomain;
import org.netbeans.modules.payara.common.LogViewMgr;
import org.netbeans.modules.payara.common.PayaraInstanceProvider;
import org.netbeans.modules.payara.common.PayaraJvmMode;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.common.PayaraState;
import org.netbeans.modules.payara.common.PortCollection;
import org.netbeans.modules.payara.common.nodes.Hk2InstanceNode;
import org.netbeans.modules.payara.common.parser.DomainXMLChangeListener;
import org.netbeans.modules.payara.common.ui.PayaraPropertiesCustomizer;
import org.netbeans.modules.payara.common.ui.WarnPanel;
import org.netbeans.modules.payara.common.utils.ServerUtils;
import org.netbeans.modules.payara.common.utils.Util;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.spi.PayaraModuleFactory;
import org.netbeans.modules.payara.spi.RemoveCookie;
import org.netbeans.modules.payara.spi.Utils;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.data.PayaraAdminInterface;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.InputOutput;

public class PayaraInstance
implements ServerInstanceImplementation,
Lookup.Provider,
LookupListener,
PayaraServer {
    private static final Logger LOGGER = PayaraLogger.get(PayaraInstance.class);
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_ADMIN_NAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWORD = "";
    public static final String OLD_DEFAULT_ADMIN_PASSWORD = "adminadmin";
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final int DEFAULT_HTTPS_PORT = 8181;
    public static final int DEFAULT_ADMIN_PORT = 4848;
    public static final int DEFAULT_DEBUG_PORT = 9009;
    static final int LOWEST_USER_PORT = Utilities.isWindows() ? 1 : 1025;
    public static final String DEFAULT_DOMAINS_FOLDER = "domains";
    public static final String DEFAULT_DOMAIN_NAME = "domain1";
    static final String INSTANCE_FO_ATTR = "InstanceFOPath";
    static final String KEYRING_NAME_SPACE = "Payara.admin";
    static final String KEYRING_NAME_SEPARATOR = ".";
    static final String KEYRING_IDENT_SEPARATOR = ":";
    private boolean removable = true;
    private transient Map<String, String> properties;
    @Deprecated
    private PayaraVersion version;
    private final PayaraPlatformVersionAPI platformVersion;
    private volatile transient Process process;
    private final transient DomainXMLChangeListener domainXMLListener;
    private transient InstanceContent ic;
    private transient Lookup localLookup;
    private transient Lookup full;
    private final transient Lookup.Result<PayaraModuleFactory> lookupResult = Lookups.forPath((String)"Servers/Payara").lookupResult(PayaraModuleFactory.class);
    private transient Collection<? extends PayaraModuleFactory> currentFactories = Collections.emptyList();
    private final transient CommonServerSupport commonSupport;
    private ServerInstance commonInstance;
    private PayaraInstanceProvider instanceProvider;
    private Node fullNode;

    public static String passwordKey(String serverName, String userName) {
        StringBuilder pwKey = new StringBuilder(KEYRING_NAME_SPACE.length() + KEYRING_NAME_SEPARATOR.length() + "password".length() + KEYRING_IDENT_SEPARATOR.length() + (serverName != null ? serverName.length() : 0) + KEYRING_IDENT_SEPARATOR.length() + (userName != null ? userName.length() : 0));
        pwKey.append(KEYRING_NAME_SPACE);
        pwKey.append(KEYRING_NAME_SEPARATOR);
        pwKey.append("password");
        pwKey.append(KEYRING_IDENT_SEPARATOR);
        pwKey.append(serverName != null ? serverName : DEFAULT_ADMIN_PASSWORD);
        pwKey.append(KEYRING_IDENT_SEPARATOR);
        pwKey.append(userName != null ? userName : DEFAULT_ADMIN_PASSWORD);
        return pwKey.toString();
    }

    public static String getPasswordFromKeyring(String serverName, String userName) {
        char[] passwordChars = Keyring.read((String)PayaraInstance.passwordKey(serverName, userName));
        String value = passwordChars != null ? new String(passwordChars) : DEFAULT_ADMIN_PASSWORD;
        return value;
    }

    static void updateModuleSupport(PayaraInstance instance) {
        instance.updateFactories();
        instance.lookupResult.addLookupListener((LookupListener)instance);
    }

    private static void tagUnderConstruction(String url) {
        if (url != null) {
            PayaraInstanceProvider.activeRegistrationSet.add(url);
        }
    }

    private static void untagUnderConstruction(String url) {
        if (url != null) {
            PayaraInstanceProvider.activeRegistrationSet.remove(url);
        }
    }

    @Deprecated
    public static PayaraInstance create(String displayName, String installRoot, String payaraRoot, String domainsDir, String domainName, int httpPort, int adminPort, String userName, String password, String target, String url, PayaraInstanceProvider pip) {
        return PayaraInstance.create(displayName, installRoot, payaraRoot, domainsDir, domainName, httpPort, adminPort, userName, password, false, false, null, null, target, url, pip);
    }

    public static PayaraInstance create(String displayName, String installRoot, String payaraRoot, String domainsDir, String domainName, int httpPort, int adminPort, String userName, String password, boolean wsl, boolean docker, String hostPath, String containerPath, String target, String url, PayaraInstanceProvider pip) {
        String[] urlParts;
        HashMap<String, String> ip = new HashMap<String, String>();
        ip.put("wsl", String.valueOf(wsl));
        ip.put("docker", String.valueOf(docker));
        if (wsl && domainsDir == null) {
            domainsDir = payaraRoot + File.separator + DEFAULT_DOMAINS_FOLDER;
        }
        ip.put("displayName", displayName);
        ip.put("installfolder", installRoot);
        ip.put("homefolder", payaraRoot);
        ip.put("domainsfolder", domainsDir);
        ip.put("domainname", domainName);
        ip.put("httpportnumber", Integer.toString(httpPort));
        ip.put("adminPort", Integer.toString(adminPort));
        ip.put("target", target);
        ip.put("username", userName != null ? userName : DEFAULT_ADMIN_NAME);
        if (password != null) {
            ip.put("password", password);
        }
        if (hostPath != null) {
            ip.put("hostPath", hostPath);
        }
        if (containerPath != null) {
            ip.put("containerPath", containerPath);
        }
        ip.put("url", url);
        String[] bigUrlParts = url.split("]");
        if (null != bigUrlParts && bigUrlParts.length > 1 && null != (urlParts = bigUrlParts[1].split(KEYRING_IDENT_SEPARATOR)) && urlParts.length > 2) {
            ip.put("host", urlParts[2]);
            ip.put("httphostname", urlParts[2]);
        }
        return PayaraInstance.create(ip, pip, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PayaraInstance create(Map<String, String> ip, PayaraInstanceProvider pip, boolean updateNow) {
        String deployerUri = ip.get("url");
        PayaraInstance instance = null;
        PayaraPlatformVersionAPI version = org.netbeans.modules.payara.tooling.utils.ServerUtils.getPlatformVersion((String)ip.get("homefolder"));
        try {
            instance = new PayaraInstance(ip, version, pip, updateNow);
            PayaraInstance.tagUnderConstruction(deployerUri);
            if (!instance.isPublicAccess()) {
                instance.ic.add((Object)instance.commonSupport);
                instance.allowPublicAccess();
            }
            if (updateNow) {
                PayaraInstance.updateModuleSupport(instance);
            }
        }
        finally {
            PayaraInstance.untagUnderConstruction(deployerUri);
        }
        LOGGER.log(Level.INFO, "Created Payara Server {0} instance with name {1}", new String[]{version != null ? version.toString() : "null", instance != null ? instance.getName() : "null"});
        return instance;
    }

    public static PayaraInstance create(Map<String, String> ip, PayaraInstanceProvider pip) {
        return PayaraInstance.create(ip, pip, true);
    }

    private static String updateString(Map<String, String> map, String key, String value) {
        String result = map.get(key);
        if (result == null) {
            map.put(key, value);
            result = value;
        }
        return result;
    }

    private static int updateInt(Map<String, String> map, String key, int value) {
        int result;
        String storedValue = map.get(key);
        try {
            result = Integer.parseInt(storedValue);
        }
        catch (NumberFormatException ex) {
            map.put(key, Integer.toString(value));
            result = value;
        }
        return result;
    }

    private static boolean filterKey(String key) {
        return INSTANCE_FO_ATTR.equals(key);
    }

    private static void fixImportedAttributes(Map<String, String> ip, FileObject fo) {
        if (!ip.containsKey("nb73ImportFixed")) {
            String password = ip.get("password");
            if (password != null) {
                boolean local;
                boolean bl = local = ip.get("domainsfolder") != null;
                if (local && OLD_DEFAULT_ADMIN_PASSWORD.equals(password)) {
                    if (DEFAULT_ADMIN_PASSWORD == null || DEFAULT_ADMIN_PASSWORD.length() == 0) {
                        ip.remove("password");
                    } else {
                        ip.put("password", DEFAULT_ADMIN_PASSWORD);
                    }
                    ServerUtils.setStringAttribute(fo, "password", DEFAULT_ADMIN_PASSWORD);
                }
            }
            ip.put("nb73ImportFixed", Boolean.toString(true));
        }
    }

    public static PayaraInstance readInstanceFromFile(FileObject instanceFO, boolean autoregistered) throws IOException {
        PayaraInstance instance = null;
        String installRoot = ServerUtils.getStringAttribute(instanceFO, "installfolder");
        String payaraRoot = ServerUtils.getStringAttribute(instanceFO, "homefolder");
        if (installRoot == null) {
            installRoot = payaraRoot;
        }
        if (ServerUtils.isValidFolder(installRoot) && ServerUtils.isValidFolder(payaraRoot)) {
            HashMap<String, String> ip = new HashMap<String, String>();
            Enumeration iter = instanceFO.getAttributes();
            while (iter.hasMoreElements()) {
                String name = (String)iter.nextElement();
                String value = ServerUtils.getStringAttribute(instanceFO, name);
                ip.put(name, value);
            }
            ip.put(INSTANCE_FO_ATTR, instanceFO.getName());
            PayaraInstance.fixImportedAttributes(ip, instanceFO);
            instance = PayaraInstance.create(ip, PayaraInstanceProvider.getProvider(), autoregistered);
        } else {
            LOGGER.log(Level.FINER, "Payara folder {0} is not a valid install.", instanceFO.getPath());
            instanceFO.delete();
        }
        return instance;
    }

    public static void writeInstanceToFile(PayaraInstance instance) throws IOException {
        String payaraRoot = instance.getPayaraRoot();
        if (payaraRoot == null) {
            LOGGER.log(Level.SEVERE, NbBundle.getMessage(PayaraInstanceProvider.class, (String)"MSG_NullServerFolder"));
            return;
        }
        String url = instance.getDeployerUri();
        FileObject dir = ServerUtils.getRepositoryDir(PayaraInstanceProvider.getProvider().getInstancesDirFirstName(), true);
        FileObject[] instanceFOs = dir.getChildren();
        FileObject instanceFO = null;
        for (int i = 0; i < instanceFOs.length; ++i) {
            if (!url.equals(instanceFOs[i].getAttribute("url")) || instanceFOs[i].getName().startsWith("payara_autoregistered_instance")) continue;
            instanceFO = instanceFOs[i];
        }
        if (instanceFO == null) {
            String name = FileUtil.findFreeFileName((FileObject)dir, (String)"instance", null);
            instanceFO = dir.createData(name);
        }
        Map<String, String> attrMap = instance.getProperties();
        for (Map.Entry<String, String> entry : attrMap.entrySet()) {
            Object currentValue;
            String key = entry.getKey();
            if (PayaraInstance.filterKey(key) || null != (currentValue = instanceFO.getAttribute(key)) && currentValue.equals(entry.getValue())) continue;
            if (key.equals("password")) {
                String serverName = attrMap.get("displayName");
                String userName = attrMap.get("username");
                Keyring.save((String)PayaraInstance.passwordKey(serverName, userName), (char[])entry.getValue().toCharArray(), (String)"Payara administrator user password");
                LOGGER.log(Level.FINEST, "{0} attribute stored in keyring: {1}", new String[]{instance.getDisplayName(), key});
                continue;
            }
            instanceFO.setAttribute(key, (Object)entry.getValue());
            LOGGER.log(Level.FINEST, "{0} attribute stored: {1} = {2}", new String[]{instance.getDisplayName(), key, entry.getValue()});
        }
        Enumeration foAttrs = instanceFO.getAttributes();
        while (foAttrs.hasMoreElements()) {
            String foAttr = (String)foAttrs.nextElement();
            if (attrMap.containsKey(foAttr)) continue;
            instanceFO.setAttribute(foAttr, null);
            LOGGER.log(Level.FINEST, "{0} attribute deleted: {1}", new String[]{instance.getDisplayName(), foAttr});
        }
        instance.putProperty(INSTANCE_FO_ATTR, instanceFO.getName());
        instance.getCommonSupport().setFileObject(instanceFO);
    }

    private PayaraInstance(Map<String, String> ip, PayaraPlatformVersionAPI version, PayaraInstanceProvider instanceProvider, boolean prepareProperties) {
        this.platformVersion = version;
        this.process = null;
        this.ic = new InstanceContent();
        this.full = this.localLookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        this.instanceProvider = instanceProvider;
        String domainDirPath = ip.get("domainsfolder");
        String domainName = ip.get("domainname");
        if (null != domainDirPath && null != domainName) {
            File domainDir = new File(domainDirPath, domainName);
            PortCollection pc = new PortCollection();
            if (Util.readServerConfiguration(domainDir, pc)) {
                ip.put("adminPort", Integer.toString(pc.getAdminPort()));
                ip.put("httpportnumber", Integer.toString(pc.getHttpPort()));
            }
            this.domainXMLListener = new DomainXMLChangeListener(this, org.netbeans.modules.payara.tooling.utils.ServerUtils.getDomainConfigFile((String)domainDirPath, (String)domainName));
        } else {
            this.domainXMLListener = null;
        }
        this.properties = prepareProperties ? this.prepareProperties(ip) : new Props(ip);
        if (!this.isPublicAccess()) {
            this.ic.add((Object)this);
            this.commonInstance = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)this);
        }
        if (this.platformVersion == null) {
            String installroot = ip.get("homefolder");
            String displayName = ip.get("displayName");
            WarnPanel.pfUnknownVersionWarning(displayName, installroot);
            LOGGER.log(Level.INFO, NbBundle.getMessage(PayaraInstance.class, (String)"PayaraInstance.init.versionNull", (Object[])new String[]{displayName, installroot}));
        }
        this.commonSupport = new CommonServerSupport(this);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Props properties) {
        this.properties = properties;
    }

    Lookup localLookup() {
        return this.localLookup;
    }

    public PayaraInstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    public Process getProcess() {
        return this.process;
    }

    public DomainXMLChangeListener getDomainXMLChangeListener() {
        return this.domainXMLListener;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void resetProcess() {
        this.process = null;
    }

    public String getName() {
        return this.properties.get("displayName");
    }

    public String getHost() {
        return this.properties.get("host");
    }

    public void setHost(String host) {
        this.properties.put("host", host);
    }

    public int getPort() {
        return this.intProperty("httpportnumber");
    }

    public void setHttpPort(String httpPort) {
        Integer.parseInt(httpPort);
        this.properties.put("httpportnumber", httpPort);
    }

    public void setHttpPort(int httpPort) {
        this.properties.put("httpportnumber", Integer.toString(httpPort));
    }

    public int getAdminPort() {
        return this.intProperty("adminPort");
    }

    public void setAdminPort(String adminPort) {
        this.properties.put("adminPort", adminPort);
    }

    public void setAdminPort(int adminPort) {
        this.properties.put("adminPort", Integer.toString(adminPort));
    }

    public String getAdminUser() {
        return this.properties.get("username");
    }

    public String getAdminPassword() {
        return this.properties.get("password");
    }

    public boolean isDocker() {
        return Boolean.valueOf(this.properties.getOrDefault("docker", "false"));
    }

    public boolean isWSL() {
        return Boolean.valueOf(this.properties.getOrDefault("wsl", "false"));
    }

    public String getHostPath() {
        return this.properties.get("hostPath");
    }

    public void setHostPath(String hostPath) {
        this.properties.put("hostPath", hostPath);
    }

    public String getContainerPath() {
        return this.properties.get("containerPath");
    }

    public void setContainerPath(String containerPath) {
        this.properties.put("containerPath", containerPath);
    }

    public String getDomainsFolder() {
        return this.properties.get("domainsfolder");
    }

    public String setDomainsFolder(String domainsFolder) {
        return this.properties.put("domainsfolder", domainsFolder);
    }

    public String getDomainName() {
        return this.properties.getOrDefault("domainname", DEFAULT_DOMAIN_NAME);
    }

    public String getTarget() {
        return this.properties.get("target");
    }

    public String setTarget(String target) {
        return this.properties.put("target", target);
    }

    public String getUrl() {
        return this.properties.get("url");
    }

    public String getServerHome() {
        return this.properties.get("homefolder");
    }

    public String getServerRoot() {
        return this.properties.get("installfolder");
    }

    @Deprecated
    public PayaraVersion getVersion() {
        return this.version;
    }

    public PayaraPlatformVersionAPI getPlatformVersion() {
        return this.platformVersion;
    }

    public PayaraAdminInterface getAdminInterface() {
        return PayaraAdminInterface.HTTP;
    }

    public boolean isRemote() {
        return this.properties.get("domainsfolder") == null || this.isWSL();
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String putProperty(String key, String value) {
        return this.properties.put(key, value);
    }

    public String removeProperty(String key) {
        return this.properties.remove(key);
    }

    public String getHttpPort() {
        return this.properties.get("httpportnumber");
    }

    public String getHttpAdminPort() {
        return this.properties.get("adminPort");
    }

    public void setAdminUser(String user) {
        this.properties.put("username", user);
    }

    public void setAdminPassword(String password) {
        this.properties.put("password", password);
    }

    public String getPassword() {
        return this.properties.get("password");
    }

    public String getInstallRoot() {
        return this.properties.get("installfolder");
    }

    public String getPayaraRoot() {
        return this.properties.get("homefolder");
    }

    public String getDisplayName() {
        return this.properties.get("displayName");
    }

    public String getDeployerUri() {
        return this.properties.get("url");
    }

    public String getUserName() {
        return this.properties.get("username");
    }

    public boolean isHotDeployFeatureAvailable() {
        return this.getPlatformVersion().getMajor() > 5 || this.getPlatformVersion().getMajor() == 5 && this.getPlatformVersion().getMinor() >= 201;
    }

    public boolean isHotDeployEnabled() {
        if (this.isHotDeployFeatureAvailable()) {
            return Boolean.parseBoolean(this.getProperty("hotDeploy"));
        }
        return false;
    }

    public String getJavaHome() {
        return this.properties.get("java.platform");
    }

    public void setJavaHome(String javahome) {
        if (javahome != null) {
            this.properties.put("java.platform", javahome);
        } else {
            this.properties.remove("java.platform");
        }
    }

    public String getJvmModeAsString() {
        return this.properties.get("jvmMode");
    }

    public PayaraJvmMode getJvmMode() {
        return PayaraJvmMode.toValue(this.properties.get("jvmMode"));
    }

    public int getDebugPort() {
        int debugPort;
        try {
            debugPort = Integer.parseInt(this.getProperty("debugPort"));
            if (debugPort < LOWEST_USER_PORT || debugPort > 65535) {
                this.putProperty("debugPort", Integer.toString(9009));
                debugPort = 9009;
                LOGGER.log(Level.INFO, "Converted debug port to {0} for {1}", new String[]{Integer.toString(9009), this.getDisplayName()});
            }
        }
        catch (NumberFormatException nfe) {
            this.putProperty("debugPort", Integer.toString(9009));
            debugPort = 9009;
            LOGGER.log(Level.INFO, "Converted debug port to {0} for {1}", new String[]{Integer.toString(9009), this.getDisplayName()});
        }
        finally {
            this.putProperty("use.shared.mem", Boolean.toString(false));
        }
        return debugPort;
    }

    public boolean isProcessRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            return true;
        }
        return false;
    }

    public JavaPlatform getJavaPlatform() {
        String javaHome = this.getJavaHome();
        if (javaHome == null || javaHome.length() == 0) {
            return null;
        }
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        File javaHomeFile = new File(javaHome);
        JavaPlatform javaPlatform = null;
        for (JavaPlatform platform : platforms) {
            for (FileObject fo : platform.getInstallFolders()) {
                if (!javaHomeFile.equals(FileUtil.toFile((FileObject)fo))) continue;
                javaPlatform = platform;
                break;
            }
            if (javaPlatform != null) break;
        }
        return javaPlatform;
    }

    public synchronized String getDomainsRoot() {
        String retVal = this.getDomainsFolder();
        if (null == retVal) {
            return null;
        }
        File candidate = new File(retVal);
        if (candidate.exists() && !Utils.canWrite(candidate)) {
            String domainsFolder = ServerUtils.getDomainsFolder(this);
            String foldername = FileUtil.findFreeFolderName((FileObject)FileUtil.getConfigRoot(), (String)domainsFolder);
            FileObject destdir = null;
            try {
                destdir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)foldername);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "could not create a writable domain dir", ex);
            }
            if (null != destdir) {
                candidate = new File(candidate, this.getDomainName());
                FileObject source = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)candidate));
                try {
                    Utils.doCopy(source, destdir);
                    retVal = FileUtil.toFile((FileObject)destdir).getAbsolutePath();
                    this.setDomainsFolder(retVal);
                }
                catch (IOException ex) {
                    foldername = FileUtil.findFreeFolderName((FileObject)FileUtil.getConfigRoot(), (String)domainsFolder);
                    try {
                        destdir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)foldername);
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.INFO, "could not create a writable second domain dir", ioe);
                        return retVal;
                    }
                    File destdirFile = FileUtil.toFile((FileObject)destdir);
                    this.setDomainsFolder(destdirFile.getAbsolutePath());
                    retVal = destdirFile.getAbsolutePath();
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            CreateDomain cd = new CreateDomain("anonymous", PayaraInstance.DEFAULT_ADMIN_PASSWORD, new File(PayaraInstance.this.getServerHome()), PayaraInstance.this.properties, PayaraInstanceProvider.getProvider(), false, true, "INSTALL_ROOT_KEY");
                            cd.start();
                        }
                    }, 100);
                }
            }
        }
        return retVal;
    }

    public final CommonServerSupport getCommonSupport() {
        return this.commonSupport;
    }

    @Deprecated
    public final PayaraModule.ServerState getServerState() {
        return this.getCommonSupport().getServerState();
    }

    @Deprecated
    final void stopIfStartedByIde(long timeout) {
        if (this.commonSupport.isStartedByIde()) {
            PayaraModule.ServerState state = this.commonSupport.getServerState();
            if (state == PayaraModule.ServerState.STARTING || state == PayaraModule.ServerState.RUNNING && PayaraState.isOnline(this)) {
                try {
                    TaskState opState;
                    Future<TaskState> stopServerTask = this.commonSupport.stopServer(null);
                    if (timeout > 0L && (opState = stopServerTask.get(timeout, TimeUnit.MILLISECONDS)) != TaskState.COMPLETED) {
                        Logger.getLogger("payara").info("Stop server failed...");
                    }
                }
                catch (TimeoutException ex) {
                    LOGGER.log(Level.FINE, "Server {0} timed out sending stop-domain command.", this.getDeployerUri());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        } else {
            this.commonSupport.disableStop();
        }
    }

    private Map<String, String> prepareProperties(Map<String, String> properties) {
        boolean isRemote = properties.get("domainsfolder") == null;
        String deployerUri = properties.get("url");
        PayaraInstance.updateString(properties, "host", DEFAULT_HOST_NAME);
        PayaraInstance.updateString(properties, "homefolder", DEFAULT_ADMIN_PASSWORD);
        PayaraInstance.updateInt(properties, "httpportnumber", 8080);
        PayaraInstance.updateString(properties, "displayName", "Bogus display name");
        PayaraInstance.updateInt(properties, "adminPort", 4848);
        PayaraInstance.updateString(properties, "hotDeploy", "false");
        PayaraInstance.updateString(properties, "preserveSessionsOn", "true");
        PayaraInstance.updateString(properties, "useIDEProxyOn", "true");
        PayaraInstance.updateString(properties, "driverDeployOn", "true");
        PayaraInstance.updateString(properties, "httphostname", DEFAULT_HOST_NAME);
        properties.put("jvmMode", isRemote && !deployerUri.contains("deployer:pfv3ee6wc") ? PayaraModule.DEBUG_MODE : PayaraModule.NORMAL_MODE);
        PayaraInstance.updateString(properties, "username", DEFAULT_ADMIN_NAME);
        PayaraInstance.updateString(properties, "nb73ImportFixed", Boolean.toString(true));
        Props newProperties = new Props(properties);
        return newProperties;
    }

    private boolean isPublicAccess() {
        return this.instanceProvider.getInternalInstance(this.getUrl()) != null;
    }

    private void allowPublicAccess() {
        if (!this.isPublicAccess()) {
            this.instanceProvider.addServerInstance(this);
        }
    }

    private int intProperty(String name) {
        String property = this.properties.get(name);
        if (property == null) {
            LOGGER.log(Level.WARNING, "Cannot convert null value to a number");
            return -1;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.WARNING, "Cannot convert " + property + " to a number: ", nfe);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFactories() {
        Properties asenvProps = new Properties();
        String homeFolder = this.getPayaraRoot();
        File asenvConf = new File(homeFolder, "config/asenv.conf");
        if (asenvConf.exists()) {
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(asenvConf));
                asenvProps.load(is);
            }
            catch (FileNotFoundException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                asenvProps.clear();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        } else {
            LOGGER.log(Level.WARNING, "{0} does not exist", asenvConf.getAbsolutePath());
        }
        HashSet added = new HashSet();
        Lookup.Result<PayaraModuleFactory> result = this.lookupResult;
        synchronized (result) {
            Collection factories = this.lookupResult.allInstances();
            added.addAll(factories);
            added.removeAll(this.currentFactories);
            this.currentFactories = factories;
            ArrayList<Lookup> proxies = new ArrayList<Lookup>();
            proxies.add(this.localLookup);
            for (PayaraModuleFactory moduleFactory : added) {
                if (!moduleFactory.isModuleSupported(homeFolder, asenvProps)) continue;
                Object t = moduleFactory.createModule(this.localLookup);
                if (null == t) {
                    LOGGER.log(Level.WARNING, "{0} created a null module", moduleFactory);
                    continue;
                }
                this.ic.add(t);
                if (!(t instanceof Lookup.Provider)) continue;
                proxies.add(Lookups.proxy((Lookup.Provider)((Lookup.Provider)t)));
            }
            if (!proxies.isEmpty()) {
                this.full = new ProxyLookup(proxies.toArray(new Lookup[0]));
            }
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.updateFactories();
    }

    public ServerInstance getCommonInstance() {
        return this.commonInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        Lookup.Result<PayaraModuleFactory> result = this.lookupResult;
        synchronized (result) {
            return this.full;
        }
    }

    public String getServerDisplayName() {
        return NbBundle.getMessage(PayaraInstance.class, (String)"STR_SERVER_NAME", (Object[])new Object[]{this.platformVersion != null ? this.platformVersion.toString() : DEFAULT_ADMIN_PASSWORD});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getFullNode() {
        Logger.getLogger("payara").finer("Creating PF Instance node [FULL]");
        Lookup.Result<PayaraModuleFactory> result = this.lookupResult;
        synchronized (result) {
            if (this.fullNode == null) {
                this.fullNode = new Hk2InstanceNode(this, true);
            }
            return this.fullNode;
        }
    }

    public Node getBasicNode() {
        Logger.getLogger("payara").finer("Creating GF Instance node [BASIC]");
        return new Hk2InstanceNode(this, false);
    }

    public JComponent getCustomizer() {
        return new PayaraPropertiesCustomizer(this, this.localLookup);
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void remove() {
        if (!this.removable) {
            return;
        }
        this.stopIfStartedByIde(3000L);
        String uri = this.getDeployerUri();
        InputOutput io = LogViewMgr.getServerIO(uri);
        if (io != null && !io.isClosed()) {
            io.closeInputOutput();
        }
        Collection lookupAll = this.localLookup.lookupAll(RemoveCookie.class);
        for (RemoveCookie cookie : lookupAll) {
            cookie.removeInstance(this.getDeployerUri());
        }
        this.instanceProvider.removeServerInstance(this);
        this.ic.remove((Object)this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PayaraInstance)) {
            return false;
        }
        PayaraInstance other = (PayaraInstance)obj;
        if (null == this.getDeployerUri()) {
            return false;
        }
        if (null == other.getDeployerUri()) {
            return false;
        }
        boolean domainName = Objects.equals(this.getDomainName(), other.getDomainName());
        boolean domainsRoot = Objects.equals(this.getDomainsRoot(), other.getDomainsRoot());
        return domainName && domainsRoot && this.getDeployerUri().replace("127.0.0.1", DEFAULT_HOST_NAME).equals(other.getDeployerUri().replace("127.0.0.1", DEFAULT_HOST_NAME)) && this.getHttpPort().equals(other.getHttpPort());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public class Props
    implements Map<String, String> {
        private final Map<String, String> delegate;

        public Props(Map<String, String> map) {
            if (map == null) {
                throw new NullPointerException("Source Map shall not be null.");
            }
            this.delegate = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<String> values() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return Collections.unmodifiableCollection(this.delegate.values());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> keySet() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return Collections.unmodifiableSet(this.delegate.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return Collections.unmodifiableSet(this.delegate.entrySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String remove(Object key) {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                this.delegate.putAll(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String put(String key, String value) {
            if ("password".equals(key)) {
                String serverName = this.get("displayName");
                String userName = this.get("username");
                if (serverName != null && userName != null) {
                    Keyring.save((String)PayaraInstance.passwordKey(serverName, userName), (char[])value.toCharArray(), (String)"Payara administrator user password");
                }
            }
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map) {
                Map<String, String> map = this.delegate;
                synchronized (map) {
                    return this.delegate.equals(o);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                this.delegate.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get(Object key) {
            if ("password".equals(key)) {
                String value;
                Map<String, String> map = this.delegate;
                synchronized (map) {
                    value = this.delegate.get(key);
                }
                if (value == null) {
                    value = PayaraInstance.getPasswordFromKeyring(this.delegate.get("displayName"), this.delegate.get("username"));
                    map = this.delegate;
                    synchronized (map) {
                        this.delegate.put((String)key, value);
                    }
                }
                return value;
            }
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.get(key);
            }
        }
    }
}

