/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.jfr.impl;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.runtime.jfr.RootFunctionEvent;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;

abstract class RootFunctionEventImpl
extends Event
implements RootFunctionEvent {
    @Label(value="Source")
    @Description(value="Compiled Source")
    public String source;
    @Label(value="Language")
    @Description(value="Guest Language")
    public String language;
    @Label(value="Root Function")
    @Description(value="Root Function")
    public String rootFunction;

    RootFunctionEventImpl() {
    }

    RootFunctionEventImpl(String source, String language, String rootFunction) {
        this.source = source;
        this.language = language;
        this.rootFunction = rootFunction;
    }

    @Override
    public void setRootFunction(RootCallTarget target) {
        RootNode rootNode = target.getRootNode();
        this.source = RootFunctionEventImpl.targetName(rootNode);
        LanguageInfo languageInfo = rootNode.getLanguageInfo();
        this.language = languageInfo != null ? languageInfo.getId() : null;
        this.rootFunction = rootNode.getName();
        if (this.rootFunction == null) {
            this.rootFunction = rootNode.toString();
        }
    }

    @Override
    public void publish() {
        this.commit();
    }

    private static String targetName(RootNode rootNode) {
        SourceSection sourceSection = rootNode.getSourceSection();
        if (sourceSection != null && sourceSection.getSource() != null) {
            return sourceSection.getSource().getName() + ":" + sourceSection.getStartLine();
        }
        return null;
    }
}

