/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.refactoring;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Position;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.RulesManager;
import org.netbeans.modules.java.hints.spiimpl.RulesManagerImpl;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.spi.java.hints.Hint;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class Utilities {
    private static final RequestProcessor RP = new RequestProcessor(Utilities.class.getName(), 1, false, false);
    private static Dialog waitDialog = null;
    private static final String HINTS_FOLDER = "org-netbeans-modules-java-hints/rules/hints/";
    public static final String CUSTOM_CATEGORY = "custom";

    public static List<PositionBounds> prepareSpansFor(FileObject file, Iterable<? extends int[]> spans) {
        AbstractList result = new ArrayList<PositionBounds>();
        try {
            DataObject d = DataObject.find((FileObject)file);
            EditorCookie ec = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
            CloneableEditorSupport ces = (CloneableEditorSupport)ec;
            result = new LinkedList();
            for (int[] nArray : spans) {
                PositionRef start = ces.createPositionRef(nArray[0], Position.Bias.Forward);
                PositionRef end = ces.createPositionRef(nArray[1], Position.Bias.Forward);
                result.add((PositionBounds)new PositionBounds(start, end));
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public static Collection<RefactoringElementImplementation> createRefactoringElementImplementation(FileObject file, List<PositionBounds> spans, boolean verified) {
        LinkedList<RefactoringElementImplementation> result = new LinkedList<RefactoringElementImplementation>();
        try {
            DataObject d = DataObject.find((FileObject)file);
            LineCookie lc = (LineCookie)d.getLookup().lookup(LineCookie.class);
            for (PositionBounds bound : spans) {
                PositionRef start = bound.getBegin();
                PositionRef end = bound.getEnd();
                Line l = lc.getLineSet().getCurrent(start.getLine());
                String lineText = l.getText();
                int boldStart = start.getColumn();
                int boldEnd = end.getLine() == start.getLine() ? end.getColumn() : lineText.length();
                StringBuilder displayName = new StringBuilder();
                if (!verified) {
                    displayName.append("(not verified) ");
                }
                displayName.append(Utilities.escapedSubstring(lineText, 0, boldStart).replaceAll("^[ ]*", ""));
                displayName.append("<b>");
                displayName.append(Utilities.escapedSubstring(lineText, boldStart, boldEnd));
                displayName.append("</b>");
                displayName.append(Utilities.escapedSubstring(lineText, boldEnd, lineText.length()));
                result.add((RefactoringElementImplementation)new RefactoringElementImpl(file, bound, displayName.toString()));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private static String escapedSubstring(String str, int start, int end) {
        String substring = str.substring(start, end);
        try {
            return XMLUtil.toElementContent((String)substring);
        }
        catch (CharConversionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return substring;
        }
    }

    public static Map<? extends HintMetadata, ? extends Collection<? extends HintDescription>> getBatchSupportedHints(ClassPathBasedHintWrapper cpBased) {
        HashMap<HintMetadata, Collection<? extends HintDescription>> result = new HashMap<HintMetadata, Collection<? extends HintDescription>>();
        for (Map.Entry<? extends HintMetadata, ? extends Collection<? extends HintDescription>> entry : cpBased.getHints().entrySet()) {
            if (entry.getKey().options.contains(HintMetadata.Options.NO_BATCH) || entry.getKey().kind != Hint.Kind.INSPECTION) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static boolean invokeAfterScanFinished(Runnable runnable, String actionName) {
        assert (SwingUtilities.isEventDispatchThread());
        if (SourceUtils.isScanInProgress()) {
            final ActionPerformer ap = new ActionPerformer(runnable);
            final RequestProcessor.Task waitTask = RP.post((Runnable)ap, 100);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ap.cancel();
                    waitTask.cancel();
                }
            };
            JLabel label = new JLabel(Utilities.getString("MSG_WaitScan"), UIManager.getIcon("OptionPane.informationIcon"), 2);
            label.setBorder(new EmptyBorder(12, 12, 11, 11));
            DialogDescriptor dd = new DialogDescriptor((Object)label, actionName, true, new Object[]{Utilities.getString("LBL_CancelAction", new Object[]{actionName})}, null, 0, null, listener);
            waitDialog = DialogDisplayer.getDefault().createDialog(dd);
            waitDialog.pack();
            waitDialog.setVisible(true);
            waitDialog = null;
            return ap.hasBeenCancelled();
        }
        runnable.run();
        return false;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(Utilities.class, (String)key);
    }

    private static String getString(String key, Object values) {
        return new MessageFormat(Utilities.getString(key)).format(values);
    }

    public static String categoryDisplayName(String categoryCodeName) {
        FileObject catFO = FileUtil.getConfigFile((String)(HINTS_FOLDER + categoryCodeName));
        return catFO != null ? Utilities.getFileObjectLocalizedName(catFO) : (CUSTOM_CATEGORY.equals(categoryCodeName) ? NbBundle.getBundle((String)"org.netbeans.modules.java.hints.resources.Bundle").getString("org-netbeans-modules-java-hints/rules/hints/custom") : categoryCodeName);
    }

    private static String getFileObjectLocalizedName(FileObject fo) {
        Object o = fo.getAttribute("SystemFileSystem.localizingBundle");
        if (o instanceof String) {
            String bundleName = (String)o;
            try {
                ResourceBundle rb = NbBundle.getBundle((String)bundleName);
                String localizedName = rb.getString(fo.getPath());
                return localizedName;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return fo.getPath();
    }

    private static final class RefactoringElementImpl
    extends SimpleRefactoringElementImplementation {
        private final FileObject file;
        private final PositionBounds span;
        private final String displayName;
        private final Lookup lookup;

        public RefactoringElementImpl(FileObject file, PositionBounds span, String displayName) {
            this.file = file;
            this.span = span;
            this.lookup = Lookups.fixed((Object[])new Object[]{file});
            this.displayName = displayName;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return this.displayName;
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return this.span;
        }
    }

    public static final class ClassPathBasedHintWrapper {
        private Map<? extends HintMetadata, ? extends Collection<? extends HintDescription>> hints;
        private List<HintDescription> cpHints;

        public synchronized void compute() {
            if (this.hints != null) {
                return;
            }
            HashSet binaryClassPath = new HashSet();
            binaryClassPath.addAll(GlobalPathRegistry.getDefault().getPaths("classpath/compile"));
            binaryClassPath.addAll(GlobalPathRegistry.getDefault().getPaths("classpath/boot"));
            if (this.cpHints == null) {
                this.cpHints = org.netbeans.modules.java.hints.spiimpl.Utilities.listClassPathHints((Set)GlobalPathRegistry.getDefault().getPaths("classpath/source"), binaryClassPath);
            }
            HashMap<? extends HintMetadata, ? extends Collection<? extends HintDescription>> localHints = new HashMap<HintMetadata, Collection<? extends HintDescription>>();
            RulesManagerImpl.sortByMetadata(this.cpHints, localHints);
            localHints.putAll(RulesManager.getInstance().readHints(null, null, null));
            this.hints = localHints;
        }

        public synchronized Map<? extends HintMetadata, ? extends Collection<? extends HintDescription>> getHints() {
            this.compute();
            return this.hints;
        }

        public synchronized void reset() {
            this.hints = null;
        }
    }

    private static class ActionPerformer
    implements Runnable {
        private Runnable action;
        private boolean cancel = false;

        ActionPerformer(Runnable a) {
            this.action = a;
        }

        public boolean hasBeenCancelled() {
            return this.cancel;
        }

        @Override
        public void run() {
            try {
                SourceUtils.waitScanFinished();
            }
            catch (InterruptedException ie) {
                Exceptions.printStackTrace((Throwable)ie);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!cancel) {
                        if (waitDialog != null) {
                            waitDialog.setVisible(false);
                            waitDialog.dispose();
                        }
                        action.run();
                    }
                }
            });
        }

        public void cancel() {
            assert (SwingUtilities.isEventDispatchThread());
            if (waitDialog != null) {
                this.cancel = true;
                waitDialog.setVisible(false);
                waitDialog.dispose();
            }
        }
    }
}

