/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ide.eclipse.gltrace.GLTraceCollectorDialog;
import com.android.ide.eclipse.gltrace.GLTraceOptionsDialog;
import com.android.ide.eclipse.gltrace.GlTracePlugin;
import com.android.ide.eclipse.gltrace.TraceCommandWriter;
import com.android.ide.eclipse.gltrace.TraceFileWriter;
import com.android.ide.eclipse.gltrace.TraceOptions;
import com.android.ide.eclipse.gltrace.editors.GLFunctionTraceViewer;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;

public class CollectTraceAction
implements IWorkbenchWindowActionDelegate {
    private static final String GLTRACE_UDS = "gltrace";
    private static final int LOCAL_FORWARDED_PORT = 6039;
    private static final String SYSTEM_APP = "system";
    private static final int LAUNCH_TIMEOUT = 5;
    private static final int KILL_TIMEOUT = 5;
    private static final int MIN_API_LEVEL = 16;

    public void run(IAction action) {
        this.connectToDevice();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    private void connectToDevice() {
        int apiLevel;
        Shell shell = Display.getDefault().getActiveShell();
        GLTraceOptionsDialog dlg = new GLTraceOptionsDialog(shell);
        if (dlg.open() != 0) {
            return;
        }
        TraceOptions traceOptions = dlg.getTraceOptions();
        IDevice device = this.getDevice(traceOptions.device);
        String apiLevelString = device.getProperty("ro.build.version.sdk");
        try {
            apiLevel = Integer.parseInt(apiLevelString);
        }
        catch (NumberFormatException numberFormatException) {
            apiLevel = 16;
        }
        if (apiLevel < 16) {
            MessageDialog.openError((Shell)shell, (String)"GL Trace", (String)String.format("OpenGL Tracing is only supported on devices at API Level %1$d.The selected device '%2$s' provides API level %3$s.", 16, traceOptions.device, apiLevelString));
            return;
        }
        try {
            CollectTraceAction.setupForwarding(device, 6039);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"Setup GL Trace", (String)("Error while setting up port forwarding: " + e.getMessage()));
            return;
        }
        try {
            if (!SYSTEM_APP.equals(traceOptions.appToTrace)) {
                this.startActivity(device, traceOptions.appToTrace, traceOptions.activityToTrace, traceOptions.isActivityNameFullyQualified);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"Setup GL Trace", (String)("Error while launching application: " + e.getMessage()));
            return;
        }
        CollectTraceAction.startTracing(shell, traceOptions, 6039);
        CollectTraceAction.disablePortForwarding(device, 6039);
        CollectTraceAction.openInEditor(shell, traceOptions.traceDestination);
    }

    public static void openInEditor(Shell shell, String traceFilePath) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(traceFilePath));
        if (!fileStore.fetchInfo().exists()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        try {
            workbench.showPerspective("com.android.ide.eclipse.gltrace.perspective", window);
        }
        catch (WorkbenchException workbenchException) {}
        GLFunctionTraceViewer viewer = CollectTraceAction.getOpenTraceViewer(page, traceFilePath);
        if (viewer != null) {
            viewer.setInput(shell, traceFilePath);
        }
        try {
            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
        }
        catch (PartInitException e) {
            GlTracePlugin.getDefault().logMessage("Unexpected error while opening gltrace file in editor: " + (Object)((Object)e));
            return;
        }
    }

    private static GLFunctionTraceViewer getOpenTraceViewer(IWorkbenchPage page, String traceFilePath) {
        IEditorReference[] editorRefs;
        IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IEditorReference ref = iEditorReferenceArray[n2];
                String id = ref.getId();
                if ("com.android.ide.eclipse.gltrace.GLFunctionTrace".equals(id)) {
                    IEditorInput input = null;
                    try {
                        input = ref.getEditorInput();
                    }
                    catch (PartInitException partInitException) {
                        break block5;
                    }
                    if (input instanceof IURIEditorInput && traceFilePath.equals(((IURIEditorInput)input).getURI().getPath())) {
                        return (GLFunctionTraceViewer)ref.getEditor(true);
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public static void startTracing(Shell shell, TraceOptions traceOptions, int port) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(traceOptions.traceDestination, false);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        Socket socket = new Socket();
        DataInputStream traceDataStream = null;
        DataOutputStream traceCommandsStream = null;
        try {
            socket.connect(new InetSocketAddress("127.0.0.1", port));
            socket.setTcpNoDelay(true);
            traceDataStream = new DataInputStream(socket.getInputStream());
            traceCommandsStream = new DataOutputStream(socket.getOutputStream());
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)shell, (String)"OpenGL Trace", (String)("Unable to connect to remote GL Trace Server: " + e.getMessage()));
            Closeables.closeQuietly((Closeable)fos);
            return;
        }
        TraceCommandWriter traceCommandWriter = new TraceCommandWriter(traceCommandsStream);
        try {
            traceCommandWriter.setTraceOptions(traceOptions.collectFbOnEglSwap, traceOptions.collectFbOnGlDraw, traceOptions.collectTextureData);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)shell, (String)"OpenGL Trace", (String)("Unexpected error while setting trace options: " + e.getMessage()));
            CollectTraceAction.closeSocket(socket);
            Closeables.closeQuietly((Closeable)fos);
            return;
        }
        TraceFileWriter traceFileWriter = new TraceFileWriter(fos, traceDataStream);
        traceFileWriter.start();
        GLTraceCollectorDialog dlg = new GLTraceCollectorDialog(shell, traceFileWriter, traceCommandWriter, traceOptions);
        dlg.open();
        traceFileWriter.stopTracing();
        traceCommandWriter.close();
        CollectTraceAction.closeSocket(socket);
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    private void startActivity(IDevice device, String appPackage, String activity, boolean isActivityNameFullyQualified) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InterruptedException {
        this.killApp(device, appPackage);
        this.waitUntilAppKilled(device, appPackage, 5);
        StringBuilder activityPath = new StringBuilder(appPackage);
        if (!activity.isEmpty()) {
            activityPath.append('/');
            if (!isActivityNameFullyQualified) {
                activityPath.append('.');
            }
            activityPath.append(activity);
        }
        String startAppCmd = String.format("am start --opengl-trace %s -a android.intent.action.MAIN -c android.intent.category.LAUNCHER", activityPath.toString());
        Semaphore launchCompletionSempahore = new Semaphore(0);
        StartActivityOutputReceiver receiver = new StartActivityOutputReceiver(launchCompletionSempahore);
        device.executeShellCommand(startAppCmd, (IShellOutputReceiver)receiver);
        launchCompletionSempahore.acquire();
        String output = receiver.getOutput();
        if (output.contains("Error")) {
            throw new RuntimeException(output);
        }
        this.waitUntilAppLaunched(device, appPackage, 5);
    }

    private void killApp(IDevice device, String appName) {
        Client client = device.getClient(appName);
        if (client != null) {
            client.kill();
        }
    }

    private void waitUntilAppLaunched(final IDevice device, final String appName, int timeout) {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Client client;
                while ((client = device.getClient(appName)) == null) {
                }
                return Boolean.TRUE;
            }
        };
        try {
            new SimpleTimeLimiter().callWithTimeout((Callable)c, (long)timeout, TimeUnit.SECONDS, true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Timed out waiting for application to launch.");
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void waitUntilAppKilled(final IDevice device, final String appName, int timeout) {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Client client;
                while ((client = device.getClient(appName)) != null) {
                    client.kill();
                }
                return Boolean.TRUE;
            }
        };
        try {
            new SimpleTimeLimiter().callWithTimeout((Callable)c, (long)timeout, TimeUnit.SECONDS, true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Timed out waiting for running application to die.");
        }
    }

    public static void setupForwarding(IDevice device, int i) throws TimeoutException, AdbCommandRejectedException, IOException {
        device.createForward(i, GLTRACE_UDS, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
    }

    public static void disablePortForwarding(IDevice device, int port) {
        try {
            device.removeForward(port, GLTRACE_UDS, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
        }
        catch (Exception exception) {}
    }

    private IDevice getDevice(String deviceName) {
        IDevice[] devices;
        IDevice[] iDeviceArray = devices = AndroidDebugBridge.getBridge().getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (device.getName().equals(deviceName)) {
                return device;
            }
            ++n2;
        }
        return null;
    }

    private static class StartActivityOutputReceiver
    implements IShellOutputReceiver {
        private Semaphore mSemaphore;
        private StringBuffer sb = new StringBuffer(300);

        public StartActivityOutputReceiver(Semaphore s) {
            this.mSemaphore = s;
        }

        public void addOutput(byte[] data, int offset, int length) {
            String d = new String(data, offset, length);
            this.sb.append(d);
        }

        public void flush() {
            this.mSemaphore.release();
        }

        public boolean isCancelled() {
            return false;
        }

        public String getOutput() {
            return this.sb.toString();
        }
    }
}

