/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PixelPerfectPixelPanel
extends Canvas
implements PixelPerfectModel.IImageChangeListener {
    private PixelPerfectModel mModel;
    private Image mImage;
    private Image mOverlayImage;
    private Point mCrosshairLocation;
    public static final int PREFERRED_WIDTH = 180;
    public static final int PREFERRED_HEIGHT = 52;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            PixelPerfectPixelPanel.this.mModel.removeImageChangeListener(PixelPerfectPixelPanel.this);
        }
    };
    private PaintListener mPaintListener = new PaintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintControl(PaintEvent e) {
            PixelPerfectPixelPanel pixelPerfectPixelPanel = PixelPerfectPixelPanel.this;
            synchronized (pixelPerfectPixelPanel) {
                e.gc.setBackground(Display.getDefault().getSystemColor(2));
                e.gc.fillRectangle(0, 0, PixelPerfectPixelPanel.this.getBounds().width, PixelPerfectPixelPanel.this.getBounds().height);
                if (PixelPerfectPixelPanel.this.mImage != null) {
                    RGB pixel = ((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mImage.getImageData().palette.getRGB(PixelPerfectPixelPanel.this.mImage.getImageData().getPixel(((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mCrosshairLocation.x, ((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mCrosshairLocation.y));
                    Color rgbColor = new Color((Device)Display.getDefault(), pixel);
                    e.gc.setForeground(Display.getDefault().getSystemColor(1));
                    e.gc.setBackground(rgbColor);
                    e.gc.drawRectangle(4, 4, 60, 30);
                    e.gc.fillRectangle(5, 5, 59, 29);
                    rgbColor.dispose();
                    e.gc.drawText("#" + Integer.toHexString(0x1000000 + (pixel.red << 16) + (pixel.green << 8) + pixel.blue).substring(1), 4, 35, true);
                    e.gc.drawText("R:", 80, 4, true);
                    e.gc.drawText("G:", 80, 20, true);
                    e.gc.drawText("B:", 80, 35, true);
                    e.gc.drawText(Integer.toString(pixel.red), 97, 4, true);
                    e.gc.drawText(Integer.toString(pixel.green), 97, 20, true);
                    e.gc.drawText(Integer.toString(pixel.blue), 97, 35, true);
                    e.gc.drawText("X:", 132, 4, true);
                    e.gc.drawText("Y:", 132, 20, true);
                    e.gc.drawText(Integer.toString(((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mCrosshairLocation.x) + " px", 149, 4, true);
                    e.gc.drawText(Integer.toString(((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mCrosshairLocation.y) + " px", 149, 20, true);
                    if (PixelPerfectPixelPanel.this.mOverlayImage != null) {
                        int xInOverlay = ((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mCrosshairLocation.x;
                        int yInOverlay = ((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mCrosshairLocation.y - (((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mImage.getBounds().height - ((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mOverlayImage.getBounds().height);
                        if (xInOverlay >= 0 && yInOverlay >= 0 && xInOverlay < ((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mOverlayImage.getBounds().width && yInOverlay < ((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mOverlayImage.getBounds().height) {
                            pixel = ((PixelPerfectPixelPanel)PixelPerfectPixelPanel.this).mOverlayImage.getImageData().palette.getRGB(PixelPerfectPixelPanel.this.mOverlayImage.getImageData().getPixel(xInOverlay, yInOverlay));
                            rgbColor = new Color((Device)Display.getDefault(), pixel);
                            e.gc.setForeground(Display.getDefault().getSystemColor(1));
                            e.gc.setBackground(rgbColor);
                            e.gc.drawRectangle(204, 4, 60, 30);
                            e.gc.fillRectangle(205, 5, 59, 29);
                            rgbColor.dispose();
                            e.gc.drawText("#" + Integer.toHexString(0x1000000 + (pixel.red << 16) + (pixel.green << 8) + pixel.blue).substring(1), 204, 35, true);
                            e.gc.drawText("R:", 280, 4, true);
                            e.gc.drawText("G:", 280, 20, true);
                            e.gc.drawText("B:", 280, 35, true);
                            e.gc.drawText(Integer.toString(pixel.red), 297, 4, true);
                            e.gc.drawText(Integer.toString(pixel.green), 297, 20, true);
                            e.gc.drawText(Integer.toString(pixel.blue), 297, 35, true);
                        }
                    }
                }
            }
        }
    };

    public PixelPerfectPixelPanel(Composite parent) {
        super(parent, 0);
        this.mModel = PixelPerfectModel.getModel();
        this.mModel.addImageChangeListener(this);
        this.addPaintListener(this.mPaintListener);
        this.addDisposeListener(this.mDisposeListener);
        this.imageLoaded();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height = 52;
        int width = wHint == -1 ? 180 : wHint;
        return new Point(width, height);
    }

    private void doRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PixelPerfectPixelPanel.this.redraw();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crosshairMoved() {
        PixelPerfectPixelPanel pixelPerfectPixelPanel = this;
        synchronized (pixelPerfectPixelPanel) {
            this.mCrosshairLocation = this.mModel.getCrosshairLocation();
        }
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageChanged() {
        PixelPerfectPixelPanel pixelPerfectPixelPanel = this;
        synchronized (pixelPerfectPixelPanel) {
            this.mImage = this.mModel.getImage();
        }
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageLoaded() {
        PixelPerfectPixelPanel pixelPerfectPixelPanel = this;
        synchronized (pixelPerfectPixelPanel) {
            this.mImage = this.mModel.getImage();
            this.mCrosshairLocation = this.mModel.getCrosshairLocation();
            this.mOverlayImage = this.mModel.getOverlayImage();
        }
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overlayChanged() {
        PixelPerfectPixelPanel pixelPerfectPixelPanel = this;
        synchronized (pixelPerfectPixelPanel) {
            this.mOverlayImage = this.mModel.getOverlayImage();
        }
        this.doRedraw();
    }

    @Override
    public void overlayTransparencyChanged() {
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    public void treeChanged() {
    }

    @Override
    public void zoomChanged() {
    }
}

