/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmlib.Log;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.SelectionDependentPanel;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.logcat.LogColors;
import com.android.ddmuilib.logcat.LogFilter;
import com.android.ddmuilib.logcat.LogPanel;
import com.android.ide.eclipse.ddms.CommonAction;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.i18n.Messages;
import com.android.ide.eclipse.ddms.views.SelectionDependentViewPart;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;

public final class OldLogCatView
extends SelectionDependentViewPart
implements LogPanel.LogCatViewInterface {
    public static final String ID = "com.android.ide.eclipse.ddms.views.OldLogCatView";
    private static final String PREFS_COL_TIME = "com.android.ide.eclipse.ddms.logcat.time";
    private static final String PREFS_COL_LEVEL = "com.android.ide.eclipse.ddms.logcat.level";
    private static final String PREFS_COL_PID = "com.android.ide.eclipse.ddms.logcat.pid";
    private static final String PREFS_COL_TAG = "com.android.ide.eclipse.ddms.logcat.tag";
    private static final String PREFS_COL_MESSAGE = "com.android.ide.eclipse.ddms.logcat.message";
    private static final String PREFS_FILTERS = "com.android.ide.eclipse.ddms.logcat.filters";
    public static final String CHOICE_METHOD_DECLARATION = "com.android.ide.eclipse.ddms.logcat.MethodDeclaration";
    public static final String CHOICE_ERROR_LINE = "com.android.ide.eclipse.ddms.logcat.ErrorLine";
    public static final boolean DEFAULT_SWITCH_PERSPECTIVE = true;
    public static final String DEFAULT_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";
    private static OldLogCatView sThis;
    private LogPanel mLogPanel;
    private CommonAction mCreateFilterAction;
    private CommonAction mDeleteFilterAction;
    private CommonAction mEditFilterAction;
    private CommonAction mExportAction;
    private CommonAction[] mLogLevelActions;
    private String[] mLogLevelIcons = new String[]{"v.png", "d.png", "i.png", "w.png", "e.png"};
    private Action mClearAction;
    private Clipboard mClipboard;

    public OldLogCatView() {
        sThis = this;
        LogPanel.PREFS_TIME = PREFS_COL_TIME;
        LogPanel.PREFS_LEVEL = PREFS_COL_LEVEL;
        LogPanel.PREFS_PID = PREFS_COL_PID;
        LogPanel.PREFS_TAG = PREFS_COL_TAG;
        LogPanel.PREFS_MESSAGE = PREFS_COL_MESSAGE;
    }

    public static OldLogCatView getInstance() {
        return sThis;
    }

    public static void setFont(Font font) {
        if (sThis != null && OldLogCatView.sThis.mLogPanel != null) {
            OldLogCatView.sThis.mLogPanel.setFont(font);
        }
    }

    public void createPartControl(Composite parent) {
        Display d = parent.getDisplay();
        LogColors colors = new LogColors();
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        colors.infoColor = new Color((Device)d, 0, 127, 0);
        colors.debugColor = new Color((Device)d, 0, 0, 127);
        colors.errorColor = new Color((Device)d, 255, 0, 0);
        colors.warningColor = new Color((Device)d, 255, 127, 0);
        colors.verboseColor = new Color((Device)d, 0, 0, 0);
        this.mCreateFilterAction = new CommonAction(Messages.LogCatView_Create_Filter){

            @Override
            public void run() {
                OldLogCatView.this.mLogPanel.addFilter();
            }
        };
        this.mCreateFilterAction.setToolTipText(Messages.LogCatView_Create_Filter_Tooltip);
        this.mCreateFilterAction.setImageDescriptor(loader.loadDescriptor("add.png"));
        this.mEditFilterAction = new CommonAction(Messages.LogCatView_Edit_Filter){

            @Override
            public void run() {
                OldLogCatView.this.mLogPanel.editFilter();
            }
        };
        this.mEditFilterAction.setToolTipText(Messages.LogCatView_Edit_Filter_Tooltip);
        this.mEditFilterAction.setImageDescriptor(loader.loadDescriptor("edit.png"));
        this.mDeleteFilterAction = new CommonAction(Messages.LogCatView_Delete_Filter){

            @Override
            public void run() {
                OldLogCatView.this.mLogPanel.deleteFilter();
            }
        };
        this.mDeleteFilterAction.setToolTipText(Messages.LogCatView_Delete_Filter_Tooltip);
        this.mDeleteFilterAction.setImageDescriptor(loader.loadDescriptor("delete.png"));
        this.mExportAction = new CommonAction(Messages.LogCatView_Export_Selection_As_Text){

            @Override
            public void run() {
                OldLogCatView.this.mLogPanel.save();
            }
        };
        this.mExportAction.setToolTipText(Messages.LogCatView_Export_Selection_As_Text_Tooltip);
        this.mExportAction.setImageDescriptor(loader.loadDescriptor("save.png"));
        Log.LogLevel[] levels = Log.LogLevel.values();
        this.mLogLevelActions = new CommonAction[this.mLogLevelIcons.length];
        int i = 0;
        while (i < this.mLogLevelActions.length) {
            String name = levels[i].getStringValue();
            this.mLogLevelActions[i] = new CommonAction(name, 2){

                @Override
                public void run() {
                    int j = 0;
                    while (j < OldLogCatView.this.mLogLevelActions.length) {
                        CommonAction a = OldLogCatView.this.mLogLevelActions[j];
                        if (a == this) {
                            a.setChecked(true);
                            OldLogCatView.this.mLogPanel.setCurrentFilterLogLevel(j + 2);
                        } else {
                            a.setChecked(false);
                        }
                        ++j;
                    }
                }
            };
            this.mLogLevelActions[i].setToolTipText(name);
            this.mLogLevelActions[i].setImageDescriptor(loader.loadDescriptor(this.mLogLevelIcons[i]));
            ++i;
        }
        this.mClearAction = new Action(Messages.LogCatView_Clear_Log){

            public void run() {
                OldLogCatView.this.mLogPanel.clear();
            }
        };
        this.mClearAction.setImageDescriptor(loader.loadDescriptor("clear.png"));
        this.mLogPanel = new LogPanel(colors, (LogPanel.ILogFilterStorageManager)new FilterStorage(), 1);
        this.mLogPanel.setLogCatViewInterface((LogPanel.LogCatViewInterface)this);
        this.mLogPanel.setActions((ICommonAction)this.mDeleteFilterAction, (ICommonAction)this.mEditFilterAction, (ICommonAction[])this.mLogLevelActions);
        String fontStr = DdmsPlugin.getDefault().getPreferenceStore().getString("com.android.ide.eclipse.ddms.logcatFont");
        if (fontStr != null) {
            FontData data = new FontData(fontStr);
            if (fontStr != null) {
                this.mLogPanel.setFont(new Font((Device)parent.getDisplay(), data));
            }
        }
        this.mLogPanel.createPanel(parent);
        this.setSelectionDependentPanel((SelectionDependentPanel)this.mLogPanel);
        this.placeActions();
        this.mClipboard = new Clipboard(d);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(Messages.LogCatView_Copy){

            public void run() {
                OldLogCatView.this.mLogPanel.copy(OldLogCatView.this.mClipboard);
            }
        });
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action(Messages.LogCatView_Select_All){

            public void run() {
                OldLogCatView.this.mLogPanel.selectAll();
            }
        });
    }

    @Override
    public void dispose() {
        this.mLogPanel.stopLogCat(true);
        this.mClipboard.dispose();
    }

    public void setFocus() {
        this.mLogPanel.setFocus();
    }

    private void placeActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.mCreateFilterAction);
        menuManager.add((IAction)this.mEditFilterAction);
        menuManager.add((IAction)this.mDeleteFilterAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.mClearAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.mExportAction);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        CommonAction[] commonActionArray = this.mLogLevelActions;
        int n = this.mLogLevelActions.length;
        int n2 = 0;
        while (n2 < n) {
            CommonAction a = commonActionArray[n2];
            toolBarManager.add((IAction)a);
            ++n2;
        }
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.mCreateFilterAction);
        toolBarManager.add((IAction)this.mEditFilterAction);
        toolBarManager.add((IAction)this.mDeleteFilterAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.mClearAction);
    }

    void openFile(IFile file, IMarker marker) {
        try {
            IWorkbenchPage page = this.getViewSite().getWorkbenchWindow().getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
                marker.delete();
            }
        }
        catch (CoreException e) {
            Status s = new Status(4, "com.android.ide.eclipse.ddms", e.getMessage(), (Throwable)e);
            DdmsPlugin.getDefault().getLog().log((IStatus)s);
        }
    }

    void switchPerspective() {
        IPreferenceStore store = DdmsPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("com.android.ide.eclipse.ddms.switchPerspective")) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IPerspectiveRegistry perspectiveRegistry = workbench.getPerspectiveRegistry();
            String perspectiveId = store.getString("com.android.ide.eclipse.ddms.perspectiveId");
            if (perspectiveId != null && perspectiveId.length() > 0 && perspectiveRegistry.findPerspectiveWithId(perspectiveId) != null) {
                try {
                    workbench.showPerspective(perspectiveId, window);
                }
                catch (WorkbenchException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void onDoubleClick() {
    }

    private final class FilterStorage
    implements LogPanel.ILogFilterStorageManager {
        private FilterStorage() {
        }

        public LogFilter[] getFilterFromStore() {
            String filterPrefs = DdmsPlugin.getDefault().getPreferenceStore().getString(OldLogCatView.PREFS_FILTERS);
            String[] filters = filterPrefs.split("\\|");
            ArrayList<LogFilter> list = new ArrayList<LogFilter>(filters.length);
            String[] stringArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                LogFilter logFilter;
                String f = stringArray[n2];
                if (f.length() > 0 && (logFilter = new LogFilter()).loadFromString(f)) {
                    list.add(logFilter);
                }
                ++n2;
            }
            return list.toArray(new LogFilter[list.size()]);
        }

        public void saveFilters(LogFilter[] filters) {
            StringBuilder sb = new StringBuilder();
            LogFilter[] logFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                LogFilter f = logFilterArray[n2];
                String filterString = f.toString();
                sb.append(filterString);
                sb.append('|');
                ++n2;
            }
            DdmsPlugin.getDefault().getPreferenceStore().setValue(OldLogCatView.PREFS_FILTERS, sb.toString());
        }

        public boolean requiresDefaultFilter() {
            return true;
        }
    }
}

