/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.location;

import com.android.ddmuilib.location.LocationPoint;
import com.android.ddmuilib.location.TrackPoint;
import com.android.ddmuilib.location.WayPoint;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GpxParser {
    private static final String NS_GPX = "http://www.topografix.com/GPX/1/1";
    private static final String NODE_WAYPOINT = "wpt";
    private static final String NODE_TRACK = "trk";
    private static final String NODE_TRACK_SEGMENT = "trkseg";
    private static final String NODE_TRACK_POINT = "trkpt";
    private static final String NODE_NAME = "name";
    private static final String NODE_TIME = "time";
    private static final String NODE_ELEVATION = "ele";
    private static final String NODE_DESCRIPTION = "desc";
    private static final String ATTR_LONGITUDE = "lon";
    private static final String ATTR_LATITUDE = "lat";
    private static SAXParserFactory sParserFactory = SAXParserFactory.newInstance();
    private String mFileName;
    private GpxHandler mHandler;
    private static final Pattern ISO8601_TIME;

    public GpxParser(String fileName) {
        this.mFileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parse() {
        try {
            SAXParser parser = sParserFactory.newSAXParser();
            this.mHandler = new GpxHandler();
            parser.parse(new InputSource(new FileReader(this.mFileName)), (DefaultHandler)this.mHandler);
            return this.mHandler.getSuccess();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        catch (SAXException e) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public WayPoint[] getWayPoints() {
        if (this.mHandler != null) {
            return this.mHandler.getWayPoints();
        }
        return null;
    }

    public Track[] getTracks() {
        if (this.mHandler != null) {
            return this.mHandler.getTracks();
        }
        return null;
    }

    static {
        sParserFactory.setNamespaceAware(true);
        ISO8601_TIME = Pattern.compile("(\\d{4})-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(?:(\\.\\d+))?(Z)?");
    }

    public static final class Track {
        private String mName;
        private String mComment;
        private List<TrackPoint> mPoints = new ArrayList<TrackPoint>();

        void setName(String name) {
            this.mName = name;
        }

        public String getName() {
            return this.mName;
        }

        void setComment(String comment) {
            this.mComment = comment;
        }

        public String getComment() {
            return this.mComment;
        }

        void addPoint(TrackPoint trackPoint) {
            this.mPoints.add(trackPoint);
        }

        public TrackPoint[] getPoints() {
            return this.mPoints.toArray(new TrackPoint[this.mPoints.size()]);
        }

        public long getFirstPointTime() {
            if (this.mPoints.size() > 0) {
                return this.mPoints.get(0).getTime();
            }
            return -1L;
        }

        public long getLastPointTime() {
            if (this.mPoints.size() > 0) {
                return this.mPoints.get(this.mPoints.size() - 1).getTime();
            }
            return -1L;
        }

        public int getPointCount() {
            return this.mPoints.size();
        }
    }

    private static class GpxHandler
    extends DefaultHandler {
        List<WayPoint> mWayPoints;
        List<Track> mTrackList;
        Track mCurrentTrack;
        TrackPoint mCurrentTrackPoint;
        WayPoint mCurrentWayPoint;
        final StringBuilder mStringAccumulator = new StringBuilder();
        boolean mSuccess = true;

        private GpxHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            try {
                if (GpxParser.NS_GPX.equals(uri)) {
                    if (GpxParser.NODE_WAYPOINT.equals(localName)) {
                        if (this.mWayPoints == null) {
                            this.mWayPoints = new ArrayList<WayPoint>();
                        }
                        this.mCurrentWayPoint = new WayPoint();
                        this.mWayPoints.add(this.mCurrentWayPoint);
                        this.handleLocation(this.mCurrentWayPoint, attributes);
                    } else if (GpxParser.NODE_TRACK.equals(localName)) {
                        if (this.mTrackList == null) {
                            this.mTrackList = new ArrayList<Track>();
                        }
                        this.mCurrentTrack = new Track();
                        this.mTrackList.add(this.mCurrentTrack);
                    } else if (GpxParser.NODE_TRACK_SEGMENT.equals(localName)) {
                    } else if (GpxParser.NODE_TRACK_POINT.equals(localName) && this.mCurrentTrack != null) {
                        this.mCurrentTrackPoint = new TrackPoint();
                        this.mCurrentTrack.addPoint(this.mCurrentTrackPoint);
                        this.handleLocation(this.mCurrentTrackPoint, attributes);
                    }
                }
            }
            finally {
                this.mStringAccumulator.setLength(0);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.mStringAccumulator.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (GpxParser.NS_GPX.equals(uri)) {
                if (GpxParser.NODE_WAYPOINT.equals(localName)) {
                    this.mCurrentWayPoint = null;
                } else if (GpxParser.NODE_TRACK.equals(localName)) {
                    this.mCurrentTrack = null;
                } else if (GpxParser.NODE_TRACK_POINT.equals(localName)) {
                    this.mCurrentTrackPoint = null;
                } else if (GpxParser.NODE_NAME.equals(localName)) {
                    if (this.mCurrentTrack != null) {
                        this.mCurrentTrack.setName(this.mStringAccumulator.toString());
                    } else if (this.mCurrentWayPoint != null) {
                        this.mCurrentWayPoint.setName(this.mStringAccumulator.toString());
                    }
                } else if (GpxParser.NODE_TIME.equals(localName)) {
                    if (this.mCurrentTrackPoint != null) {
                        this.mCurrentTrackPoint.setTime(this.computeTime(this.mStringAccumulator.toString()));
                    }
                } else if (GpxParser.NODE_ELEVATION.equals(localName)) {
                    if (this.mCurrentTrackPoint != null) {
                        this.mCurrentTrackPoint.setElevation(Double.parseDouble(this.mStringAccumulator.toString()));
                    } else if (this.mCurrentWayPoint != null) {
                        this.mCurrentWayPoint.setElevation(Double.parseDouble(this.mStringAccumulator.toString()));
                    }
                } else if (GpxParser.NODE_DESCRIPTION.equals(localName) && this.mCurrentWayPoint != null) {
                    this.mCurrentWayPoint.setDescription(this.mStringAccumulator.toString());
                }
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.mSuccess = false;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.mSuccess = false;
        }

        private long computeTime(String timeString) {
            Matcher m = ISO8601_TIME.matcher(timeString);
            if (m.matches()) {
                try {
                    int year = Integer.parseInt(m.group(1));
                    int month = Integer.parseInt(m.group(2));
                    int date = Integer.parseInt(m.group(3));
                    int hourOfDay = Integer.parseInt(m.group(4));
                    int minute = Integer.parseInt(m.group(5));
                    int second = Integer.parseInt(m.group(6));
                    int milliseconds = 0;
                    String subSecondGroup = m.group(7);
                    if (subSecondGroup != null) {
                        milliseconds = (int)(1000.0 * Double.parseDouble(subSecondGroup));
                    }
                    boolean utcTime = m.group(8) != null;
                    Calendar c = utcTime ? Calendar.getInstance(TimeZone.getTimeZone("GMT")) : Calendar.getInstance();
                    c.set(year, month, date, hourOfDay, minute, second);
                    return c.getTimeInMillis() + (long)milliseconds;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return -1L;
        }

        private void handleLocation(LocationPoint locationNode, Attributes attributes) {
            try {
                double longitude = Double.parseDouble(attributes.getValue(GpxParser.ATTR_LONGITUDE));
                double latitude = Double.parseDouble(attributes.getValue(GpxParser.ATTR_LATITUDE));
                locationNode.setLocation(longitude, latitude);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        WayPoint[] getWayPoints() {
            if (this.mWayPoints != null) {
                return this.mWayPoints.toArray(new WayPoint[this.mWayPoints.size()]);
            }
            return null;
        }

        Track[] getTracks() {
            if (this.mTrackList != null) {
                return this.mTrackList.toArray(new Track[this.mTrackList.size()]);
            }
            return null;
        }

        boolean getSuccess() {
            return this.mSuccess;
        }
    }
}

