/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.NonNull;
import com.android.ant.MultiFilesTask;
import com.android.ant.TaskHelper;
import com.android.sdklib.io.FileOp;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public class AidlExecTask
extends MultiFilesTask {
    private String mExecutable;
    private String mFramework;
    private Path mLibraryBinAidlFolderPath;
    private String mGenFolder;
    private final ArrayList<Path> mPaths = new ArrayList();
    private String mAidlOutFolder;

    public void setExecutable(Path executable) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", executable);
    }

    public void setFramework(Path value) {
        this.mFramework = TaskHelper.checkSinglePath("framework", value);
    }

    public void setLibraryBinAidlFolderPathRefid(String libraryBinAidlFolderPathRefid) {
        Object libBinAidlRef = this.getProject().getReference(libraryBinAidlFolderPathRefid);
        if (libBinAidlRef instanceof Path) {
            this.mLibraryBinAidlFolderPath = (Path)libBinAidlRef;
        }
    }

    public void setGenFolder(Path value) {
        this.mGenFolder = TaskHelper.checkSinglePath("genFolder", value);
    }

    public void setAidlOutFolder(Path value) {
        this.mAidlOutFolder = TaskHelper.checkSinglePath("aidlOutFolder", value);
    }

    public Path createSource() {
        Path p = new Path(this.getProject());
        this.mPaths.add(p);
        return p;
    }

    public void execute() throws BuildException {
        if (this.mExecutable == null) {
            throw new BuildException("AidlExecTask's 'executable' is required.");
        }
        if (this.mFramework == null) {
            throw new BuildException("AidlExecTask's 'framework' is required.");
        }
        if (this.mGenFolder == null) {
            throw new BuildException("AidlExecTask's 'genFolder' is required.");
        }
        if (this.mAidlOutFolder == null) {
            throw new BuildException("AidlExecTask's 'aidlOutFolder' is required.");
        }
        this.processFiles(new AidlProcessor(), this.mPaths, this.mGenFolder);
    }

    private class AidlProcessor
    implements MultiFilesTask.SourceProcessor {
        private AidlProcessor() {
        }

        @Override
        @NonNull
        public Set<String> getSourceFileExtensions() {
            return Collections.singleton("aidl");
        }

        @Override
        public void process(@NonNull String filePath, @NonNull String sourceFolder, @NonNull List<String> sourceFolders, @NonNull Project taskProject) {
            ExecTask task = new ExecTask();
            task.setProject(taskProject);
            task.setOwningTarget(AidlExecTask.this.getOwningTarget());
            task.setExecutable(AidlExecTask.this.mExecutable);
            task.setTaskName("aidl");
            task.setFailonerror(true);
            task.createArg().setValue("-p" + AidlExecTask.this.mFramework);
            task.createArg().setValue("-o" + AidlExecTask.this.mGenFolder);
            for (String importFolder : sourceFolders) {
                task.createArg().setValue("-I" + importFolder);
            }
            if (AidlExecTask.this.mLibraryBinAidlFolderPath != null) {
                for (String importFolder : AidlExecTask.this.mLibraryBinAidlFolderPath.list()) {
                    task.createArg().setValue("-I" + importFolder);
                }
            }
            task.createArg().setValue("-a");
            task.createArg().setValue(filePath);
            task.execute();
            String relative = filePath.substring(sourceFolder.length());
            if (relative.charAt(0) == '/' || relative.charAt(0) == File.separatorChar) {
                relative = relative.substring(1);
            }
            try {
                File dest = new File(AidlExecTask.this.mAidlOutFolder, relative);
                File parent = dest.getParentFile();
                parent.mkdirs();
                FileOp op = new FileOp();
                op.copyFile(new File(filePath), dest);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }

        @Override
        public void displayMessage(@NonNull MultiFilesTask.DisplayType type, int count) {
            switch (type) {
                case FOUND: {
                    System.out.println(String.format("Found %1$d AIDL files.", count));
                    break;
                }
                case COMPILING: {
                    if (count > 0) {
                        System.out.println(String.format("Compiling %1$d AIDL files.", count));
                        break;
                    }
                    System.out.println("No AIDL files to compile.");
                    break;
                }
                case REMOVE_OUTPUT: {
                    System.out.println(String.format("Found %1$d obsolete output files to remove.", count));
                    break;
                }
                case REMOVE_DEP: {
                    System.out.println(String.format("Found %1$d obsolete dependency files to remove.", count));
                }
            }
        }

        @Override
        public void removedOutput(@NonNull File file) {
        }
    }
}

