/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.DependencyHelper;
import com.android.ant.GetLibraryPathTask;
import com.android.ant.TaskHelper;
import com.android.io.FileWrapper;
import com.android.sdklib.build.RenderScriptProcessor;
import com.android.sdklib.internal.project.IPropertySource;
import com.android.xml.AndroidManifest;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

public class ComputeDependencyTask
extends GetLibraryPathTask {
    private String mLibraryManifestFilePathOut;
    private String mLibraryResFolderPathOut;
    private String mLibraryPackagesOut;
    private String mJarLibraryPathOut;
    private String mLibraryNativeFolderPathOut;
    private String mLibraryBinAidlFolderPathOut;
    private String mLibraryRFilePathOut;
    private int mTargetApi = -1;
    private boolean mVerbose = false;
    private boolean mRenderscriptSupportMode;
    private String mBuildToolsFolder;
    private String mRenderscriptSupportLibsOut;

    public void setLibraryManifestFilePathOut(String libraryManifestFilePathOut) {
        this.mLibraryManifestFilePathOut = libraryManifestFilePathOut;
    }

    public void setLibraryResFolderPathOut(String libraryResFolderPathOut) {
        this.mLibraryResFolderPathOut = libraryResFolderPathOut;
    }

    public void setLibraryPackagesOut(String libraryPackagesOut) {
        this.mLibraryPackagesOut = libraryPackagesOut;
    }

    public void setJarLibraryPathOut(String jarLibraryPathOut) {
        this.mJarLibraryPathOut = jarLibraryPathOut;
    }

    public void setLibraryBinAidlFolderPathOut(String libraryBinAidlFolderPathOut) {
        this.mLibraryBinAidlFolderPathOut = libraryBinAidlFolderPathOut;
    }

    public void setLibraryRFilePathOut(String libraryRFilePathOut) {
        this.mLibraryRFilePathOut = libraryRFilePathOut;
    }

    public void setLibraryNativeFolderPathOut(String libraryNativeFolderPathOut) {
        this.mLibraryNativeFolderPathOut = libraryNativeFolderPathOut;
    }

    public void setTargetApi(int targetApi) {
        this.mTargetApi = targetApi;
    }

    public void setRenderscriptSupportMode(boolean renderscriptSupportMode) {
        this.mRenderscriptSupportMode = renderscriptSupportMode;
    }

    public void setBuildToolsFolder(String folder) {
        this.mBuildToolsFolder = folder;
    }

    public void setRenderscriptSupportLibsOut(String renderscriptSupportLibsOut) {
        this.mRenderscriptSupportLibsOut = renderscriptSupportLibsOut;
    }

    @Override
    public void execute() throws BuildException {
        File projectFolder;
        File libsFolder;
        File[] jarFiles;
        if (this.mLibraryManifestFilePathOut == null) {
            throw new BuildException("Missing attribute libraryManifestFilePathOut");
        }
        if (this.mLibraryResFolderPathOut == null) {
            throw new BuildException("Missing attribute libraryResFolderPathOut");
        }
        if (this.mLibraryPackagesOut == null) {
            throw new BuildException("Missing attribute libraryPackagesOut");
        }
        if (this.mJarLibraryPathOut == null) {
            throw new BuildException("Missing attribute jarLibraryPathOut");
        }
        if (this.mLibraryNativeFolderPathOut == null) {
            throw new BuildException("Missing attribute libraryNativeFolderPathOut");
        }
        if (this.mLibraryBinAidlFolderPathOut == null) {
            throw new BuildException("Missing attribute libraryBinFolderPathOut");
        }
        if (this.mLibraryRFilePathOut == null) {
            throw new BuildException("Missing attribute libraryRFilePathOut");
        }
        if (this.mTargetApi == -1) {
            throw new BuildException("Missing attribute targetApi");
        }
        if (this.mBuildToolsFolder == null) {
            throw new BuildException("Missing attribute buildToolsFolder");
        }
        if (this.mRenderscriptSupportLibsOut == null) {
            throw new BuildException("Missing attribute renderscriptSupportLibsOut");
        }
        final Project antProject = this.getProject();
        File sdkDir = TaskHelper.getSdkLocation(antProject);
        final Path manifestFilePath = new Path(antProject);
        final Path resFolderPath = new Path(antProject);
        final Path nativeFolderPath = new Path(antProject);
        final Path binAidlFolderPath = new Path(antProject);
        final Path rFilePath = new Path(antProject);
        final StringBuilder packageStrBuilder = new StringBuilder();
        DependencyHelper.JarProcessor processor = new DependencyHelper.JarProcessor(){

            @Override
            public void processLibrary(String libRootPath, IPropertySource properties) {
                super.processLibrary(libRootPath, properties);
                Path.PathElement element = manifestFilePath.createPathElement();
                element.setPath(libRootPath + '/' + "AndroidManifest.xml");
                element = resFolderPath.createPathElement();
                element.setPath(libRootPath + '/' + "bin" + '/' + "res");
                element = resFolderPath.createPathElement();
                element.setPath(libRootPath + '/' + "res");
                element = nativeFolderPath.createPathElement();
                element.setPath(libRootPath + '/' + "libs");
                element = binAidlFolderPath.createPathElement();
                element.setPath(libRootPath + '/' + "bin" + '/' + "aidl");
                FileWrapper manifest = new FileWrapper(libRootPath, "AndroidManifest.xml");
                try {
                    String value = AndroidManifest.getPackage(manifest);
                    if (value != null) {
                        packageStrBuilder.append(';');
                        packageStrBuilder.append(value);
                        element = rFilePath.createPathElement();
                        element.setPath(libRootPath + "/" + "bin" + "/" + "R.txt");
                    }
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        };
        List<File> jars = processor.getJars();
        Path libraryFolderPath = (Path)antProject.getReference(this.getLibraryFolderPathOut());
        if (libraryFolderPath == null) {
            this.execute(processor);
        } else {
            System.out.println("Ordered libraries:");
            String[] libraries = libraryFolderPath.list();
            for (int i = libraries.length - 1; i >= 0; --i) {
                String libRootPath = libraries[i];
                System.out.println(libRootPath);
                processor.processLibrary(libRootPath);
            }
        }
        boolean hasLibraries = !jars.isEmpty();
        System.out.println("\n------------------");
        if (this.mTargetApi <= 15) {
            System.out.println("API<=15: Adding annotations.jar to the classpath.");
            jars.add(new File(sdkDir, "tools/support/annotations.jar"));
        }
        Path rsSupportPath = new Path(antProject);
        if (this.mRenderscriptSupportMode) {
            File renderScriptSupportJar = RenderScriptProcessor.getSupportJar(this.mBuildToolsFolder);
            System.out.println("Renderscript support mode: Adding " + renderScriptSupportJar.getName() + " to the classpath.");
            jars.add(renderScriptSupportJar);
            Path.PathElement element = rsSupportPath.createPathElement();
            element.setPath(RenderScriptProcessor.getSupportNativeLibFolder(this.mBuildToolsFolder).getAbsolutePath());
        }
        antProject.addReference(this.mRenderscriptSupportLibsOut, (Object)rsSupportPath);
        antProject.addReference(this.mLibraryNativeFolderPathOut, (Object)nativeFolderPath);
        antProject.addReference(this.mLibraryManifestFilePathOut, (Object)manifestFilePath);
        antProject.addReference(this.mLibraryBinAidlFolderPathOut, (Object)binAidlFolderPath);
        if (hasLibraries) {
            antProject.addReference(this.mLibraryResFolderPathOut, (Object)resFolderPath);
            antProject.setProperty(this.mLibraryPackagesOut, packageStrBuilder.toString());
            antProject.addReference(this.mLibraryRFilePathOut, (Object)rFilePath);
        }
        if ((jarFiles = (libsFolder = new File(projectFolder = antProject.getBaseDir(), "libs")).listFiles(processor.getFilter())) != null) {
            Collections.addAll(jars, jarFiles);
        }
        jars = DependencyHelper.sanitizePaths(projectFolder, new IPropertySource(){

            @Override
            public String getProperty(String name) {
                return antProject.getProperty(name);
            }

            @Override
            public void debugPrint() {
            }
        }, jars);
        Path jarsPath = new Path(antProject);
        if (this.mVerbose) {
            System.out.println("\n------------------\nSanitized jar list:");
        }
        for (File f : jars) {
            if (this.mVerbose) {
                System.out.println("- " + f.getAbsolutePath());
            }
            Path.PathElement element = jarsPath.createPathElement();
            element.setPath(f.getAbsolutePath());
        }
        antProject.addReference(this.mJarLibraryPathOut, (Object)jarsPath);
        if (this.mVerbose) {
            System.out.println();
        }
    }
}

