/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ant.DependencyHelper;
import com.android.ant.TaskHelper;
import com.android.sdklib.internal.project.IPropertySource;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class GetLibraryPathTask
extends Task {
    private String mProjectPath;
    private String mLibraryFolderPathOut;
    private String mLeaf;
    private boolean mVerbose = false;

    public void setProjectPath(String projectPath) {
        this.mProjectPath = projectPath;
    }

    public void setLibraryFolderPathOut(String libraryFolderPathOut) {
        this.mLibraryFolderPathOut = libraryFolderPathOut;
    }

    protected String getLibraryFolderPathOut() {
        return this.mLibraryFolderPathOut;
    }

    public void setLeaf(String leaf) {
        this.mLeaf = leaf;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    protected boolean getVerbose() {
        return this.mVerbose;
    }

    public void execute() throws BuildException {
        if (this.mLibraryFolderPathOut == null) {
            throw new BuildException("Missing attribute libraryFolderPathOut");
        }
        LeafProcessor processor = null;
        if (this.mLeaf != null) {
            processor = new LeafProcessor(this.getProject(), this.mLeaf);
        }
        if (this.mProjectPath == null) {
            this.execute(processor);
        } else {
            DependencyHelper helper = new DependencyHelper(new File(this.mProjectPath), this.mVerbose);
            this.execute(helper, processor);
        }
    }

    protected void execute(@Nullable DependencyHelper.LibraryProcessor processor) throws BuildException {
        final Project antProject = this.getProject();
        DependencyHelper helper = new DependencyHelper(antProject.getBaseDir(), new IPropertySource(){

            @Override
            public String getProperty(String name) {
                return antProject.getProperty(name);
            }

            @Override
            public void debugPrint() {
            }
        }, this.mVerbose);
        this.execute(helper, processor);
    }

    private void execute(@NonNull DependencyHelper helper, @Nullable DependencyHelper.LibraryProcessor processor) throws BuildException {
        Project antProject = this.getProject();
        System.out.println("Library dependencies:");
        Path path = new Path(antProject);
        if (helper.getLibraryCount() > 0) {
            System.out.println("\n------------------\nOrdered libraries:");
            helper.processLibraries(processor);
            if (this.mLibraryFolderPathOut != null) {
                if (this.mLeaf == null) {
                    List<File> libraries = helper.getLibraries();
                    for (int i = libraries.size() - 1; i >= 0; --i) {
                        File library = libraries.get(i);
                        Path.PathElement element = path.createPathElement();
                        element.setPath(library.getAbsolutePath());
                    }
                } else {
                    path = ((LeafProcessor)processor).getPath();
                }
            }
        } else {
            System.out.println("No Libraries");
        }
        antProject.addReference(this.mLibraryFolderPathOut, (Object)path);
    }

    private static class LeafProcessor
    extends DependencyHelper.AdvancedLibraryProcessor {
        private static final Pattern PH = Pattern.compile("^\\@\\{(.*)\\}$");
        private Path mPath;
        private final String[] mLeafSegments;

        LeafProcessor(Project antProject, String leaf) {
            this.mPath = new Path(antProject);
            this.mLeafSegments = leaf.split("/");
        }

        @Override
        public void processLibrary(String libRootPath, IPropertySource properties) {
            StringBuilder sb = new StringBuilder(libRootPath);
            for (String segment : this.mLeafSegments) {
                sb.append('/');
                Matcher m = PH.matcher(segment);
                if (m.matches()) {
                    String value = properties.getProperty(m.group(1));
                    if (value == null) {
                        value = TaskHelper.getDefault(m.group(1));
                    }
                    if (value == null) {
                        throw new BuildException("Failed to resolve '" + m.group(1) + "' for project " + libRootPath);
                    }
                    sb.append(value);
                    continue;
                }
                sb.append(segment);
            }
            Path.PathElement element = this.mPath.createPathElement();
            element.setPath(sb.toString());
        }

        @NonNull
        public Path getPath() {
            return this.mPath;
        }
    }
}

