/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeTabDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.TabFolderDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabItemDrawData
extends DrawData {
    public TabFolderDrawData parent;
    public int position;

    public TabItemDrawData() {
        this.state = new int[1];
    }

    Rectangle computeTrim(Theme theme, GC gC) {
        int[] nArray = new int[1];
        OS.GetThemeMetric(11, nArray);
        int n = this.clientArea.x - nArray[0];
        int n2 = this.clientArea.y - nArray[0];
        int n3 = this.clientArea.width + nArray[0] * 2;
        int n4 = this.clientArea.height + nArray[0] * 2;
        return new Rectangle(n, n2, n3, n4);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height;
        CGRect cGRect2 = this.clientArea != null ? new CGRect() : null;
        HIThemeTabDrawInfo hIThemeTabDrawInfo = this.getInfo();
        OS.HIThemeDrawTab(cGRect, hIThemeTabDrawInfo, gC.handle, 0, cGRect2);
        if (this.clientArea != null) {
            this.clientArea.x = (int)cGRect2.x;
            this.clientArea.y = (int)cGRect2.y;
            this.clientArea.width = (int)cGRect2.width;
            this.clientArea.height = (int)cGRect2.height;
        }
    }

    HIThemeTabDrawInfo getInfo() {
        int n = this.state[0];
        HIThemeTabDrawInfo hIThemeTabDrawInfo = new HIThemeTabDrawInfo();
        hIThemeTabDrawInfo.version = 1;
        hIThemeTabDrawInfo.style = (n & 0x20) == 0 ? ((n & 0x10) != 0 ? ((n & 2) != 0 ? (short)3 : ((n & 8) != 0 ? (short)1 : 0)) : ((n & 2) != 0 ? (short)4 : (short)2)) : ((n & 0x10) != 0 ? (short)6 : (short)5);
        hIThemeTabDrawInfo.direction = 0;
        if ((this.parent.style & 0x400) != 0) {
            hIThemeTabDrawInfo.direction = 1;
        }
        if ((this.parent.style & 0x80) != 0) {
            hIThemeTabDrawInfo.direction = 0;
        }
        hIThemeTabDrawInfo.size = 0;
        if ((n & 4) != 0) {
            hIThemeTabDrawInfo.adornment = 4;
        }
        hIThemeTabDrawInfo.adornment |= 0x10;
        hIThemeTabDrawInfo.position = 1;
        if ((this.position & 0x20000) != 0 && (this.position & 0x4000) != 0) {
            hIThemeTabDrawInfo.position = 3;
        } else if ((this.position & 0x4000) != 0) {
            hIThemeTabDrawInfo.position = 0;
            hIThemeTabDrawInfo.adornment |= 0x10;
        } else if ((this.position & 0x20000) != 0) {
            hIThemeTabDrawInfo.position = 2;
        }
        return hIThemeTabDrawInfo;
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        return 0;
    }
}

