/*
 * Decompiled with CFR 0.152.
 */
package org.clearsilver.jni;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.clearsilver.CSFileLoader;
import org.clearsilver.HDF;
import org.clearsilver.jni.JNI;

public class JniHdf
implements HDF {
    long hdfptr;
    JniHdf root;
    private CSFileLoader fileLoader = null;

    static JniHdf cast(HDF hdf) {
        if (!(hdf instanceof JniHdf)) {
            throw new IllegalArgumentException("HDF object not of type JniHdf.  Make sure you use the same ClearsilverFactory to construct all related HDF and CS objects.");
        }
        return (JniHdf)hdf;
    }

    public JniHdf() {
        this.hdfptr = JniHdf._init();
        this.root = null;
    }

    protected JniHdf(long hdfptr, JniHdf parent) {
        this.hdfptr = hdfptr;
        this.root = parent.root != null ? parent.root : parent;
    }

    protected JniHdf newHdf(long hdfptr, HDF parent) {
        return new JniHdf(hdfptr, JniHdf.cast(parent));
    }

    public void close() {
        if (this.root == null && this.hdfptr != 0L) {
            JniHdf._dealloc(this.hdfptr);
            this.hdfptr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean readFile(String filename) throws IOException {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return this._readFile(this.hdfptr, filename, this.fileLoader != null);
    }

    protected String fileLoad(String filename) throws IOException {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        CSFileLoader aFileLoader = this.fileLoader;
        if (aFileLoader == null) {
            throw new NullPointerException("No fileLoader specified.");
        }
        String result = aFileLoader.load(this, filename);
        if (result == null) {
            throw new NullPointerException("CSFileLoader.load() returned null");
        }
        return result;
    }

    public CSFileLoader getFileLoader() {
        return this.fileLoader;
    }

    public void setFileLoader(CSFileLoader fileLoader) {
        this.fileLoader = fileLoader;
    }

    public boolean writeFile(String filename) throws IOException {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._writeFile(this.hdfptr, filename);
    }

    public boolean readString(String data) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._readString(this.hdfptr, data);
    }

    public String writeString() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._writeString(this.hdfptr);
    }

    public int getIntValue(String hdfname, int default_value) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._getIntValue(this.hdfptr, hdfname, default_value);
    }

    public String getValue(String hdfname, String default_value) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._getValue(this.hdfptr, hdfname, default_value);
    }

    public void setValue(String hdfname, String value) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        JniHdf._setValue(this.hdfptr, hdfname, value);
    }

    public void removeTree(String hdfname) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        JniHdf._removeTree(this.hdfptr, hdfname);
    }

    public void setSymLink(String hdf_name_src, String hdf_name_dest) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        JniHdf._setSymLink(this.hdfptr, hdf_name_src, hdf_name_dest);
    }

    public void exportDate(String hdfname, TimeZone timeZone, Date date) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTime(date);
        String sec = Integer.toString(cal.get(13));
        this.setValue(hdfname + ".sec", sec.length() == 1 ? "0" + sec : sec);
        String min = Integer.toString(cal.get(12));
        this.setValue(hdfname + ".min", min.length() == 1 ? "0" + min : min);
        this.setValue(hdfname + ".24hour", Integer.toString(cal.get(11)));
        this.setValue(hdfname + ".hour", Integer.toString(cal.get(10) == 0 ? 12 : cal.get(10)));
        this.setValue(hdfname + ".am", cal.get(9) == 0 ? "1" : "0");
        this.setValue(hdfname + ".mday", Integer.toString(cal.get(5)));
        this.setValue(hdfname + ".mon", Integer.toString(cal.get(2) + 1));
        this.setValue(hdfname + ".year", Integer.toString(cal.get(1)));
        this.setValue(hdfname + ".2yr", Integer.toString(cal.get(1)).substring(2));
        this.setValue(hdfname + ".wday", Integer.toString(cal.get(7) - 1));
        boolean tzNegative = timeZone.getRawOffset() < 0;
        int tzAbsolute = Math.abs(timeZone.getRawOffset() / 1000);
        String tzHour = Integer.toString(tzAbsolute / 3600);
        String tzMin = Integer.toString(tzAbsolute / 60 - tzAbsolute / 3600 * 60);
        String tzString = (tzNegative ? "-" : "+") + (tzHour.length() == 1 ? "0" + tzHour : tzHour) + (tzMin.length() == 1 ? "0" + tzMin : tzMin);
        this.setValue(hdfname + ".tzoffset", tzString);
    }

    public void exportDate(String hdfname, String tz, int tt) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        TimeZone timeZone = TimeZone.getTimeZone(tz);
        if (timeZone == null) {
            throw new RuntimeException("Unknown timezone: " + tz);
        }
        Date date = new Date((long)tt * 1000L);
        this.exportDate(hdfname, timeZone, date);
    }

    public JniHdf getObj(String hdfpath) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long obj_ptr = JniHdf._getObj(this.hdfptr, hdfpath);
        if (obj_ptr == 0L) {
            return null;
        }
        return this.newHdf(obj_ptr, this);
    }

    public JniHdf getChild(String hdfpath) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long obj_ptr = JniHdf._getChild(this.hdfptr, hdfpath);
        if (obj_ptr == 0L) {
            return null;
        }
        return this.newHdf(obj_ptr, this);
    }

    public JniHdf getRootObj() {
        return this.root != null ? this.root : this;
    }

    public boolean belongsToSameRoot(HDF hdf) {
        JniHdf jniHdf = JniHdf.cast(hdf);
        return this.getRootObj() == jniHdf.getRootObj();
    }

    public JniHdf getOrCreateObj(String hdfpath) {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long obj_ptr = JniHdf._getObj(this.hdfptr, hdfpath);
        if (obj_ptr == 0L) {
            JniHdf._setValue(this.hdfptr, hdfpath, "");
            obj_ptr = JniHdf._getObj(this.hdfptr, hdfpath);
            if (obj_ptr == 0L) {
                return null;
            }
        }
        return this.newHdf(obj_ptr, this);
    }

    public String objName() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._objName(this.hdfptr);
    }

    public String objValue() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._objValue(this.hdfptr);
    }

    public JniHdf objChild() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long child_ptr = JniHdf._objChild(this.hdfptr);
        if (child_ptr == 0L) {
            return null;
        }
        return this.newHdf(child_ptr, this);
    }

    public JniHdf objNext() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        long next_ptr = JniHdf._objNext(this.hdfptr);
        if (next_ptr == 0L) {
            return null;
        }
        return this.newHdf(next_ptr, this);
    }

    public void copy(String hdfpath, HDF src) {
        JniHdf source = JniHdf.cast(src);
        if (this.hdfptr == 0L || source.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        JniHdf._copy(this.hdfptr, hdfpath, source.hdfptr);
    }

    public String dump() {
        if (this.hdfptr == 0L) {
            throw new NullPointerException("HDF is closed.");
        }
        return JniHdf._dump(this.hdfptr);
    }

    private static native long _init();

    private static native void _dealloc(long var0);

    private native boolean _readFile(long var1, String var3, boolean var4) throws IOException;

    private static native boolean _writeFile(long var0, String var2);

    private static native boolean _readString(long var0, String var2);

    private static native String _writeString(long var0);

    private static native int _getIntValue(long var0, String var2, int var3);

    private static native String _getValue(long var0, String var2, String var3);

    private static native void _setValue(long var0, String var2, String var3);

    private static native void _removeTree(long var0, String var2);

    private static native void _setSymLink(long var0, String var2, String var3);

    private static native long _getObj(long var0, String var2);

    private static native long _getChild(long var0, String var2);

    private static native long _objChild(long var0);

    private static native long _objNext(long var0);

    private static native String _objName(long var0);

    private static native String _objValue(long var0);

    private static native void _copy(long var0, String var2, long var3);

    private static native String _dump(long var0);

    static {
        JNI.loadLibrary();
    }
}

