/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.datanucleus.DatastoreFieldManager;
import com.google.appengine.datanucleus.DatastoreServiceFactoryInternal;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.mapping.InsertMappingConsumer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.util.NucleusLogger;

public class FetchFieldManager
extends DatastoreFieldManager {
    private static final int[] NOT_USED = new int[]{0};
    private static final String ILLEGAL_NULL_ASSIGNMENT_ERROR_FORMAT = "Datastore entity with kind %s and key %s has a null property named %s.  This property is mapped to %s, which cannot accept null values.";

    public FetchFieldManager(ObjectProvider op, Entity datastoreEntity, int[] fieldNumbers) {
        super(op, datastoreEntity, fieldNumbers);
    }

    public FetchFieldManager(ObjectProvider op, Entity datastoreEntity) {
        super(op, datastoreEntity, null);
    }

    public boolean fetchBooleanField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Boolean.valueOf(dflt);
            }
            return false;
        }
        return (Boolean)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Byte.valueOf(dflt);
            }
            return 0;
        }
        return (Byte)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null && dflt.length() > 0) {
                return dflt.charAt(0);
            }
            return '\u0000';
        }
        return ((Character)this.checkAssignmentToNotNullField(value, fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Double.valueOf(dflt);
            }
            return 0.0;
        }
        return (Double)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Float.valueOf(dflt).floatValue();
            }
            return 0.0f;
        }
        return ((Float)this.checkAssignmentToNotNullField(value, fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Integer.valueOf(dflt);
            }
            return 0;
        }
        return (Integer)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Long.valueOf(dflt);
            }
            return 0L;
        }
        return (Long)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Short.valueOf(dflt);
            }
            return 0;
        }
        return (Short)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public String fetchStringField(int fieldNumber) {
        if (this.isPK(fieldNumber)) {
            return this.fetchStringPKField(fieldNumber);
        }
        if (MetaDataUtils.isParentPKField(this.getClassMetaData(), fieldNumber)) {
            return this.fetchParentStringPKField(fieldNumber);
        }
        if (MetaDataUtils.isPKNameField(this.getClassMetaData(), fieldNumber)) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            if (!mmd.getType().equals(String.class)) {
                throw new NucleusFatalUserException("Field with \"gae.pk-name\" extension must be of type String");
            }
            return this.fetchPKNameField();
        }
        Object fieldVal = this.fetchFieldFromEntity(fieldNumber);
        if (fieldVal instanceof Text) {
            fieldVal = ((Text)fieldVal).getValue();
        }
        return (String)fieldVal;
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
        if (ammd.getEmbeddedMetaData() != null) {
            return this.fetchEmbeddedField(ammd, fieldNumber);
        }
        if (ammd.getRelationType(this.getClassLoaderResolver()) != 0 && !ammd.isSerialized()) {
            return this.fetchRelationField(this.getClassLoaderResolver(), ammd);
        }
        return this.fetchFieldFromEntity(fieldNumber);
    }

    Object fetchFieldFromEntity(int fieldNumber) {
        AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
        if (this.isPK(fieldNumber)) {
            if (ammd.getType().equals(Key.class)) {
                return this.datastoreEntity.getKey();
            }
            if (ammd.getType().equals(Long.class) || ammd.getType().equals(Long.TYPE)) {
                return this.datastoreEntity.getKey().getId();
            }
            throw this.exceptionForUnexpectedKeyType("Primary key", fieldNumber);
        }
        if (MetaDataUtils.isParentPKField(this.getClassMetaData(), fieldNumber)) {
            if (ammd.getType().equals(Key.class)) {
                return this.datastoreEntity.getKey().getParent();
            }
            throw this.exceptionForUnexpectedKeyType("Parent key", fieldNumber);
        }
        if (MetaDataUtils.isPKIdField(this.getClassMetaData(), fieldNumber)) {
            return this.fetchPKIdField();
        }
        Object value = this.datastoreEntity.getProperty(this.getPropertyName(fieldNumber));
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        if (ammd.isSerialized()) {
            if (value != null) {
                value = this.deserializeFieldValue(value, clr, ammd);
            }
        } else {
            if (ammd.getAbsoluteFieldNumber() == -1) {
                ammd = this.getClassMetaData().getMetaDataForMember(ammd.getName());
            }
            TypeManager typeMgr = this.op.getExecutionContext().getNucleusContext().getTypeManager();
            value = this.getConversionUtils().datastoreValueToPojoValue(typeMgr, clr, value, ammd);
            if (value != null && !(value instanceof SCO)) {
                value = this.getObjectProvider().wrapSCOField(fieldNumber, value, false, false, true);
            }
        }
        return value;
    }

    Object fetchRelationField(ClassLoaderResolver clr, AbstractMemberMetaData ammd) {
        Object value;
        DatastoreTable dt = this.getDatastoreTable();
        JavaTypeMapping mapping = dt.getMemberMappingInDatastoreClass(ammd);
        if (mapping instanceof EmbeddedPCMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping) {
            value = mapping.getObject(this.getExecutionContext(), (Object)this.datastoreEntity, NOT_USED, this.getObjectProvider(), ammd.getAbsoluteFieldNumber());
        } else {
            int relationType = ammd.getRelationType(clr);
            if (relationType == 2 || relationType == 1) {
                if (!MetaDataUtils.isOwnedRelation(ammd)) {
                    return this.lookupOneToOneChild(ammd, clr);
                }
                DatastoreTable table = this.getDatastoreTable();
                value = table.isParentKeyProvider(ammd) ? this.lookupParent(ammd, mapping, false) : this.lookupOneToOneChild(ammd, clr);
            } else if (relationType == 6) {
                if (!MetaDataUtils.isOwnedRelation(ammd)) {
                    value = this.lookupOneToOneChild(ammd, clr);
                } else {
                    MetaData parent;
                    MetaData other = ammd.getRelatedMemberMetaData(clr)[0].getParent();
                    boolean allowNullParent = other == (parent = ammd.getParent()) && this.datastoreEntity.getKey().getParent() == null;
                    value = this.lookupParent(ammd, mapping, allowNullParent);
                }
            } else {
                value = null;
            }
        }
        return this.getObjectProvider().wrapSCOField(ammd.getAbsoluteFieldNumber(), value, false, false, false);
    }

    private Object lookupParent(AbstractMemberMetaData ammd, JavaTypeMapping mapping, boolean allowNullParent) {
        Key parentKey = this.datastoreEntity.getParent();
        if (parentKey == null) {
            if (!allowNullParent) {
                String childClass = this.getObjectProvider().getClassMetaData().getFullClassName();
                throw new NucleusFatalUserException("Field " + ammd.getFullFieldName() + " should be able to " + "provide a reference to its parent but the entity does not have a parent.  " + "Did you perhaps try to establish an instance of " + childClass + " as " + "the child of an instance of " + ammd.getTypeName() + " after the child had already been " + "persisted?");
            }
            return null;
        }
        return mapping.getObject(this.getObjectProvider().getExecutionContext(), (Object)parentKey, NOT_USED);
    }

    private Object lookupOneToOneChild(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        ExecutionContext ec = this.getObjectProvider().getExecutionContext();
        AbstractClassMetaData childCmd = ec.getMetaDataManager().getMetaDataForClass(ammd.getType(), clr);
        String kind = this.getStoreManager().getIdentifierFactory().newDatastoreContainerIdentifier(childCmd).getIdentifierName();
        if (MetaDataUtils.readRelatedKeysFromParent(this.getStoreManager(), ammd)) {
            String propName = EntityUtils.getPropertyName(this.getStoreManager().getIdentifierFactory(), ammd);
            if (this.datastoreEntity.hasProperty(propName)) {
                Object value = this.datastoreEntity.getProperty(propName);
                if (value == null) {
                    return null;
                }
                if (value instanceof Key) {
                    DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
                    DatastoreService datastoreService = DatastoreServiceFactoryInternal.getDatastoreService(config);
                    try {
                        Entity childEntity = datastoreService.get((Key)value);
                        return EntityUtils.entityToPojo(childEntity, childCmd, clr, ec, false, ec.getFetchPlan());
                    }
                    catch (EntityNotFoundException enfe) {
                        NucleusLogger.PERSISTENCE.error((Object)("Field " + ammd.getFullFieldName() + " of " + this.getObjectProvider().getInternalObjectId() + " was pointing to object with key " + value + " but this doesn't exist!"));
                        return null;
                    }
                }
            } else if (MetaDataUtils.isOwnedRelation(ammd)) {
                NucleusLogger.PERSISTENCE.info((Object)("Persistable object at field " + ammd.getFullFieldName() + " of " + this.op + " not yet migrated to latest storage version, so reading the object via its parent key"));
            } else {
                throw new NucleusException("Object " + this.datastoreEntity.getKey() + " has unowned property " + ammd.getFullFieldName() + " but no corresponding property " + propName + " on its datastore entity.");
            }
        }
        Entity parentEntity = this.datastoreEntity;
        Query q = new Query(kind, parentEntity.getKey());
        DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
        DatastoreService datastoreService = DatastoreServiceFactoryInternal.getDatastoreService(config);
        for (Entity e : datastoreService.prepare(q).asIterable()) {
            if (!parentEntity.getKey().equals((Object)e.getKey().getParent())) continue;
            return EntityUtils.entityToPojo(e, childCmd, clr, ec, false, ec.getFetchPlan());
        }
        return null;
    }

    private Object checkAssignmentToNotNullField(Object val, int fieldNumber) {
        if (val != null) {
            return val;
        }
        AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
        String propertyName = this.getPropertyName(fieldNumber);
        String msg = String.format(ILLEGAL_NULL_ASSIGNMENT_ERROR_FORMAT, this.datastoreEntity.getKind(), this.datastoreEntity.getKey(), propertyName, ammd.getFullFieldName());
        throw new NullPointerException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchEmbeddedField(AbstractMemberMetaData ammd, int fieldNumber) {
        ObjectProvider eop = this.getEmbeddedObjectProvider(ammd, fieldNumber, null);
        InsertMappingConsumer mappingConsumer = this.buildMappingConsumer(eop.getClassMetaData(), this.getClassLoaderResolver(), eop.getClassMetaData().getAllMemberPositions(), ammd.getEmbeddedMetaData());
        DatastoreFieldManager.AbstractMemberMetaDataProvider ammdProvider = this.getEmbeddedAbstractMemberMetaDataProvider(mappingConsumer);
        this.fieldManagerStateStack.addFirst(new DatastoreFieldManager.FieldManagerState(eop, ammdProvider, mappingConsumer, true));
        try {
            AbstractClassMetaData acmd = eop.getClassMetaData();
            eop.replaceFields(acmd.getAllMemberPositions(), (FieldManager)this);
            if (ammd.getEmbeddedMetaData() != null && ammd.getEmbeddedMetaData().getNullIndicatorColumn() != null) {
                String nullColumn = ammd.getEmbeddedMetaData().getNullIndicatorColumn();
                String nullValue = ammd.getEmbeddedMetaData().getNullIndicatorValue();
                AbstractMemberMetaData[] embMmds = ammd.getEmbeddedMetaData().getMemberMetaData();
                AbstractMemberMetaData nullMmd = null;
                for (int i = 0; i < embMmds.length; ++i) {
                    ColumnMetaData[] colmds = embMmds[i].getColumnMetaData();
                    if (colmds == null || colmds[0].getName() == null || !colmds[0].getName().equals(nullColumn)) continue;
                    nullMmd = embMmds[i];
                    break;
                }
                if (nullMmd != null) {
                    int nullFieldPos = eop.getClassMetaData().getAbsolutePositionOfMember(nullMmd.getName());
                    Object val = eop.provideField(nullFieldPos);
                    if (val == null && nullValue == null) {
                        Object var13_15 = null;
                        return var13_15;
                    }
                    if (val != null && nullValue != null && val.equals(nullValue)) {
                        Object var13_16 = null;
                        return var13_16;
                    }
                }
                Object object = eop.getObject();
                return object;
            }
            Object object = eop.getObject();
            return object;
        }
        finally {
            this.fieldManagerStateStack.removeFirst();
        }
    }

    private Object deserializeFieldValue(Object value, ClassLoaderResolver clr, AbstractMemberMetaData ammd) {
        if (!(value instanceof Blob)) {
            throw new NucleusException("Datastore value is of type " + value.getClass().getName() + " (must be Blob).").setFatal();
        }
        return this.getStoreManager().getSerializationManager().deserialize(clr, ammd, (Blob)value);
    }

    private String fetchPKNameField() {
        Key key = this.datastoreEntity.getKey();
        if (key.getName() == null) {
            throw new NucleusFatalUserException("Attempting to fetch field with \"gae.pk-name\" extension but the entity is identified by an id, not a name.");
        }
        return this.datastoreEntity.getKey().getName();
    }

    private long fetchPKIdField() {
        Key key = this.datastoreEntity.getKey();
        if (key.getName() != null) {
            throw new NucleusFatalUserException("Attempting to fetch field with \"gae.pk-id\" extension but the entity is identified by a name, not an id.");
        }
        return this.datastoreEntity.getKey().getId();
    }

    private String fetchParentStringPKField(int fieldNumber) {
        Key parentKey = this.datastoreEntity.getKey().getParent();
        if (parentKey == null) {
            return null;
        }
        return KeyFactory.keyToString((Key)parentKey);
    }

    private String fetchStringPKField(int fieldNumber) {
        if (MetaDataUtils.isEncodedPKField(this.getClassMetaData(), fieldNumber)) {
            return KeyFactory.keyToString((Key)this.datastoreEntity.getKey());
        }
        if (this.datastoreEntity.getKey().isComplete() && this.datastoreEntity.getKey().getName() == null) {
            throw new NucleusFatalUserException("The primary key for " + this.getClassMetaData().getFullClassName() + " is an unencoded " + "string but the key of the corresponding entity in the datastore does not have a " + "name.  You may want to either change the primary key to be an encoded string " + "(add the \"" + "gae.encoded-pk" + "\" extension), change the " + "primary key to be of type " + Key.class.getName() + ", or, if you're certain that " + "this class will never have a parent, change the primary key to be of type Long.");
        }
        return this.datastoreEntity.getKey().getName();
    }

    protected String getPropertyName(int fieldNumber) {
        AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
        return EntityUtils.getPropertyName(this.getStoreManager().getIdentifierFactory(), ammd);
    }
}

